/************************************************************************/
/*	$Id: d70reader.c,v 1.21 2005/01/28 17:22:04 joman Exp joman $	*/
/*									*/
/*      Program name:   d70reader.c                                     */
/*                                                                      */
/*      This program will output image file EXIF data to the screen.    */
/*      This program was extended from my nefexif.c program. 		*/
/*      This may be compiled under Linux GCC like this:  cc d70reader.c */
/*      This can also be compiled within a Visual C++ project.          */
/************************************************************************/
/*	Revisions:							*/
/*									*/
/*	Version 0.01 - Sun Dec 12 12:11:21 EST 2004:			*/
/*		First coding to combine nefexif and jpgexif.		*/
/*	Version 0.02 - Thu Dec 23 14:13:18 EST 2004:			*/
/*		Added wildcard support.					*/
/*	Version 0.03 - Sun Dec 26 11:19:15 EST 2004:			*/
/*		Added edits for Format 7 tags.  Added the -v and -h	*/
/*		options.  Fixed a couple of Format 3 edits.		*/
/*	Version 0.04 - Mon Dec 27 16:19:25 EST 2004:			*/
/*		Added LensInfo.  Reformatted raw lens data to be	*/
/*		more presentable.  Truncated decimal part of 		*/
/*		focal length display.  Added to RCS revision system.	*/
/*	Version 0.05 - Wed Dec 29 16:01:24 EST 2004:			*/
/*		Added -w option.  This option will create an HTML	*/
/*		table of the EXIF data.  This can be then inserted	*/
/*		into an HTML document.					*/
/*	Version 0.06 - Thu Dec 30 16:20:39 EST 2004:			*/
/*		Added -x option.  This option outputs XML data.		*/
/*	Version 0.07 - Sat Jan  1 12:05:28 EST 2005:			*/
/*		Fixed UserComment.  Correct misspelling of 'seconds'.	*/
/*		Handled 'unknown' tag for D2H.				*/
/*	Version 0.08 - Mon Jan  3 23:03:38 EST 2005:			*/
/*		Added tag 8827 (ISO).  Modified to use right shift 	*/
/*		operators for selected formats that are less than 	*/
/*		4 bytes long.						*/
/*	Version 0.09 - Mon Jan 10 16:32:23 EST 2005:			*/
/*		Added -j option to extract JPG thumbnail image from	*/
/*		a NEF image.  Additional code cleanup.			*/
/*	Version 0.10 - Wed Jan 12 20:49:51 EST 2005:			*/
/*		Added -c option to generate CSV data.			*/
/*	Version 0.11 - Thu Jan 13 12:03:17 EST 2005:			*/
/*		Corrected a problem with the -c option.  Forgot to	*/
/*		include the image file name in the output! Also added	*/
/*		double quotes around the data elements.			*/
/*	Version 0.12 - Fri Jan 21 09:34:51 EST 2005:			*/
/*		When using option -j, to extract the JPG image from a	*/
/*		NEF image, write EXIF data to the new JPG file.  Also	*/
/*		modified the XML output to convert the tags to		*/
/*		lowercase.						*/
/*	Version 0.13 - Sat Jan 22 15:57:10 EST 2005:			*/
/*		Fixed a problem with wildcard processing, where the	*/
/*		program would stop on first error, instead of going	*/
/*		on to the next file in the list.  Also fixed, was the	*/
/*		JPEG marker scan logic.  Finally, changed the 'ifdef'	*/
/*		logic for the FreeBSD system compile.			*/
/*	Version 0.14 - Fri Jan 28 12:17:09 EST 2005:			*/
/*		Added logic to rotate the JPG image when the -j option	*/
/*		is used.  The source now uses the IJG JPEG library.	*/
/*		A configuration file called 'd70reader.conf' can be	*/
/*		used to select the tags that will be displayed.		*/
/*									*/
/************************************************************************/
#ifdef __OS2__
#define _TRUNCATE_DECLARED
#endif

#ifdef __FreeBSD__
#define _TRUNCATE_DECLARED
#endif

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>

#ifndef __APPLE__
#ifndef __FreeBSD__
#include <malloc.h>
#endif
#endif


#define D70_VERSION "0.14"
#define D70_DATE "Fri Jan 28 17:17:45 UTC 2005"

static char rcsid[] = "$Id: d70reader.c,v 1.21 2005/01/28 17:22:04 joman Exp joman $";

int iTrace = 0;		// set this with -t option 
int iVerbos = 0;	// set this with -v option
int iHtml = 0;		// set this with -w option
int iXml = 0;		// set this with -x option
int iThumbnail = 0;	// set this with -j option
int iCsv = 0;		// set this with -c option

int MotorolaOrder = 1;	//All NEF files that I have seen are MotorolaOrder files
			//Correction, Nikon Capture saves in Intel order!
int old_byte_order;
int iJPG_Type;
int iFile_Type;
int iCsv_First_Time = 1;
int iTagCount = 0;
int iSystemType = 0;

char * file_sys_dir_ptr = NULL;

struct html_header
{
	char * Desc;
	char * Value;
	struct html_header *next;
};

struct data_header
{
	unsigned short Tag;
        unsigned short field_type;         	/*field type          */
        unsigned long count;      		/*count               */
	char * Desc;
	char * Value;
	struct data_header *next;
};

struct jpg_data_header
{
	unsigned short tag;                     
	unsigned short field_type;              
	unsigned long count;                    
	unsigned long value_offset;             
	unsigned char *data_at_offset;
	int record_type;
	int byte_count;
	struct jpg_data_header *next;
};

struct data_header_ptr
{
	char *data_type;
	struct data_header *header_ptr;
	struct data_header_ptr *prev;
	struct data_header_ptr *next;
};

struct image_file_header
{
        char byte_order[2];                     /*byte order indicator 'II' or 'MM' */
        unsigned short image_file_type;         /*image file type                   */
        unsigned long offset_to_first_ifd;      /*offset to first IFD               */
};

struct jpg_image_file_header
{
	unsigned char start;
	unsigned char soi;
	unsigned char pad;
	unsigned char exif_ind;
	unsigned short length;
	char exif_header_text[6];
        char byte_order[2];                     /*byte order indicator 'II' or 'MM' */
        unsigned short image_file_type;         /*image file type                   */
        unsigned long offset_to_first_ifd;      /*offset to first IFD               */
};

struct image_file_directory_entry
{
        unsigned short tag;         		/*tag                 */
        unsigned short field_type;         	/*field type          */
        unsigned long count;      		/*count               */
        unsigned long value_offset;     	/*value offset        */
};

unsigned long lThumbnailOffset;
unsigned long lThumbnailLength;

struct wanted_tags
{
	unsigned short tag;
	struct wanted_tags *next;
};

struct wanted_tags *main_wanted_tags_ptr;
struct wanted_tags *start_wanted_tags_ptr;

char *get_description(char *str_input);
int is_tag_printed(unsigned short tag);
int tag_is_yes(char *local_ptr);
struct wanted_tags *get_new_main_wanted_tags_ptr();
void store_tags(char *local_ptr);
void check_for_config();
int jpegtran(int argc, char **argv);
int check_for_exif_data(FILE *rfd);
void output_thumbnail(char *filename, FILE *rfd);
void extract_and_format_data(struct image_file_directory_entry *ifde_ptr, struct data_header *local_ptr, int iHex);
char *strip(char *str_input);
void free_html_header_list(struct html_header *header_ptr);
void output_html();
void output_xml();
void output_csv();
struct html_header * get_new_html_header_ptr();
void debug_printf(char *str_format, unsigned short us_tag, char *str_desc, char *str_value);
void my_printf(char *str_format, char *str_desc, char *str_value);
char *truncate(char *str_token, int dec_len);
char * convert_lens(char *str_lens);
void free_data_header_list(struct data_header *header_ptr);
void free_memory(struct data_header_ptr *free_header_start_ptr, struct html_header *free_html_header_start_ptr);
void ProcessFile(int argc, char *filename);
void ProcessFileJPG(int argc, char *filename);
char *upper_case(char *local_ptr);
char *lower_case(char *local_ptr);
char *get_extension(char *string);
void get_xmp_data(FILE *rfd, struct data_header *local_ptr);
int jpg_type();
int jpg_type_offset();
unsigned long get_jpg_type_and_offset(FILE *rfd, unsigned long offset);
void my_exit(char *text_ptr);
void my_jpg_exit(char *text_ptr);
void display_data(struct data_header *local_ptr, char *data_type);
struct data_header * get_new_data_header_ptr();
struct data_header_ptr * get_new_main_header_ptr();
char * get_data_from_long(unsigned long Long);
void long_to_asc( unsigned long Lf15a_long_value, char *Lf15b_str_ptr, int Lf15c_length, char Lf15d_blank);
unsigned long rotate_right(unsigned long Long);
void  instruct(void);
int Get16u(void * Short);
unsigned Get32u(void * Long);
static int Get32s(void * Long);
static int Get32sTest(void * Long);
void my_error(FILE *rfd);
void print_8bit_bytes(unsigned char *byte_ptr, int ByteCount, struct data_header *local_ptr);
void print_8bit_hex(unsigned char *byte_ptr, int ByteCount, struct data_header *local_ptr);
void print_16bit_bytes(unsigned char *byte_ptr, int components, int ByteCount , struct data_header *local_ptr);
void print_iso_tag(unsigned long value, struct data_header *local_ptr);
void my_fseek(FILE *rfd, long pos, int offset);
unsigned int uGet16u(void * Short);
void dump_image_file_directory(FILE *rfd, unsigned long offset_ifd, unsigned long offset_base, struct data_header *local_ptr, char *type_ptr);
void dump_jpg_image_file_directory(FILE *rfd, unsigned long offset_ifd, unsigned long offset_base, char *type_ptr);
void trace(char *str);
void rev_memory( unsigned char *Lf07a_address, unsigned int Lf07b_length);
unsigned char * pad_field(unsigned char *temp_ptr, int length, char pad_char, int iPrePend);
unsigned long inspect_image_file_header(FILE *rfd, int iType);

#define NUM_FORMATS 12

#define FMT_BYTE       1
#define FMT_STRING     2
#define FMT_USHORT     3
#define FMT_ULONG      4
#define FMT_URATIONAL  5
#define FMT_SBYTE      6
#define FMT_UNDEFINED  7
#define FMT_SSHORT     8
#define FMT_SLONG      9
#define FMT_SRATIONAL 10
#define FMT_SINGLE    11
#define FMT_DOUBLE    12

#define TAG_EXIF_OFFSET		0x8769
#define TAG_MAKER_NOTE		0x927C
#define TAG_SUBIFD_S		0x014A
#define TAG_ORIENTATION		0x0112
#define TAG_THUMBNAIL_OFFSET	0x0201
#define TAG_THUMBNAIL_LENGTH	0x0202

#define MAKER_NOTE_PRE_HEADER_LENGTH	10
#define ASCII_LABEL_SKIP_LENGTH	8

struct data_header *header_ptr;
struct html_header *html_header_ptr = NULL;
struct html_header *html_header_start_ptr = NULL;

struct data_header_ptr main_header;
struct data_header_ptr *main_header_ptr = NULL;
struct data_header_ptr *main_header_start_ptr = NULL;

struct jpg_data_header *jpg_header_ptr;
struct jpg_data_header *start_header_ptr;
struct jpg_data_header *current_header_ptr;

typedef struct {
    unsigned short Tag;
    char * Desc;
}TagTable_t;

static TagTable_t TagTable[] = {
  { 0x001,   "FileSystemVersion          "},
  { 0x002,   "ISOUsed                    "},
  { 0x004,   "Quality                    "},
  { 0x005,   "WhilteBalance              "},
  { 0x006,   "Sharpening                 "},
  { 0x007,   "FocusMode                  "},
  { 0x008,   "FlashSetting               "},
  { 0x009,   "FlashMode                  "},
  { 0x00A,   "Unknown                    "},
  { 0x00B,   "WhiteBalanceFine           "},
  { 0x00C,   "WhiteBalanceRB             "},
  { 0x00D,   "Unknown                    "},
  { 0x00E,   "Unknown                    "},
  { 0x011,   "ThumbnailImageIFD          "},
  { 0x012,   "FlashCompensation          "},
  { 0x013,   "ISOSet                     "},
  { 0x016,   "Unknown                    "},
  { 0x017,   "Unknown                    "},
  { 0x018,   "Unknown                    "},
  { 0x019,   "Unknown                    "},
  { 0x081,   "ToneCompensation           "},
  { 0x083,   "LensType                   "},
  { 0x084,   "Lens                       "},
  { 0x087,   "FlashUsed                  "},
  { 0x088,   "AFPoint                    "},
  { 0x089,   "Unknown                    "},
  { 0x08A,   "Unknown                    "},
  { 0x08B,   "LensInfo                   "},
  { 0x08C,   "Curve                      "},
  { 0x08D,   "ColorMode                  "},
  { 0x08E,   "Unknown                    "},
  { 0x090,   "LightSource                "},
  { 0x091,   "Unknown                    "},
  { 0x092,   "HueAdjustment              "},
  { 0x093,   "Unknown                    "},
  { 0x095,   "NoiseReduction             "},
  { 0x096,   "NEFCurve2                  "},
  { 0x097,   "ColorBalanceD70            "},
  { 0x098,   "Unknown                    "},
  { 0x099,   "NEFThumbnailSize           "},
  { 0x09A,   "Unknown                    "},
  { 0x0A0,   "SerialNumber               "},
  { 0x0A1,   "Unknown                    "},
  { 0x0A2,   "Unknown                    "},
  { 0x0A3,   "Unknown                    "},
  { 0x0A4,   "Unknown                    "},
  { 0x0A5,   "Unknown                    "},
  { 0x0A6,   "Unknown                    "},
  { 0x0A7,   "ShutterCount               "},
  { 0x0A8,   "Unknown                    "},
  { 0x0A9,   "ImageOptimization          "},
  { 0x0AA,   "Saturation                 "},
  { 0x0AB,   "VariProgram                "},
  { 0x0FE,   "NewSubfileType             "},
  { 0x100,   "ImageWidth                 "},
  { 0x101,   "ImageLength                "},
  { 0x102,   "BitsPerSample              "},
  { 0x103,   "Compression                "},
  { 0x106,   "PhotometricInterpretation  "},
  { 0x10A,   "FillOrder                  "},
  { 0x10D,   "DocumentName               "},
  { 0x10E,   "ImageDescription           "},
  { 0x10F,   "Make                       "},
  { 0x110,   "Model                      "},
  { 0x111,   "StripOffsets               "},
  { 0x112,   "Orientation                "},
  { 0x115,   "SamplesPerPixel            "},
  { 0x116,   "RowsPerStrip               "},
  { 0x117,   "StripByteCounts            "},
  { 0x11A,   "XResolution                "},
  { 0x11B,   "YResolution                "},
  { 0x11C,   "PlanarConfiguration        "},
  { 0x128,   "ResolutionUnit             "},
  { 0x12D,   "TransferFunction           "},
  { 0x131,   "Software                   "},
  { 0x132,   "DateTime                   "},
  { 0x13B,   "Artist                     "},
  { 0x13E,   "WhitePoint                 "},
  { 0x13F,   "PrimaryChromaticities      "},
  { 0x14A,   "SubIFDs                    "},
  { 0x156,   "TransferRange              "},
  { 0x200,   "JPEGProc                   "},
  { 0x201,   "ThumbnailOffset            "},
  { 0x202,   "ThumbnailLength            "},
  { 0x211,   "YCbCrCoefficients          "},
  { 0x212,   "YCbCrSubSampling           "},
  { 0x213,   "YCbCrPositioning           "},
  { 0x214,   "ReferenceBlackWhite        "},
  { 0xE01,   "Unknown                    "},
  { 0xE05,   "Unknown                    "},
  { 0xE0E,   "Unknown                    "},
  { 0xE09,   "Unknown                    "},
  { 0xE10,   "Unknown                    "},
  { 0x1001,  "RelatedImageWidth          "},
  { 0x1002,  "RelatedImageLength         "},
  { 0x828D,  "CFARepeatPatternDim        "},
  { 0x828E,  "CFAPattern                 "},
  { 0x828F,  "BatteryLevel               "},
  { 0x8298,  "Copyright                  "},
  { 0x829A,  "ExposureTime               "},
  { 0x829D,  "FNumber                    "},
  { 0x83BB,  "IPTC/NAA                   "},
  { 0x8769,  "ExifOffset                 "},
  { 0x8773,  "InterColorProfile          "},
  { 0x8822,  "ExposureProgram            "},
  { 0x8824,  "SpectralSensitivity        "},
  { 0x8825,  "GPSInfo                    "},
  { 0x8827,  "ISOSpeedRatings            "},
  { 0x8828,  "OECF                       "},
  { 0x9000,  "ExifVersion                "},
  { 0x9003,  "DateTimeOriginal           "},
  { 0x9004,  "DateTimeDigitized          "},
  { 0x9101,  "ComponentsConfiguration    "},
  { 0x9102,  "CompressedBitsPerPixel     "},
  { 0x9201,  "ShutterSpeedValue          "},
  { 0x9202,  "ApertureValue              "},
  { 0x9203,  "BrightnessValue            "},
  { 0x9204,  "ExposureBiasValue          "},
  { 0x9205,  "MaxApertureValue           "},
  { 0x9206,  "SubjectDistance            "},
  { 0x9207,  "MeteringMode               "},
  { 0x9208,  "LightSource                "},
  { 0x9209,  "Flash                      "},
  { 0x920A,  "FocalLength                "},
  { 0x9216,  "TIFF_EPStandardId          "},
  { 0x9217,  "SensingMethod              "},
  { 0x927C,  "MakerNote                  "},
  { 0x9286,  "UserComment                "},
  { 0x9290,  "SubSecTime                 "},
  { 0x9291,  "SubSecTimeOriginal         "},
  { 0x9292,  "SubSecTimeDigitized        "},
  { 0xA000,  "FlashPixVersion            "},
  { 0xA001,  "ColorSpace                 "},
  { 0xA002,  "ExifImageWidth             "},
  { 0xA003,  "ExifImageLength            "},
  { 0xA004,  "RelatedAudioFile           "},
  { 0xA005,  "InteroperabilityOffset     "},
  { 0xA20B,  "FlashEnergy                "},
  { 0xA20C,  "SpatialFrequencyResponse   "},
  { 0xA20E,  "FocalPlaneXResolution      "},
  { 0xA20F,  "FocalPlaneYResolution      "},
  { 0xA210,  "FocalPlaneResolutionUnit   "},
  { 0xA214,  "SubjectLocation            "},
  { 0xA215,  "ExposureIndex              "},
  { 0xA217,  "SensingMethod              "},
  { 0xA300,  "FileSource                 "},
  { 0xA301,  "SceneType                  "},
  { 0xA302,  "CFA Pattern                "},
  { 0xa401,  "CustomRendered             "},
  { 0xa402,  "ExposureMode               "},
  { 0xa403,  "WhiteBalance               "},
  { 0xa404,  "DigitalZoomRatio           "},
  { 0xa405,  "FocalLengthIn35mmFilm      "},
  { 0xa406,  "SceneCaptureType           "},
  { 0xa407,  "GainControl                "},
  { 0xa408,  "Contrast                   "},
  { 0xa409,  "Saturation                 "},
  { 0xa40a,  "Sharpness                  "},
  { 0xa40c,  "SubjectDistanceRange       "},
  { 0xffff,  "XMP Data                   "}
} ;

const int SizeTagTable = sizeof( TagTable ) / sizeof( TagTable_t );

typedef unsigned char uchar;
char trace_buffer[256];

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
int main(argc, argv, env)
int argc;
char *argv[];
char* env[];
{
	int ctr1 = 0;
	int ctr2 = 0;
	int ctr3 = 0;
	int argn;
	char * arg;
	struct stat buf;
	char *filename;

	if(argc < 2)
	{
		instruct();
		exit(1);
	}

	for(argn = 1; argn < argc; argn++)
	{
		arg = argv[argn];

		if(arg[0] != '-') 
			break; // Filenames have started.

		if(!strcmp(arg,"-v"))
		{
			iVerbos = 1;
		}
		else if(!strcmp(arg,"-w"))
		{
			iHtml = 1;
		}
		else if(!strcmp(arg,"-c"))
		{
			iCsv = 1;
		}
		else if(!strcmp(arg,"-x"))
		{
			iXml = 1;
		}
		else if(!strcmp(arg,"-j"))
		{
			iThumbnail = 1;
		}
		else if(!strcmp(arg,"-t"))
		{
			iTrace = 1;
		}
		else if(!strcmp(arg,"-h"))
		{
			instruct();
			exit(1);
		}

		ctr1++;
	}

	if(argc == argn)
	{
		instruct();
		exit(1);
	}

	do
	{
		if(iTrace)
			printf("\n%s", env[ctr3]);

		if(!memcmp(upper_case(env[ctr3]), "PATH=", 5))
		{
			if(memchr(env[ctr3],'\\', 20))
				iSystemType = 1;
			else
				iSystemType = 0;
		}

		if(!memcmp(upper_case(env[ctr3]), "WINDIR=", 7))
		{
			file_sys_dir_ptr = (char *) malloc(strlen(env[ctr3]) + 1);
			memset(file_sys_dir_ptr, (int) NULL, strlen(env[ctr3]) + 1);
			memcpy(file_sys_dir_ptr, &env[ctr3][7], strlen(env[ctr3]) - 7);
		}

/* BRN:
Look for ETC variable in OS/2.
*/
		if(!memcmp(upper_case(env[ctr3]), "ETC=", 4))
		{
printf("%s\n",env[ctr3]);
			file_sys_dir_ptr = (char *) malloc(strlen(env[ctr3]) + 1);
			memset(file_sys_dir_ptr, (int) NULL, strlen(env[ctr3]) + 1);
			memcpy(file_sys_dir_ptr, &env[ctr3][4], strlen(env[ctr3]) - 4);
printf("%s\n",file_sys_dir_ptr);
		}

		ctr3++;
	}
	while(env[ctr3] != NULL);

	if(!iSystemType)
	{
		file_sys_dir_ptr = (char *) malloc(strlen("/etc") + 1);
		memset(file_sys_dir_ptr, (int) NULL, strlen("/etc") + 1);
		memcpy(file_sys_dir_ptr, "/etc", strlen("/etc"));
	}

/* Suggestion by BRN, in case nothing is set */
if (file_sys_dir_ptr == NULL)
{
  file_sys_dir_ptr = (char *) malloc(512);
  strcpy (file_sys_dir_ptr, "");
}


	check_for_config();

	for(ctr2 = 0; ctr2 < ctr1; ctr2++)
		argv++;

        while(filename = *++argv)
        {
		if(stat(filename, &buf) == (-1))
		{
			perror(filename);
		}
		else
		{
			if(iThumbnail)
				ProcessFileJPG(argc, filename);
			else
				ProcessFile(argc, filename);
		}
        }

        return 0;
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void ProcessFile(int argc, char *filename)
{
        FILE *rfd;
        char buffer[256];
	char *temp_ptr = NULL;
	unsigned long offset_ifd;
	long old_position;
	int ctr1 = 0;
	struct data_header_ptr *temp_header_start_ptr = NULL;
	struct data_header_ptr *free_header_start_ptr = NULL;
	struct html_header *free_html_header_start_ptr = NULL;

	trace("+ProcessFile\n");

	if((rfd = fopen(filename, "rb")) == NULL)
	{
		printf("\nFile not found: %s\n\n", filename);
		exit(1);
	}

	temp_ptr = get_extension(filename);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "File Extension: %s\n", temp_ptr);
	trace(trace_buffer);

	if(!strncmp(upper_case(temp_ptr), "JPG", 3))
	{
		iFile_Type = 0;
	}
	else
	{
		iJPG_Type = 99;
		iFile_Type = 1;
	}

	if((!iHtml) && (!iXml) && (!iCsv))
	{
		printf("\nD70ReaderProgramVersion    : %s", D70_VERSION);
		printf("\nFilename                   : %s", filename);
	}

	if(!iFile_Type)
	{
		if(!check_for_exif_data(rfd))
		{
			if(!iCsv)
				printf("\nNo EXIF data found\n");

			return;
		}
	}

	if((iHtml) || (iXml) || (iCsv))
	{
		if(iTrace)
		{
			debug_printf("%x %s %s", 0xFFFE, "D70ReaderProgramVersion    ", D70_VERSION);
			debug_printf("%x %s %s", 0xFFFE, "Filename                   ", filename);
		}
		else
		{
			my_printf("%s %s", "D70ReaderProgramVersion    ", D70_VERSION);
			my_printf("%s %s", "Filename                   ", filename);
		}
	}

	memset(buffer, (int) NULL, 256);
	sprintf(buffer, "IFD%d", ctr1++);

	offset_ifd = inspect_image_file_header(rfd, iFile_Type);
	dump_image_file_directory(rfd, offset_ifd, jpg_type_offset(), get_new_data_header_ptr(), buffer);

	old_position = ftell(rfd);
	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "old_position: %x\n", old_position);
	trace(trace_buffer);

	fread(&offset_ifd, sizeof(unsigned long), 1, rfd);
	offset_ifd = Get32u(&offset_ifd);
	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "offset_ifd: %x\n", offset_ifd);
	trace(trace_buffer);

	if(jpg_type() == 0)
	{
		get_xmp_data(rfd, get_new_data_header_ptr());
	}

	fclose(rfd);

	temp_header_start_ptr = main_header_start_ptr;
	free_header_start_ptr = main_header_start_ptr;

	if(iTrace || iVerbos)
	{
		printf("\n--------------START OF RAW DATA---------------\n");

		ctr1 = 0;

		while(main_header_start_ptr->next != NULL)
		{
			header_ptr = main_header_start_ptr->header_ptr;

			while(header_ptr->next != NULL)
			{
				if(header_ptr->Tag != 0)
					printf("\n(%d) - %s - FMT: %d - NUM: %ld - TAG: %#x: %s: %s", ctr1++, main_header_start_ptr->data_type, header_ptr->field_type, header_ptr->count, header_ptr->Tag, header_ptr->Desc, header_ptr->Value);
	
				header_ptr = header_ptr->next;
			}

			main_header_start_ptr = main_header_start_ptr->next;
		}

		header_ptr = main_header_start_ptr->header_ptr;

		//special case for XMP data
		if(header_ptr->Tag == 0xFFFF)
			printf("\n(%d) - %s - FMT: %d - NUM: %ld - TAG: %#x: %s: %s", ctr1++, main_header_start_ptr->data_type, header_ptr->field_type, header_ptr->count, header_ptr->Tag, header_ptr->Desc, header_ptr->Value);

		while(header_ptr->next != NULL)
		{
			if(header_ptr->Tag != 0)
					printf("\n(%d) - %s - FMT: %d - NUM: %ld - TAG: %#x: %s: %s", ctr1++, main_header_start_ptr->data_type, header_ptr->field_type, header_ptr->count, header_ptr->Tag, header_ptr->Desc, header_ptr->Value);

			header_ptr = header_ptr->next;
		}

		printf("\n--------------END OF RAW DATA---------------\n");
	}

	if(iTrace)
		printf("\n--------------START NEW DATA DISPLAY---------------\n");

	ctr1 = 0;

	while(temp_header_start_ptr->next != NULL)
	{
		display_data(temp_header_start_ptr->header_ptr, temp_header_start_ptr->data_type);

		temp_header_start_ptr = temp_header_start_ptr->next;
	}

	display_data(temp_header_start_ptr->header_ptr, temp_header_start_ptr->data_type);

	if(iTrace)
		printf("\n\n--------------END NEW DATA DISPLAY---------------\n");

	free_html_header_start_ptr = html_header_start_ptr;

	if(iHtml)
		output_html();

	if(iXml)
		output_xml();

	if(iCsv)
		output_csv();

	if((!iHtml) && (!iXml) && (!iCsv))
		printf("\n\n");

	free_memory(free_header_start_ptr, free_html_header_start_ptr);

	trace("-ProcessFile\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void output_xml()
{
	struct html_header *local_header_start_ptr = NULL;

	trace("+output_xml\n");

	local_header_start_ptr = html_header_start_ptr;

	printf("\n\n<?xml version=\"1.0\" standalone=\"yes\"?>\n");
	printf("<data>\n");

	while(local_header_start_ptr->next != NULL)
	{
		printf("<%s>%s</%s>\n", lower_case(strip(local_header_start_ptr->Desc)), local_header_start_ptr->Value, lower_case(strip(local_header_start_ptr->Desc)));

		local_header_start_ptr = local_header_start_ptr->next;
	}

	printf("<%s>%s</%s>\n", lower_case(strip(local_header_start_ptr->Desc)), local_header_start_ptr->Value, lower_case(strip(local_header_start_ptr->Desc)));
	printf("</data>\n");

	trace("-output_xml\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void output_csv()
{
	struct html_header *local_header_start_ptr = NULL;

	trace("+output_csv\n");

	local_header_start_ptr = html_header_start_ptr;

	if(iCsv_First_Time)
	{
		while(local_header_start_ptr->next != NULL)
		{
			printf("%s,", strip(local_header_start_ptr->Desc));

			local_header_start_ptr = local_header_start_ptr->next;
		}

		printf("%s\n", strip(local_header_start_ptr->Desc));

		iCsv_First_Time = 0;
	}

	local_header_start_ptr = html_header_start_ptr;

	while(local_header_start_ptr->next != NULL)
	{
		printf("\"%s\",", local_header_start_ptr->Value);

		local_header_start_ptr = local_header_start_ptr->next;
	}

	printf("\"%s\"\n", local_header_start_ptr->Value);

	trace("-output_csv\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
char *strip(char *str_input)
{
	char *temp_ptr;
	char *token;

	trace("+strip\n");

	temp_ptr = strdup(str_input);

	token = strtok(temp_ptr, " ");

	trace("-strip\n");
	return(token);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void output_html()
{
	struct html_header *local_header_start_ptr = NULL;

	trace("+output_html\n");

	local_header_start_ptr = html_header_start_ptr;

	printf("\n\n<table border=\"1\" width=\"450\" cellpadding=\"1\" align=\"center\">\n");

	while(local_header_start_ptr->next != NULL)
	{
		printf("<tr><td>%s</td><td>%s</td></tr>\n", local_header_start_ptr->Desc, local_header_start_ptr->Value);

		local_header_start_ptr = local_header_start_ptr->next;
	}

	printf("<tr><td>%s</td><td>%s</td></tr>\n", local_header_start_ptr->Desc, local_header_start_ptr->Value);

	printf("</table>\n");

	trace("-output_html\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void free_memory(struct data_header_ptr *free_header_start_ptr, struct html_header *free_html_header_start_ptr)
{
	struct data_header_ptr *temp_header_start_ptr = NULL;
	struct data_header_ptr *tmp2_header_start_ptr = NULL;

	trace("+free_memory\n");

	temp_header_start_ptr = free_header_start_ptr;

	while(temp_header_start_ptr->next != NULL)
	{
		tmp2_header_start_ptr = temp_header_start_ptr;
		free_data_header_list(temp_header_start_ptr->header_ptr);
		temp_header_start_ptr = temp_header_start_ptr->next;
		free(tmp2_header_start_ptr);
	}

	free(temp_header_start_ptr);

	main_header_ptr = NULL;
	main_header_start_ptr = NULL;

	free_html_header_list(free_html_header_start_ptr);
	html_header_ptr = NULL;

	trace("-free_memory\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void free_data_header_list(struct data_header *header_ptr)
{
	struct data_header *temp_header_ptr = NULL;

	trace("+free_data_header_list\n");

	while(header_ptr->next != NULL)
	{
		temp_header_ptr = header_ptr;
		header_ptr = header_ptr->next;
		free(temp_header_ptr);
	}

	free(header_ptr);
	trace("-free_data_header_list\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void free_html_header_list(struct html_header *header_ptr)
{
	struct html_header *temp_header_ptr = NULL;

	trace("+free_html_header_list\n");

	while(header_ptr->next != NULL)
	{
		temp_header_ptr = header_ptr;
		header_ptr = header_ptr->next;
		free(temp_header_ptr);
	}

	free(header_ptr);
	trace("-free_html_header_list\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
char *upper_case(char *local_ptr)
{
	int ctr1;
	int length;
	char *temp_ptr;
	char *final_ptr;

	trace("+upper_case\n");

	temp_ptr = strdup(local_ptr);
	final_ptr = temp_ptr;

	length = strlen(temp_ptr);

	for(ctr1 = 0; ctr1 < length; ctr1++)
	{
		*temp_ptr = toupper(*temp_ptr);
		temp_ptr++;
	}

	trace("-upper_case\n");

	return(final_ptr);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
char *lower_case(char *local_ptr)
{
	int ctr1;
	int length;
	char *temp_ptr;
	char *final_ptr;

	trace("+lower_case\n");

	temp_ptr = strdup(local_ptr);
	final_ptr = temp_ptr;

	length = strlen(temp_ptr);

	for(ctr1 = 0; ctr1 < length; ctr1++)
	{
		*temp_ptr = tolower(*temp_ptr);
		temp_ptr++;
	}

	trace("-lower_case\n");

	return(final_ptr);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
char *get_extension(char *string)
{
	char *temp_ptr;
	char *final_ptr;
	char *token;

	trace("+get_extension\n");

	temp_ptr = strdup(string);

	token = strtok(temp_ptr, ".");

	do
	{
		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "token: %s\n", token);
		trace(trace_buffer);

		if(token != NULL)
			final_ptr = token;

		token = strtok(NULL, ".");
	}
	while(token != NULL);

	trace("-get_extension\n");
	return(final_ptr);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void get_xmp_data(FILE *rfd, struct data_header *local_ptr)
{
	int ctr1 = 0;
	int iFoundHTTP = 0;
	unsigned char *data_ptr;

	unsigned short length;
	long position;
	int oldMotorolaOrder;

	struct marker
	{
		unsigned char pad;
		unsigned char marker;
		unsigned short length;
		char test_data[6];
	};

	struct marker *temp_ptr;

	oldMotorolaOrder = MotorolaOrder;
	MotorolaOrder = 1;

	temp_ptr = (struct marker *) malloc(sizeof(struct marker));
	memset(temp_ptr, (int) NULL, sizeof(struct marker));

	fseek(rfd, 2, 0);

	do
	{
		ctr1++;
		position = ftell(rfd);

		memset(temp_ptr, (int) NULL, sizeof(struct marker));
		fread(temp_ptr, sizeof(struct marker), 1, rfd);

		length = Get16u(&temp_ptr->length);

		if(!strncmp(temp_ptr->test_data, "http:", strlen("http:")))
		{
			iFoundHTTP = 1;
			break;
		}
		else
			fseek(rfd, Get16u(&temp_ptr->length) - sizeof(struct marker) + 2, 1);

		if(temp_ptr->marker == 0xda)
			break;
	}
	while(strncmp(temp_ptr->test_data, "http:", strlen("http:")));	

	if(iFoundHTTP)
	{
		data_ptr = (unsigned char *) malloc(Get16u(&temp_ptr->length));
		memset(data_ptr, (int) NULL, Get16u(&temp_ptr->length));

		fseek(rfd, position + 4, 0);
		fread(data_ptr, Get16u(&temp_ptr->length), 1, rfd);

		while(*data_ptr != (unsigned char) NULL)
			data_ptr++;

		data_ptr++;

		local_ptr->Tag = 0xFFFF;
		local_ptr->field_type = 2;
		local_ptr->count = Get16u(&temp_ptr->length);
		local_ptr->Desc = "XMP Data";
		local_ptr->Value = data_ptr;
		
		main_header_ptr->next = get_new_main_header_ptr();
		main_header_ptr->prev =  main_header_ptr;
		main_header_ptr =  main_header_ptr->next;
		main_header_ptr->header_ptr = local_ptr;
		main_header_ptr->data_type = (char *) malloc(strlen("XMP") + 1);
		memset(main_header_ptr->data_type, (int) NULL, strlen("XMP") + 1);
		strncpy(main_header_ptr->data_type, "XMP", strlen("XMP"));
	}

	MotorolaOrder = oldMotorolaOrder;
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void rev_memory( unsigned char *Lf07a_address, unsigned int Lf07b_length)
{
	unsigned char Lf07c_hold_val;
	unsigned int Lf07d_offset;

	trace("+rev_memory\n");

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "Lf07a_address: %s\n", Lf07a_address);
	trace(trace_buffer);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "Lf07b_length: %d\n", Lf07b_length);
	trace(trace_buffer);

	Lf07d_offset = 0;

	while (Lf07d_offset < Lf07b_length)
	{
		Lf07c_hold_val = Lf07a_address[Lf07d_offset];
		Lf07a_address[Lf07d_offset++] = Lf07a_address[--Lf07b_length];
		Lf07a_address[Lf07b_length] = Lf07c_hold_val;
	}

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "Lf07a_address: %s\n", Lf07a_address);
	trace(trace_buffer);

	trace("-rev_memory\n");

	return;
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
unsigned char * pad_field(unsigned char *str_ptr, int length, char pad_char, int iPrePend)
{
	int ctr1;
	unsigned char *temp_ptr;
	unsigned char buffer[2];

	trace("+pad_field\n");

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "str_ptr: %s\n", str_ptr);
	trace(trace_buffer);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "length: %d\n", length);
	trace(trace_buffer);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "pad_char: %c\n", pad_char);
	trace(trace_buffer);

	memset(buffer, (int) NULL, 2);
	buffer[0] = pad_char;

	temp_ptr = (unsigned char *) malloc(strlen(str_ptr) + length + 1);
	memset(temp_ptr, (int) NULL, strlen(str_ptr) + length + 1);

	if(iPrePend)
	{
		for(ctr1 = 0; ctr1 < (length - (int) strlen(str_ptr)); ctr1++)
		{
			strcat(temp_ptr, buffer);
		}

		strcat(temp_ptr, str_ptr);
	}
	else
	{
		strcat(temp_ptr, str_ptr);

		for(ctr1 = 0; ctr1 < (length - (int) strlen(str_ptr)); ctr1++)
		{
			strcat(temp_ptr, buffer);
		}
	}

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "temp_ptr: %s\n", temp_ptr);
	trace(trace_buffer);

	trace("-pad_field\n");

	return temp_ptr;
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void print_8bit_hex(unsigned char *byte_ptr, int ByteCount, struct data_header *local_ptr)
{
	int ctr1;
	char buffer[256];

	trace("\n+print_8bit_hex\n");

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "byte_ptr: %s\n", byte_ptr);
	trace(trace_buffer);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "ByteCount: %d\n", ByteCount);
	trace(trace_buffer);

	memset(buffer, (int) NULL, 256);

	for(ctr1 = 0; ctr1 < ByteCount; ctr1++)
	{
		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "%x ", *byte_ptr);
		trace(trace_buffer);
		strcat(buffer, trace_buffer);
		byte_ptr++;
	}

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "%s ", buffer); 
	trace(trace_buffer);

	local_ptr->Value = (char *) malloc(strlen(trace_buffer) + 1);
	strcpy(local_ptr->Value, trace_buffer);

	trace("\n-print_8bit_hex\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void print_8bit_bytes(unsigned char *byte_ptr, int ByteCount, struct data_header *local_ptr)
{
	int ctr1;
	char buffer[256];

	trace("+print_8bit_bytes\n");

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "byte_ptr: %s\n", byte_ptr);
	trace(trace_buffer);

	memset(buffer, (int) NULL, 256);

	for(ctr1 = 0; ctr1 < ByteCount; ctr1++)
	{
		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "%c ", *byte_ptr);
		trace(trace_buffer);
		strcat(buffer, trace_buffer);
		byte_ptr++;
	}

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "%s ", buffer); 

	local_ptr->Value = (char *) malloc(strlen(trace_buffer) + 1);
	strcpy(local_ptr->Value, trace_buffer);

	trace("\n-print_8bit_bytes\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void print_16bit_hex(unsigned char *byte_ptr, int components, int ByteCount, struct data_header *local_ptr)
{
	int ctr1;
	char * temp_ptr;
	char buffer[256];

	trace("+print_16bit_hex\n");

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "byte_ptr: %s\n", byte_ptr);
	trace(trace_buffer);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "components: %d\n", components);
	trace(trace_buffer);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "ByteCount: %d\n", ByteCount);
	trace(trace_buffer);

	temp_ptr = strdup(byte_ptr);

	memset(buffer, (int) NULL, 256);

	for(ctr1 = 0; ctr1 < components; ctr1++)
	{
		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "\nctr1: %d\n", ctr1);
		trace(trace_buffer);

		memset(trace_buffer, (int) NULL, 256);
		strncpy(trace_buffer, temp_ptr, ByteCount);
		trace(trace_buffer);
		strcat(buffer, trace_buffer);
		strcat(buffer, " ");

		temp_ptr += ByteCount;
	}

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "\nBUFFER: %s\n", buffer);
	trace(trace_buffer);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "%s ", buffer); 

	local_ptr->Value = (char *) malloc(strlen(trace_buffer) + 1);
	strcpy(local_ptr->Value, trace_buffer);

	trace("\n-print_16bit_hex\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void print_16bit_bytes(unsigned char *byte_ptr, int components, int ByteCount, struct data_header *local_ptr)
{
	int ctr1;
	char * temp_ptr;
	char buffer[256];

	trace("+print_16bit_bytes\n");

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "byte_ptr: %s\n", byte_ptr);
	trace(trace_buffer);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "components: %d\n", components);
	trace(trace_buffer);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "ByteCount: %d\n", ByteCount);
	trace(trace_buffer);

	temp_ptr = strdup(byte_ptr);

	memset(buffer, (int) NULL, 256);

	for(ctr1 = 0; ctr1 < components; ctr1++)
	{
		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "\nctr1: %d\n", ctr1);
		trace(trace_buffer);

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "%s ", temp_ptr);
		trace(trace_buffer);
		strcat(buffer, trace_buffer);

		temp_ptr += 2;
	}

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "\nBUFFER: %s\n", buffer);
	trace(trace_buffer);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "%s ", buffer); 

	local_ptr->Value = (char *) malloc(strlen(trace_buffer) + 1);
	strcpy(local_ptr->Value, trace_buffer);

	trace("\n-print_16bit_bytes\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void print_iso_tag(unsigned long value, struct data_header *local_ptr)
{
	char buffer[256];

	unsigned long val1 = value;
	unsigned long val2 = value;

	trace("+print_iso_tag\n");

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "value: %x\n", value);
	trace(trace_buffer);

	memset(buffer, (int) NULL, 256);

	if(MotorolaOrder)
		sprintf(buffer, "%ld", val1 );
	else
		sprintf(buffer, "%ld", rotate_right( val1 ) );

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "0x%8.8lx\n", rotate_right( val1) );
	trace(trace_buffer);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "%s ", buffer); 

	local_ptr->Value = (char *) malloc(strlen(trace_buffer) + 1);
	strcpy(local_ptr->Value, trace_buffer);

	trace("\n-print_iso_tag\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void my_error(FILE *rfd)
{
	if(ferror(rfd))
	{
		printf("Error number: %d", fileno(rfd));
		exit(1);
	}
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void  instruct()                                /*give instructions for use     */
{
        printf("\nD70Reader - Version %s - %s\n", D70_VERSION, D70_DATE); 
        printf("\nThis is a Freeware program, use at your own risk.\n");

	printf("\nThis software makes use of \"The Independent JPEG Group's JPEG Software\"");
	printf("\nSpecifically, it uses their image rotation logic.");
	printf("\nPlease read their copyright information, found in the jpeglib/README file.\n");

        printf("\nThis program only works with Nikon D70/D100 image files.");
        printf("\n(It will work with NEF/RAW and JPG files.)\n");

        printf("\nCheck here for latest version:");
        printf("\nhttp://home.comcast.net/~jonathan.oman/d70/index.html\n");

        printf("\nFormat:");
        printf("\n\td70reader [-h|-v|-w|-x|-j|-c] image_file_name\n");
        printf("\n\td70reader [-h|-v|-w|-x|-j|-c] *.NEF *.JPG\n");
        printf("\n\t-h = this screen");
        printf("\n\t-v = verbose (raw data)");
        printf("\n\t-w = generate HTML table");
        printf("\n\t-x = generate XML tree");
        printf("\n\t-j = extract JPG thumbnail image from NEF");
        printf("\n\t-c = generate Comma Separated Values (CSV) data\n\n");

	printf("Press <Enter> to Continue\n\n");
	getchar();

	printf("I am trying to make sense out of the following EXIF tags:\n\n");

	printf("AF-S DX Zoom-Nikkor ED G IF:\n\n");
	printf("LensType : 6\n");
	printf("Lens : 18-70mm f/3.5-f/4.5\n");
	printf("LensInfo : 40 01 0c 00\n\n");

	printf("AF Zoom-Nikkor D:\n\n");
	printf("LensType : 2\n");
	printf("Lens : 70-300mm f/4.0-f/5.6\n");
	printf("LensInfo : 48 01 0c 00\n\n");

	printf("AF Nikkor D:\n\n");
	printf("LensType : 2\n");
	printf("Lens : 50mm f/1.8\n");
	printf("LensInfo : 58 01 0c 00\n\n");

	printf("AF Micro-Nikkor D:\n\n");
	printf("LensType : 2\n");
	printf("Lens : 60mm f/2.8\n");
	printf("LensInfo : 54 01 0c 00 \n\n");

	printf("I have identified the tag information for the above four lenses.\n");
	printf("If you would like to help me decode the lens information into\n");
	printf("something that makes sense (like my above lens descriptions),\n");
	printf("please send me the above three EXIF data tags for your lenses,\n");
	printf("to the following email address:\n\n");
	printf("jonathan.oman@comcast.net\n\n");


}

//--------------------------------------------------------------------------
// Convert a 16 bit unsigned value from file's native byte order
//--------------------------------------------------------------------------
static void Put16u(void * Short, unsigned short PutValue)
{
	if (MotorolaOrder)
	{
		((uchar *)Short)[0] = (uchar)(PutValue>>8);
		((uchar *)Short)[1] = (uchar)PutValue;
	}
	else
	{
		((uchar *)Short)[0] = (uchar)PutValue;
		((uchar *)Short)[1] = (uchar)(PutValue>>8);
	}
}

//--------------------------------------------------------------------------
// Convert a 16 bit unsigned value from file's native byte order
//--------------------------------------------------------------------------
int Get16u(void * Short)
{
	if (MotorolaOrder)
	{
		return (((uchar *)Short)[0] << 8) | ((uchar *)Short)[1];
	}
	else
	{
		return (((uchar *)Short)[1] << 8) | ((uchar *)Short)[0];
	}
}

//--------------------------------------------------------------------------
// Convert a 16 bit unsigned value from file's native byte order
//--------------------------------------------------------------------------
unsigned int uGet16u(void * Short)
{
	if (MotorolaOrder)
	{
		return (((uchar *)Short)[0] << 8) | ((uchar *)Short)[1];
	}
	else
	{
		return (((uchar *)Short)[1] << 8) | ((uchar *)Short)[0];
	}
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
unsigned long rotate_right(unsigned long Long)
{

	unsigned long mByte0;

	mByte0 = Long >> 16;

	return(mByte0);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
static int Get32s(void * Long)
{
	if (MotorolaOrder)
	{
		return  ((( char *)Long)[0] << 24) | (((uchar *)Long)[1] << 16)
			| (((uchar *)Long)[2] << 8 ) | (((uchar *)Long)[3] << 0 );
	}
	else
	{
		return  ((( char *)Long)[3] << 24) | (((uchar *)Long)[2] << 16)
			| (((uchar *)Long)[1] << 8 ) | (((uchar *)Long)[0] << 0 );
	}
}

//--------------------------------------------------------------------------
// Convert a 32 bit unsigned value from file's native byte order
//--------------------------------------------------------------------------
unsigned Get32u(void * Long)
{
	return (unsigned)Get32s(Long) & 0xffffffff;
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void my_fseek(FILE *rfd, long pos, int offset)
{
	long new_pos;

	trace("+my_fseek\n");

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "pos: %x\n", pos);
	trace(trace_buffer);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "offset: %d\n", offset);
	trace(trace_buffer);
	
	if((new_pos = fseek(rfd, pos, offset)) != -1)
	{
		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "new_pos: %ld\n", new_pos);
		trace(trace_buffer);

		trace("-my_fseek\n");
		return;
	}
	else
	{
		my_error(rfd);
		exit(1);
	}

	trace("-my_fseek\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void dump_image_file_directory(FILE *rfd, unsigned long offset_ifd, unsigned long offset_base, struct data_header *local_ptr, char *type_ptr)
{
	char *buff_ptr = NULL;
	char buffer[256];
	char type_buffer[256];
	struct image_file_directory_entry *ifde_ptr;
	unsigned short count;
	unsigned short num_ifd;
	int a;
	unsigned long ctr1;
	unsigned long ctr2;
	unsigned long ctr3;
	long old_position;
	long temp_position;
	int ByteCount;
	unsigned long components;      		//count
	unsigned long value_offset;     	//value offset
	unsigned char *byte_ptr;
	unsigned short *short_byte_ptr;
	unsigned long *long_byte_ptr;

	unsigned long numirator;
	unsigned long denominator;
	unsigned long numirator_cnvtd;
	unsigned long denominator_cnvtd;

	long snumirator;
	long sdenominator;
	long snumirator_cnvtd;
	long sdenominator_cnvtd;

	double num;
	double den;

	unsigned long maker_note_header_offset;

	trace("+dump_image_file_directory\n");

	if(main_header_ptr == NULL)
	{
		main_header_ptr = get_new_main_header_ptr();
		main_header_ptr->header_ptr = local_ptr;
		main_header_ptr->data_type = (char *) malloc(strlen(type_ptr) + 1);
		memset(main_header_ptr->data_type, (int) NULL, strlen(type_ptr) + 1);
		strncpy(main_header_ptr->data_type, type_ptr, strlen(type_ptr));
		main_header_start_ptr = main_header_ptr;
	}
	else
	{
		main_header_ptr->next = get_new_main_header_ptr();
		main_header_ptr->prev =  main_header_ptr;
		main_header_ptr =  main_header_ptr->next;
		main_header_ptr->header_ptr = local_ptr;
		main_header_ptr->data_type = (char *) malloc(strlen(type_ptr) + 1);
		memset(main_header_ptr->data_type, (int) NULL, strlen(type_ptr) + 1);
		strncpy(main_header_ptr->data_type, type_ptr, strlen(type_ptr));
	}

	ifde_ptr = (struct image_file_directory_entry *) malloc(sizeof(struct image_file_directory_entry));
	memset(ifde_ptr, (int) NULL, sizeof(struct image_file_directory_entry));

	if(fseek(rfd, offset_ifd, 0) != -1)
	{
		fread(&count, sizeof(unsigned short), 1, rfd);
		num_ifd = Get16u(&count);

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "Number of Image File Directories: %d\n", num_ifd);
		trace(trace_buffer);
	}
	else
	{
		my_error(rfd);
	}

	for(ctr1 = 0; ctr1 < num_ifd; ctr1++)
	{
		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "\nctr1: %d\n", ctr1);
		trace(trace_buffer);

		memset(ifde_ptr, (int) NULL, sizeof(struct image_file_directory_entry));
		fread(ifde_ptr, sizeof(struct image_file_directory_entry), 1, rfd);

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "Tag: %x\n", Get16u(&ifde_ptr->tag));
		trace(trace_buffer);

		local_ptr->Tag = Get16u(&ifde_ptr->tag);
		local_ptr->field_type = Get16u(&ifde_ptr->field_type);
		local_ptr->count = Get32u(&ifde_ptr->count);

		for (a = 0; ;a++)
		{
			if (a >= SizeTagTable )
			{
				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "    Unknown Tag %04x Value = ", Get16u(&ifde_ptr->tag));
				trace(trace_buffer);

				local_ptr->Desc = (char *) malloc(strlen(trace_buffer) + 1);
				strcpy(local_ptr->Desc, trace_buffer);
				break;
			}

			if (TagTable[a].Tag == Get16u(&ifde_ptr->tag))
			{
				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "%s",TagTable[a].Desc); 
				trace(trace_buffer);

				local_ptr->Desc = (char *) malloc(strlen(trace_buffer) + 1);
				strcpy(local_ptr->Desc, trace_buffer);
				break;
			}
		}

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "Field Type: %x\n", Get16u(&ifde_ptr->field_type));
		trace(trace_buffer);

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "Number of Values: %x\n", Get32u(&ifde_ptr->count));
		trace(trace_buffer);

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "Value Offset: %x\n", Get32u(&ifde_ptr->value_offset));
		trace(trace_buffer);

		components = Get32u(&ifde_ptr->count);
		value_offset = Get32u(&ifde_ptr->value_offset) + offset_base;

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "components: %d\n", components);
		trace(trace_buffer);

		old_position = ftell(rfd);

		switch(Get16u(&ifde_ptr->field_type))
		{
			case 1:
				ByteCount = components * 1;
				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "ByteCount: %d\n", ByteCount);
				trace(trace_buffer);

				byte_ptr = (unsigned char *) malloc(ByteCount);

				if (ByteCount > 4)
				{
					fseek(rfd, Get32u(&ifde_ptr->value_offset), 0);
					fread(byte_ptr, ByteCount, 1, rfd);
				}
				else
				{
					extract_and_format_data(ifde_ptr, local_ptr, 0);
					break;
				}

				print_8bit_bytes(byte_ptr, ByteCount, local_ptr);

				break;
			case 2:
				ByteCount = components * 1;

				if (ByteCount > 4)
				{
					fseek(rfd, Get32u(&ifde_ptr->value_offset) + offset_base, 0);
					
					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "\nvalue_offset: %x", Get32u(&ifde_ptr->value_offset)); 
					trace(trace_buffer);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "\noffset_base: %x\n", offset_base); 
					trace(trace_buffer);

					buff_ptr = (char *) malloc(components + 1);

					fread(buff_ptr, components, 1, rfd);
					trace(buff_ptr);

					local_ptr->Value = (char *) malloc(strlen(buff_ptr) + 1);
					strcpy(local_ptr->Value, buff_ptr);

					free(buff_ptr);
				}
				else
				{
					extract_and_format_data(ifde_ptr, local_ptr, 0);
				}
				break;
			case 3:
			case 8:
				ByteCount = components * 2;
				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "ByteCount: %d\n", ByteCount);
				trace(trace_buffer);

				if (ByteCount > 4)
				{
					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "Value Offset: %x\n", Get32u(&ifde_ptr->value_offset));
					trace(trace_buffer);

					my_fseek(rfd, Get32u(&ifde_ptr->value_offset), 0);
					temp_position = ftell(rfd);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "temp_position: %x\n", temp_position);
					trace(trace_buffer);

					for(ctr3 = 0; ctr3 < components; ctr3++)
					{
						short_byte_ptr = (unsigned short *) malloc(sizeof(unsigned short));
						*short_byte_ptr = 0;
						memset(buffer, (int) NULL, 256);
						fread(short_byte_ptr, sizeof(unsigned short), 1, rfd);
						sprintf(buffer, "%-02.2x", Get16u(short_byte_ptr));

						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "get16u_short_byte_ptr: %x\n", Get16u(short_byte_ptr));
						trace(trace_buffer);
	
						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "buffer: %s\n", buffer);
						trace(trace_buffer);

						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "short_byte_ptr: %x\n", *short_byte_ptr);
						trace(trace_buffer);

						print_16bit_bytes(buffer, 1, 1, local_ptr);
						free(short_byte_ptr);
					}
				}
				else
				{
					extract_and_format_data(ifde_ptr, local_ptr, 0);
				}
				break;
			case 4:
				ByteCount = components * 4;

				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "ByteCount: %d\n", ByteCount);
				trace(trace_buffer);

				if (ByteCount > 4)
				{
					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "Value Offset: %x\n", Get32u(&ifde_ptr->value_offset));
					trace(trace_buffer);

					my_fseek(rfd, Get32u(&ifde_ptr->value_offset), 0);
					temp_position = ftell(rfd);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "temp_position: %x\n", temp_position);
					trace(trace_buffer);

					for(ctr3 = 0; ctr3 < components; ctr3++)
					{
						long_byte_ptr = (unsigned long *) malloc(sizeof(unsigned long));
						*long_byte_ptr = 0;
						memset(buffer, (int) NULL, 256);
						fread(long_byte_ptr, sizeof(unsigned long), 1, rfd);
						sprintf(buffer, "%-04.4x", Get32u(long_byte_ptr));

						if(Get16u(&ifde_ptr->tag) == TAG_SUBIFD_S)
						{
							trace("------Start SubIFD------\n");

							//save file ptr
							temp_position = ftell(rfd);
		
							memset(trace_buffer, (int) NULL, 256);
							sprintf(trace_buffer, "temp_position: %x\n", temp_position);
							trace(trace_buffer);

							memset(trace_buffer, (int) NULL, 256);
							sprintf(trace_buffer, "offset to count: %x\n", (Get32u(long_byte_ptr)));
							trace(trace_buffer);

							memset(type_buffer, (int) NULL, 256);
							sprintf(type_buffer, "SUB_IFD%d", ctr3);

							dump_image_file_directory(rfd, (Get32u(long_byte_ptr)), 0, get_new_data_header_ptr(), type_buffer);
		
							//restore file ptr
							fseek(rfd, temp_position, 0);

							trace("------End SubIFD------\n");
						}

						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "get33u_long_byte_ptr: %x\n", Get32u(long_byte_ptr));
						trace(trace_buffer);

						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "buffer: %s\n", buffer);
						trace(trace_buffer);
	
						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "long_byte_ptr: %x\n", *long_byte_ptr);
						trace(trace_buffer);

						print_16bit_bytes(buffer, 1, 1, local_ptr);
						free(long_byte_ptr);
					}
				}
				else
				{
					extract_and_format_data(ifde_ptr, local_ptr, 0);

					if(Get16u(&ifde_ptr->tag) == TAG_THUMBNAIL_OFFSET)
					{
						lThumbnailOffset = Get32u(&ifde_ptr->value_offset);

						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "lThumbnailOffset: %ld\n", lThumbnailOffset);
						trace(trace_buffer);
					}

					if(Get16u(&ifde_ptr->tag) == TAG_THUMBNAIL_LENGTH)
					{
						lThumbnailLength = Get32u(&ifde_ptr->value_offset);

						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "lThumbnailLength: %ld\n", lThumbnailLength);
						trace(trace_buffer);
					}

					if(Get16u(&ifde_ptr->tag) == TAG_EXIF_OFFSET)
					{
						trace("------Start EXIF------\n");
						//save file ptr
						temp_position = ftell(rfd);

						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "temp_position: %x\n", temp_position);
						trace(trace_buffer);

						memset(type_buffer, (int) NULL, 256);
						sprintf(type_buffer, "EXIF");

						//call dump_.... with offset
						dump_image_file_directory(rfd, Get32u(&ifde_ptr->value_offset) + jpg_type_offset(), jpg_type_offset(), get_new_data_header_ptr(), type_buffer);

						//restore file ptr
						fseek(rfd, temp_position, 0);
						trace("------End EXIF------\n");
					}
				}
				break;
			case 5:
				ByteCount = components * 8;

				memset(buffer, (int) NULL, 256);

				fseek(rfd, Get32u(&ifde_ptr->value_offset) + offset_base, 0);

				for(ctr2 = 0; ctr2 < components; ctr2++)
				{
					fread(&numirator, sizeof(unsigned long), 1, rfd);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "numirator: %x\n", numirator);
					trace(trace_buffer);

					fread(&denominator, sizeof(unsigned long), 1, rfd);
	
					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "denominator: %x\n", denominator);
					trace(trace_buffer);
				
					numirator_cnvtd = Get32s(&numirator);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "%ld,0", numirator_cnvtd);
					num = atof(trace_buffer);
				
					denominator_cnvtd = Get32s(&denominator);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "%ld.0", denominator_cnvtd);
					den = atof(trace_buffer);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "%f ", num/den); 
					trace(trace_buffer);
					strcat(buffer, trace_buffer);
				}

				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "%s", buffer); 

				local_ptr->Value = (char *) malloc(strlen(trace_buffer) + 1);
				strcpy(local_ptr->Value, trace_buffer);

				break;
			case 10:
				ByteCount = components * 8;

				memset(buffer, (int) NULL, 256);

				fseek(rfd, Get32u(&ifde_ptr->value_offset) + offset_base, 0);

				for(ctr2 = 0; ctr2 < components; ctr2++)
				{
					fread(&snumirator, sizeof(long), 1, rfd);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "snumirator: %x\n", snumirator);
					trace(trace_buffer);

					fread(&sdenominator, sizeof(long), 1, rfd);
	
					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "sdenominator: %x\n", sdenominator);
					trace(trace_buffer);
				
					snumirator_cnvtd = Get32s(&snumirator);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "%ld,0", snumirator_cnvtd);
					num = atof(trace_buffer);
				
					sdenominator_cnvtd = Get32s(&sdenominator);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "%ld.0", sdenominator_cnvtd);
					den = atof(trace_buffer);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "%f ", num/den); 
					trace(trace_buffer);
					strcat(buffer, trace_buffer);
				}

				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "%s", buffer); 

				local_ptr->Value = (char *) malloc(strlen(trace_buffer) + 1);
				strcpy(local_ptr->Value, trace_buffer);

				break;
			case 7:
				if(Get16u(&ifde_ptr->tag) == 0xA300 || 
                                   Get16u(&ifde_ptr->tag) == 0xA301)
				{
					trace("------Start FileSource/SceneType------\n");

					memset(buffer, (int) NULL, 256);
					sprintf(buffer, "%x", Get32u(&ifde_ptr->value_offset)); 

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "\nvalue_offset: %x", Get32u(&ifde_ptr->value_offset)); 
					trace(trace_buffer);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "\ncount: %d\n", Get32u(&ifde_ptr->count)); 
					trace(trace_buffer);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "%x", Get32u(&ifde_ptr->value_offset)); 
					trace(trace_buffer);

					byte_ptr = &buffer[0];

					print_8bit_bytes(byte_ptr, Get32u(&ifde_ptr->count), local_ptr);
					trace("\n------End FileSource/SceneType------\n");

					break;
				}

				if(Get16u(&ifde_ptr->tag) == 0x000D ||
                                   Get16u(&ifde_ptr->tag) == 0x000E ||
                                   Get16u(&ifde_ptr->tag) == 0x0012 ||
                                   Get16u(&ifde_ptr->tag) == 0x0017 ||
                                   Get16u(&ifde_ptr->tag) == 0x0018 ||
                                   Get16u(&ifde_ptr->tag) == 0x0088 ||
                                   Get16u(&ifde_ptr->tag) == 0x008B ||
                                   Get16u(&ifde_ptr->tag) == 0x00A4 ||
                                   Get16u(&ifde_ptr->tag) == 0x9000 ||
                                   Get16u(&ifde_ptr->tag) == 0x9101 ||
                                   Get16u(&ifde_ptr->tag) == 0xA000 ||
                                   Get16u(&ifde_ptr->tag) == 0x0001)
				{
					trace("------Start FileSource/SceneType------\n");

					memset(buffer, (int) NULL, 256);
					sprintf(buffer, "%x", Get32u(&ifde_ptr->value_offset)); 

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "\nvalue_offset: %x", Get32u(&ifde_ptr->value_offset)); 
					trace(trace_buffer);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "\ncount: %d\n", Get32u(&ifde_ptr->count)); 
					trace(trace_buffer);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "%x", Get32u(&ifde_ptr->value_offset)); 
					trace(trace_buffer);

					byte_ptr = &buffer[0];

					print_16bit_hex(pad_field(byte_ptr, 2 * Get32u(&ifde_ptr->count), '0', 1),Get32u(&ifde_ptr->count), 2, local_ptr);
					trace("\n------End FileSource/SceneType------\n");

					break;
				}

				if(Get16u(&ifde_ptr->tag) == 0xA302 ||
                                   Get16u(&ifde_ptr->tag) == 0x008C ||
                                   Get16u(&ifde_ptr->tag) == 0x0091 ||
                                   Get16u(&ifde_ptr->tag) == 0x0096 ||
                                   Get16u(&ifde_ptr->tag) == 0x0097 ||
                                   Get16u(&ifde_ptr->tag) == 0x00A8 ||
                                   Get16u(&ifde_ptr->tag) == 0x0098)
				{
					trace("------Start CFA Pattern------\n");

					fseek(rfd, Get32u(&ifde_ptr->value_offset) + offset_base, 0);
					
					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "\nvalue_offset: %x", Get32u(&ifde_ptr->value_offset)); 
					trace(trace_buffer);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "\noffset_base: %x\n", offset_base); 
					trace(trace_buffer);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "\ncount: %d\n", Get32u(&ifde_ptr->count)); 
					trace(trace_buffer);

					byte_ptr = (char *) malloc(Get32u(&ifde_ptr->count) + 1);

					fread(byte_ptr, Get32u(&ifde_ptr->count), 1, rfd);

					if(Get32u(&ifde_ptr->count) > 10)
						print_8bit_hex(byte_ptr, 10, local_ptr);
					else
						print_8bit_hex(byte_ptr, Get32u(&ifde_ptr->count), local_ptr);

					free(byte_ptr);

					trace("\n------End CFA Pattern------\n");

					break;
				}

				if(Get16u(&ifde_ptr->tag) == 0x9286)
				{
					trace("------Start UserComment------\n");

					fseek(rfd, Get32u(&ifde_ptr->value_offset) + offset_base + ASCII_LABEL_SKIP_LENGTH, 0);
					
					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "\nvalue_offset: %x", Get32u(&ifde_ptr->value_offset)); 
					trace(trace_buffer);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "\noffset_base: %x\n", offset_base); 
					trace(trace_buffer);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "\ncount: %d\n", Get32u(&ifde_ptr->count)); 
					trace(trace_buffer);

					fread(buffer, Get32u(&ifde_ptr->count), 1, rfd);
					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "%s", buffer); 
					trace(trace_buffer);

					local_ptr->Value = (char *) malloc(strlen(trace_buffer) + 1);
					strcpy(local_ptr->Value, trace_buffer);

					trace("\n------End UserComment------\n");

					break;
				}

				if(Get16u(&ifde_ptr->tag) == TAG_MAKER_NOTE)
				{
					trace("------Start Maker Notes------\n");

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "%x", Get32u(&ifde_ptr->value_offset));
					local_ptr->Value = (char *) malloc(strlen(trace_buffer) + 1);
					strcpy(local_ptr->Value, trace_buffer);

					//save file ptr
					temp_position = ftell(rfd);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "old_file_position: %x\n", temp_position);
					trace(trace_buffer);

					old_byte_order = MotorolaOrder;

					maker_note_header_offset = Get32u(&ifde_ptr->value_offset) + MAKER_NOTE_PRE_HEADER_LENGTH + jpg_type_offset();

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "maker_note_header_offset: %x\n", maker_note_header_offset);
					trace(trace_buffer);

					fseek(rfd, maker_note_header_offset, 0);

					memset(type_buffer, (int) NULL, 256);
					sprintf(type_buffer, "MAKER_NOTES");

					//call dump_.... with offset
					dump_image_file_directory(rfd, (maker_note_header_offset + inspect_image_file_header(rfd, 1)), maker_note_header_offset, get_new_data_header_ptr(), type_buffer);

					MotorolaOrder = old_byte_order;

					//restore file ptr
					fseek(rfd, temp_position, 0);
					trace("------End Maker Notes------\n");
				}

				break;
			default:
				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "Unknown Format: %x\n", Get16u(&ifde_ptr->field_type));
				trace(trace_buffer);
				break;
		}

		local_ptr->next = (struct data_header *) malloc(sizeof(struct data_header));
		local_ptr = local_ptr->next;
		memset(local_ptr, (int) NULL, sizeof(struct data_header));

		fseek(rfd, old_position, 0);
	}

	trace("-dump_image_file_directory\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
struct data_header_ptr * get_new_main_header_ptr()
{
	struct data_header_ptr *local_main_header_ptr;
	local_main_header_ptr = (struct data_header_ptr *) malloc(sizeof(struct data_header_ptr));
	memset(local_main_header_ptr, (int) NULL, sizeof(struct data_header_ptr));
	return(local_main_header_ptr);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
struct data_header * get_new_data_header_ptr()
{
	struct data_header *local_header_ptr;
	local_header_ptr = (struct data_header *) malloc(sizeof(struct data_header));
	memset(local_header_ptr, (int) NULL, sizeof(struct data_header));
	return(local_header_ptr);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
struct html_header * get_new_html_header_ptr()
{
	struct html_header *local_header_ptr;
	local_header_ptr = (struct html_header *) malloc(sizeof(struct html_header));
	memset(local_header_ptr, (int) NULL, sizeof(struct html_header));
	return(local_header_ptr);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void long_to_asc( unsigned long Lf15a_long_value, char *Lf15b_str_ptr, int Lf15c_length, char Lf15d_blank)
{
	int Lf15e_temp;

	// Pre-fill the string to all blanks or zeros depending on the blank
	// fill flag and check for the special case of a zero value.

	for (Lf15e_temp = 0; Lf15e_temp < Lf15c_length; Lf15e_temp++)
		Lf15b_str_ptr[Lf15e_temp] = (Lf15d_blank) ? ' ' : '0';

	if (Lf15a_long_value == 0)
		Lf15b_str_ptr[Lf15c_length - 1] = '0';

	// Loop through for the entire length or until zero value reached.

	while (Lf15a_long_value > 0 && Lf15c_length > 0)
	{
		Lf15b_str_ptr[--Lf15c_length] = (char) Lf15a_long_value % 10 + '0';
		Lf15a_long_value /= 10;
	}

	return;
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
char * get_data_from_long(unsigned long Long)
{
	int ctr1;
	char *ptr;
	char *ptr2;
	static char lbuffer[5];

	trace("\n+get_data_from_long\n");

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "Long: %x\n", Long);
	trace(trace_buffer);

	ptr = (char *) &Long;

	memset(lbuffer, (int) NULL, 5);

	for(ctr1 = 3; ctr1 >= 0; ctr1--)
	{
		lbuffer[ctr1] = ptr[ctr1];

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "lbuffer[%d]: %x\n", ctr1, lbuffer[ctr1]);
		trace(trace_buffer);
	}

	ptr2 = &lbuffer[0];

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "returned data: [%s], length: %d\n", ptr2, strlen(ptr2));
	trace(trace_buffer);

	trace("\n-get_data_from_long\n");

	return(ptr2);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void trace(char *str)
{
	if(iTrace)
		printf("%s", str);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
unsigned long inspect_image_file_header(FILE *rfd, int iType)
{
        char buffer[256];
        static unsigned char ExifHeader[] = "Exif\0\0";
	struct image_file_header *ifh_ptr;
	unsigned long offset_ifd = 0;

	struct jpg_indicator_header
	{
		unsigned char start;
		unsigned char soi;
		unsigned char pad;
		unsigned char exif_ind;
	};

	struct jpg_indicator_header *jpg_ind_hdr_ptr;

	trace("\n+inspect_image_file_header\n");

	if(iType)
	{
		ifh_ptr = (struct image_file_header *) malloc(sizeof(struct image_file_header));
		memset(ifh_ptr, (int) NULL, sizeof(struct image_file_header));

		if((fread(ifh_ptr, sizeof(struct image_file_header), 1, rfd)) != 0)
		{
			memset(buffer, (int) NULL, 256);
			memcpy(buffer, ifh_ptr->byte_order, 2);
	
			if(!strncmp(buffer, "MM", 2))
				MotorolaOrder = 1;
			else
				MotorolaOrder = 0;
	
			offset_ifd = Get32u(&ifh_ptr->offset_to_first_ifd);
	
			memset(trace_buffer, (int) NULL, 256);
			sprintf(trace_buffer, "Byte Order: %s\n", buffer);
			trace(trace_buffer);
			memset(trace_buffer, (int) NULL, 256);
			sprintf(trace_buffer, "Image File Type: %x\n", Get16u(&ifh_ptr->image_file_type));
			trace(trace_buffer);
			memset(trace_buffer, (int) NULL, 256);
			sprintf(trace_buffer, "Offset To First IFD: %x\n", offset_ifd);
			trace(trace_buffer);
	
			if((!strncmp(buffer, "MM", 2)) && (Get16u(&ifh_ptr->image_file_type) == 42))
			{
			}
			else if((!strncmp(buffer, "II", 2)) && (Get16u(&ifh_ptr->image_file_type) == 42))
			{
			}
			else
			{
				printf("\nFile type is not NEF/Nikon RAW\n\n");
				exit(1);
			}
	
		}
		else
		{
			my_error(rfd);
		}
	}
	else
	{
		jpg_ind_hdr_ptr = (struct jpg_indicator_header *) malloc(sizeof(struct jpg_indicator_header));
		memset(jpg_ind_hdr_ptr, (int) NULL, sizeof(struct jpg_indicator_header));

		if((fread(jpg_ind_hdr_ptr, sizeof(struct jpg_indicator_header), 1, rfd)) != 0)
		{
			if(jpg_ind_hdr_ptr->start != 0xff)
			{
				my_exit("First byte must be 0xFF");
			}

			if(jpg_ind_hdr_ptr->soi != 0xd8)
			{
				my_exit("Second byte must be 0xD8");
			}

			if(jpg_ind_hdr_ptr->pad != 0xff)
			{
				my_exit("Third byte must be 0xFF");
			}

			fseek(rfd, 0, 0);

			switch(jpg_ind_hdr_ptr->exif_ind)
			{
				case 0xe0:
					iJPG_Type = 0;
					fseek(rfd, 18, 0);
					offset_ifd = get_jpg_type_and_offset(rfd, jpg_type_offset());
					break;
				case 0xe1:
					iJPG_Type = 1;
					offset_ifd = get_jpg_type_and_offset(rfd, jpg_type_offset());
					break;
				default:
					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "Fourth byte is unknown: %x", jpg_ind_hdr_ptr->exif_ind);
					my_exit(trace_buffer);
					break;
			}
		}
	}

	trace("\n-inspect_image_file_header\n");
	return(offset_ifd);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
unsigned long get_jpg_type_and_offset(FILE *rfd, unsigned long offset)
{
        char buffer[256];
        static unsigned char ExifHeader[] = "Exif\0\0";
	unsigned long offset_ifd;
	struct jpg_image_file_header *jpg_ifh_ptr;

	trace("\n+get_jpg_type_and_offset\n");

	jpg_ifh_ptr = (struct jpg_image_file_header *) malloc(sizeof(struct jpg_image_file_header));
	memset(jpg_ifh_ptr, (int) NULL, sizeof(struct jpg_image_file_header));

	if((fread(jpg_ifh_ptr, sizeof(struct jpg_image_file_header), 1, rfd)) != 0)
	{
	        if (strncmp(jpg_ifh_ptr->exif_header_text, ExifHeader, 6))
		{
			my_exit("EXIF header text incorrect");
		}
			
		memset(buffer, (int) NULL, 256);
		memcpy(buffer, jpg_ifh_ptr->byte_order, 2);
				
		if(!strncmp(buffer, "MM", 2))
			MotorolaOrder = 1;
		else
			MotorolaOrder = 0;
				
		offset_ifd = Get32u(&jpg_ifh_ptr->offset_to_first_ifd) + offset;
				
		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "Byte Order: %s\n", buffer);
		trace(trace_buffer);
		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "Image File Type: %x\n", Get16u(&jpg_ifh_ptr->image_file_type));
		trace(trace_buffer);
		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "Offset To First IFD: %x\n", offset_ifd);
		trace(trace_buffer);

		if(iTrace)
		{
			printf("\nstart: %x", jpg_ifh_ptr->start);
			printf("\nsoi: %x", jpg_ifh_ptr->soi);
			printf("\npad: %x", jpg_ifh_ptr->pad);
			printf("\nexif_ind: %x", jpg_ifh_ptr->exif_ind);
			printf("\nlength: %x", jpg_ifh_ptr->length);
			printf("\nexif_header_text: %s", jpg_ifh_ptr->exif_header_text);
			printf("\nbyte_order: %s", jpg_ifh_ptr->byte_order);
			printf("\nimage_file_type: %x", jpg_ifh_ptr->image_file_type);
			printf("\noffset: %x\n", jpg_ifh_ptr->offset_to_first_ifd);
		}

		if((!strncmp(buffer, "MM", 2)) && (Get16u(&jpg_ifh_ptr->image_file_type) == 42))
		{
		}
		else if((!strncmp(buffer, "II", 2)) && (Get16u(&jpg_ifh_ptr->image_file_type) == 42))
		{
		}
		else
		{
			printf("\nFile type is not Nikon JPG\n\n");
			exit(1);
		}
				
	}
	else
	{
		my_error(rfd);
	}

	trace("\n-get_jpg_type_and_offset\n");
	return(offset_ifd);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
int jpg_type()
{
	return(iJPG_Type);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
int jpg_type_offset()
{
	int iType;

	switch(iJPG_Type)
	{
		case 0:
			iType = 30;
			break;
		case 1:
			iType = 12;
			break;
		case 99:
			iType = 0;
			break;
		default:
			iType = -1;
			break;
	}

	return(iType);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void my_exit(char *text_ptr)
{
	printf("\n\n%s\n", text_ptr);
	printf("\n%s\n\n", "File is not a JPG/JPEG file");
	exit(1);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void my_jpg_exit(char *text_ptr)
{
	printf("\n\n%s\n", text_ptr);
	printf("\n%s\n\n", "File is not a NEF/RAW file");
	exit(1);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void display_data(struct data_header *local_ptr, char *data_type)
{
	while(local_ptr->next != NULL)
	{
		if(iTrace)
		{
			if(is_tag_printed((unsigned short) local_ptr->Tag))
			{
				switch(local_ptr->Tag)
				{
					case 0x829a:		// shutter speed
						if(!strncmp(local_ptr->Value, "0.000125", strlen("0.000125")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/8000");
						}
						else if(!strncmp(local_ptr->Value, "0.000156", strlen("0.000156")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/6400");
						}
						else if(!strncmp(local_ptr->Value, "0.000200", strlen("0.000200")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/5000");
						}
						else if(!strncmp(local_ptr->Value, "0.000250", strlen("0.000250")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/4000");
						}
						else if(!strncmp(local_ptr->Value, "0.000313", strlen("0.000313")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/3200");
						}
						else if(!strncmp(local_ptr->Value, "0.000400", strlen("0.000400")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/2500");
						}
						else if(!strncmp(local_ptr->Value, "0.000500", strlen("0.000500")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/2000");
						}
						else if(!strncmp(local_ptr->Value, "0.000625", strlen("0.000625")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/1600");
						}
						else if(!strncmp(local_ptr->Value, "0.000800", strlen("0.000800")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/1250");
						}
						else if(!strncmp(local_ptr->Value, "0.001000", strlen("0.001000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/1000");
						}
						else if(!strncmp(local_ptr->Value, "0.001250", strlen("0.001250")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/800");
						}
						else if(!strncmp(local_ptr->Value, "0.001563", strlen("0.001563")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/640");
						}
						else if(!strncmp(local_ptr->Value, "0.002000", strlen("0.002000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/500");
						}
						else if(!strncmp(local_ptr->Value, "0.002500", strlen("0.002500")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/400");
						}
						else if(!strncmp(local_ptr->Value, "0.003125", strlen("0.003125")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/320");
						}
						else if(!strncmp(local_ptr->Value, "0.004000", strlen("0.004000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/250");
						}
						else if(!strncmp(local_ptr->Value, "0.005000", strlen("0.005000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/200");
						}
						else if(!strncmp(local_ptr->Value, "0.006250", strlen("0.006250")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/160");
						}
						else if(!strncmp(local_ptr->Value, "0.008000", strlen("0.008000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/125");
						}
						else if(!strncmp(local_ptr->Value, "0.010000", strlen("0.010000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/100");
						}
						else if(!strncmp(local_ptr->Value, "0.012500", strlen("0.012500")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/80");
						}
						else if(!strncmp(local_ptr->Value, "0.016667", strlen("0.016667")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/60");
						}
						else if(!strncmp(local_ptr->Value, "0.020000", strlen("0.020000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/50");
						}
						else if(!strncmp(local_ptr->Value, "0.025000", strlen("0.025000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/40");
						}
						else if(!strncmp(local_ptr->Value, "0.033333", strlen("0.033333")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/30");
						}
						else if(!strncmp(local_ptr->Value, "0.040000", strlen("0.040000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/25");
						}
						else if(!strncmp(local_ptr->Value, "0.050000", strlen("0.050000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/20");
						}
						else if(!strncmp(local_ptr->Value, "0.066667", strlen("0.066667")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/15");
						}
						else if(!strncmp(local_ptr->Value, "0.076923", strlen("0.076923")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/13");
						}
						else if(!strncmp(local_ptr->Value, "0.100000", strlen("0.100000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/10");
						}
						else if(!strncmp(local_ptr->Value, "0.125000", strlen("0.125000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/8");
						}
						else if(!strncmp(local_ptr->Value, "0.166667", strlen("0.166667")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/6");
						}
						else if(!strncmp(local_ptr->Value, "0.200000", strlen("0.200000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/5");
						}
						else if(!strncmp(local_ptr->Value, "0.250000", strlen("0.250000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/4");
						}
						else if(!strncmp(local_ptr->Value, "0.333333", strlen("0.333333")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/3");
						}
						else if(!strncmp(local_ptr->Value, "0.400000", strlen("0.400000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/2.5");
						}
						else if(!strncmp(local_ptr->Value, "0.500000", strlen("0.500000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/2");
						}
						else if(!strncmp(local_ptr->Value, "0.625000", strlen("0.625000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/1.6");
						}
						else if(!strncmp(local_ptr->Value, "0.769231", strlen("0.769231")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1/1.3");
						}
						else if(!strncmp(local_ptr->Value, "1.000000", strlen("1.000000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1");
						}
						else if(!strncmp(local_ptr->Value, "1.300000", strlen("1.300000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1.3");
						}
						else if(!strncmp(local_ptr->Value, "1.600000", strlen("1.600000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "1.6");
						}
						else if(!strncmp(local_ptr->Value, "2.000000", strlen("2.000000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "2");
						}
						else if(!strncmp(local_ptr->Value, "2.500000", strlen("2.500000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "2.5");
						}
						else if(!strncmp(local_ptr->Value, "3.000000", strlen("3.000000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "3");
						}
						else if(!strncmp(local_ptr->Value, "4.000000", strlen("4.000000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "4");
						}
						else if(!strncmp(local_ptr->Value, "5.000000", strlen("5.000000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "5");
						}
						else if(!strncmp(local_ptr->Value, "6.000000", strlen("6.000000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "6");
						}
						else if(!strncmp(local_ptr->Value, "8.000000", strlen("8.000000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "8");
						}
						else if(!strncmp(local_ptr->Value, "10.000000", strlen("10.000000")))
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, "10");
						}
						else
						{
							debug_printf("\n%#x: %s: %s seconds", local_ptr->Tag, local_ptr->Desc, local_ptr->Value);
						}
						break;
					case 0x9209:

						if(!strncmp(local_ptr->Value, "0", strlen("0")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "No Flash");
						}
						else if((strlen(local_ptr->Value) == 1) && !strncmp(local_ptr->Value, "1", strlen("1")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Fired");
						}
						else if((strlen(local_ptr->Value) == 1) && !strncmp(local_ptr->Value, "5", strlen("5")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Fired, Return not detected");
						}
						else if((strlen(local_ptr->Value) == 1) && !strncmp(local_ptr->Value, "7", strlen("7")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Fired, Return detected");
						}
						else if((strlen(local_ptr->Value) == 1) && !strncmp(local_ptr->Value, "9", strlen("9")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "On");
						}
						else if(!strncmp(local_ptr->Value, "13", strlen("13")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "On, Return not detected");
						}
						else if(!strncmp(local_ptr->Value, "15", strlen("15")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "On, Return detected");
						}
						else if(!strncmp(local_ptr->Value, "16", strlen("16")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Off");
						}
						else if(!strncmp(local_ptr->Value, "24", strlen("24")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Auto, Did not fire");
						}
						else if(!strncmp(local_ptr->Value, "25", strlen("25")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Auto, Fired");
						}
						else if(!strncmp(local_ptr->Value, "29", strlen("29")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Auto, Fired, Return not detected");
						}
						else if(!strncmp(local_ptr->Value, "31", strlen("31")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Auto, Fired, Return detected");
						}
						else if(!strncmp(local_ptr->Value, "32", strlen("32")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "No flash function");
						}
						else if(!strncmp(local_ptr->Value, "65", strlen("65")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Fired, Red-eye reduction");
						}
						else if(!strncmp(local_ptr->Value, "69", strlen("69")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Fired, Red-eye reduction, Return not detected");
						}
						else if(!strncmp(local_ptr->Value, "71", strlen("71")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Fired, Red-eye reduction, Return detected");
						}
						else if(!strncmp(local_ptr->Value, "73", strlen("73")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "On, Red-eye reduction");
						}
						else if(!strncmp(local_ptr->Value, "77", strlen("77")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "On, Red-eye reduction, Return not detected");
						}
						else if(!strncmp(local_ptr->Value, "79", strlen("79")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "On, Red-eye reduction, Return detected");
						}
						else if(!strncmp(local_ptr->Value, "89", strlen("89")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Auto, Fired, Red-eye reduction");
						}
						else if(!strncmp(local_ptr->Value, "93", strlen("93")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Auto, Fired, Red-eye reduction, Return not detected");
						}
						else if(!strncmp(local_ptr->Value, "95", strlen("95")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Auto, Fired, Red-eye reduction, Return detected");
						}
						else
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, local_ptr->Value);
						}
						break;
					case 0x8822:
						if(!strncmp(local_ptr->Value, "2", strlen("2")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Program AE");
						}
						else if(!strncmp(local_ptr->Value, "0", strlen("0")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Auto");
						}
						else if(!strncmp(local_ptr->Value, "4", strlen("4")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Shutter speed priority AE");
						}
						else if(!strncmp(local_ptr->Value, "3", strlen("3")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Aperture-priority AE");
						}
						else if(!strncmp(local_ptr->Value, "1", strlen("1")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Manual");
						}
						else
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, local_ptr->Value);
						}
						break;
					case 0x9207:
						if(!strncmp(local_ptr->Value, "5", strlen("5")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Multi-segment");
						}
						else if(!strncmp(local_ptr->Value, "3", strlen("3")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Spot");
						}
						else if(!strncmp(local_ptr->Value, "2", strlen("2")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Center-weighted average");
						}
						else
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, local_ptr->Value);
						}
						break;
					case 0x0112:
						if(!strncmp(data_type, "SUB_IFD1", strlen("SUB_IFD1")))
							break;

						if(!strncmp(local_ptr->Value, "1", strlen("1")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Horizontal (normal)");
						}
						else if(!strncmp(local_ptr->Value, "2", strlen("2")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Mirrored horizontal");
						}
						else if(!strncmp(local_ptr->Value, "3", strlen("3")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Rotated 180");
						}
						else if(!strncmp(local_ptr->Value, "4", strlen("4")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Mirrored vertical");
						}
						else if(!strncmp(local_ptr->Value, "5", strlen("5")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Mirrored horizontal then rotated 90 CCW");
						}
						else if(!strncmp(local_ptr->Value, "6", strlen("6")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Rotated 90 CW");
						}
						else if(!strncmp(local_ptr->Value, "7", strlen("7")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Mirrored horizontal then rotated 90 CW");
						}
						else if(!strncmp(local_ptr->Value, "8", strlen("8")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "Rotated 90 CCW");
						}
						else
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, local_ptr->Value);
						}
						break;
					case 0x0084:		/* lens	*/
						debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, convert_lens(local_ptr->Value));
						break;
					case 0x920a:
						debug_printf("\n%#x: %s: %smm", local_ptr->Tag, local_ptr->Desc, truncate(local_ptr->Value, 0));
						break;
					case 0xa405:
						debug_printf("\n%#x: %s: %smm", local_ptr->Tag, local_ptr->Desc, local_ptr->Value);
						break;
					case 0x0083:
						if(!strncmp(local_ptr->Value, "2", strlen("2")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "D");
						}
						else if(!strncmp(local_ptr->Value, "6", strlen("6")))
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, "G");
						}
						else
						{
							debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, local_ptr->Value);
						}
						break;
					case 0x8827:
					case 0x010f:
					case 0x0110:
					case 0x0131:
					case 0x9004:
					case 0x829d:
					case 0x0002:
					case 0x0013:
					case 0x0004:
					case 0x00a7:
					case 0x0007:
					case 0x0008:
					case 0x0009:
					case 0x0081:
					case 0x008b:
					case 0x008d:
					case 0x0090:
					case 0x0095:
		//			case 0x00a0:
					case 0x00a9:
					case 0x00aa:
					case 0x00ab:
					case 0xa002:
					case 0xa003:
					case 0x9204:
					case 0x9286:
		//			case 0x010E:
					case 0xffff:
						debug_printf("\n%#x: %s: %s", local_ptr->Tag, local_ptr->Desc, local_ptr->Value);
						break;
					default:
						break;
				}	// end switch
			}		// end is_tag_printed
		}	// end if(iTrace)
		else
		{
			if(is_tag_printed((unsigned short) local_ptr->Tag))
			{
				switch(local_ptr->Tag)
				{
					case 0x829a:		// shutter speed
						if(!strncmp(local_ptr->Value, "0.000125", strlen("0.000125")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/8000");
						}
						else if(!strncmp(local_ptr->Value, "0.000156", strlen("0.000156")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/6400");
						}
						else if(!strncmp(local_ptr->Value, "0.000200", strlen("0.000200")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/5000");
						}
						else if(!strncmp(local_ptr->Value, "0.000250", strlen("0.000250")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/4000");
						}
						else if(!strncmp(local_ptr->Value, "0.000313", strlen("0.000313")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/3200");
						}
						else if(!strncmp(local_ptr->Value, "0.000400", strlen("0.000400")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/2500");
						}
						else if(!strncmp(local_ptr->Value, "0.000500", strlen("0.000500")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/2000");
						}
						else if(!strncmp(local_ptr->Value, "0.000625", strlen("0.000625")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/1600");
						}
						else if(!strncmp(local_ptr->Value, "0.000800", strlen("0.000800")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/1250");
						}
						else if(!strncmp(local_ptr->Value, "0.001000", strlen("0.001000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/1000");
						}
						else if(!strncmp(local_ptr->Value, "0.001250", strlen("0.001250")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/800");
						}
						else if(!strncmp(local_ptr->Value, "0.001563", strlen("0.001563")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/640");
						}
						else if(!strncmp(local_ptr->Value, "0.002000", strlen("0.002000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/500");
						}
						else if(!strncmp(local_ptr->Value, "0.002500", strlen("0.002500")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/400");
						}
						else if(!strncmp(local_ptr->Value, "0.003125", strlen("0.003125")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/320");
						}
						else if(!strncmp(local_ptr->Value, "0.004000", strlen("0.004000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/250");
						}
						else if(!strncmp(local_ptr->Value, "0.005000", strlen("0.005000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/200");
						}
						else if(!strncmp(local_ptr->Value, "0.006250", strlen("0.006250")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/160");
						}
						else if(!strncmp(local_ptr->Value, "0.008000", strlen("0.008000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/125");
						}
						else if(!strncmp(local_ptr->Value, "0.010000", strlen("0.010000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/100");
						}
						else if(!strncmp(local_ptr->Value, "0.012500", strlen("0.012500")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/80");
						}
						else if(!strncmp(local_ptr->Value, "0.016667", strlen("0.016667")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/60");
						}
						else if(!strncmp(local_ptr->Value, "0.020000", strlen("0.020000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/50");
						}
						else if(!strncmp(local_ptr->Value, "0.025000", strlen("0.025000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/40");
						}
						else if(!strncmp(local_ptr->Value, "0.033333", strlen("0.033333")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/30");
						}
						else if(!strncmp(local_ptr->Value, "0.040000", strlen("0.040000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/25");
						}
						else if(!strncmp(local_ptr->Value, "0.050000", strlen("0.050000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/20");
						}
						else if(!strncmp(local_ptr->Value, "0.066667", strlen("0.066667")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/15");
						}
						else if(!strncmp(local_ptr->Value, "0.076923", strlen("0.076923")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/13");
						}
						else if(!strncmp(local_ptr->Value, "0.100000", strlen("0.100000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/10");
						}
						else if(!strncmp(local_ptr->Value, "0.125000", strlen("0.125000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/8");
						}
						else if(!strncmp(local_ptr->Value, "0.166667", strlen("0.166667")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/6");
						}
						else if(!strncmp(local_ptr->Value, "0.200000", strlen("0.200000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/5");
						}
						else if(!strncmp(local_ptr->Value, "0.250000", strlen("0.250000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/4");
						}
						else if(!strncmp(local_ptr->Value, "0.333333", strlen("0.333333")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/3");
						}
						else if(!strncmp(local_ptr->Value, "0.400000", strlen("0.400000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/2.5");
						}
						else if(!strncmp(local_ptr->Value, "0.500000", strlen("0.500000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/2");
						}
						else if(!strncmp(local_ptr->Value, "0.625000", strlen("0.625000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/1.6");
						}
						else if(!strncmp(local_ptr->Value, "0.769231", strlen("0.769231")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1/1.3");
						}
						else if(!strncmp(local_ptr->Value, "1.000000", strlen("1.000000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1");
						}
						else if(!strncmp(local_ptr->Value, "1.300000", strlen("1.300000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1.3");
						}
						else if(!strncmp(local_ptr->Value, "1.600000", strlen("1.600000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "1.6");
						}
						else if(!strncmp(local_ptr->Value, "2.000000", strlen("2.000000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "2");
						}
						else if(!strncmp(local_ptr->Value, "2.500000", strlen("2.500000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "2.5");
						}
						else if(!strncmp(local_ptr->Value, "3.000000", strlen("3.000000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "3");
						}
						else if(!strncmp(local_ptr->Value, "4.000000", strlen("4.000000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "4");
						}
						else if(!strncmp(local_ptr->Value, "5.000000", strlen("5.000000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "5");
						}
						else if(!strncmp(local_ptr->Value, "6.000000", strlen("6.000000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "6");
						}
						else if(!strncmp(local_ptr->Value, "8.000000", strlen("8.000000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "8");
						}
						else if(!strncmp(local_ptr->Value, "10.000000", strlen("10.000000")))
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, "10");
						}
						else
						{
							my_printf("\n%s: %s seconds", local_ptr->Desc, local_ptr->Value);
						}
						break;
					case 0x9209:
						if(!strncmp(local_ptr->Value, "0", strlen("0")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "No Flash");
						}
						else if((strlen(local_ptr->Value) == 1) && !strncmp(local_ptr->Value, "1", strlen("1")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Fired");
						}
						else if((strlen(local_ptr->Value) == 1) && !strncmp(local_ptr->Value, "5", strlen("5")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Fired, Return not detected");
						}
						else if((strlen(local_ptr->Value) == 1) && !strncmp(local_ptr->Value, "7", strlen("7")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Fired, Return detected");
						}
						else if((strlen(local_ptr->Value) == 1) && !strncmp(local_ptr->Value, "9", strlen("9")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "On");
						}
						else if(!strncmp(local_ptr->Value, "13", strlen("13")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "On, Return not detected");
						}
						else if(!strncmp(local_ptr->Value, "15", strlen("15")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "On, Return detected");
						}
						else if(!strncmp(local_ptr->Value, "16", strlen("16")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Off");
						}
						else if(!strncmp(local_ptr->Value, "24", strlen("24")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Auto, Did not fire");
						}
						else if(!strncmp(local_ptr->Value, "25", strlen("25")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Auto, Fired");
						}
						else if(!strncmp(local_ptr->Value, "29", strlen("29")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Auto, Fired, Return not detected");
						}
						else if(!strncmp(local_ptr->Value, "31", strlen("31")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Auto, Fired, Return detected");
						}
						else if(!strncmp(local_ptr->Value, "32", strlen("32")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "No flash function");
						}
						else if(!strncmp(local_ptr->Value, "65", strlen("65")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Fired, Red-eye reduction");
						}
						else if(!strncmp(local_ptr->Value, "69", strlen("69")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Fired, Red-eye reduction, Return not detected");
						}
						else if(!strncmp(local_ptr->Value, "71", strlen("71")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Fired, Red-eye reduction, Return detected");
						}
						else if(!strncmp(local_ptr->Value, "73", strlen("73")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "On, Red-eye reduction");
						}
						else if(!strncmp(local_ptr->Value, "77", strlen("77")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "On, Red-eye reduction, Return not detected");
						}
						else if(!strncmp(local_ptr->Value, "79", strlen("79")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "On, Red-eye reduction, Return detected");
						}
						else if(!strncmp(local_ptr->Value, "89", strlen("89")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Auto, Fired, Red-eye reduction");
						}
						else if(!strncmp(local_ptr->Value, "93", strlen("93")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Auto, Fired, Red-eye reduction, Return not detected");
						}
						else if(!strncmp(local_ptr->Value, "95", strlen("95")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Auto, Fired, Red-eye reduction, Return detected");
						}
						else
						{
							my_printf("\n%s: %s", local_ptr->Desc, local_ptr->Value);
						}
						break;
					case 0x8822:
						if(!strncmp(local_ptr->Value, "2", strlen("2")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Program AE");
						}
						else if(!strncmp(local_ptr->Value, "0", strlen("0")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Auto");
						}
						else if(!strncmp(local_ptr->Value, "4", strlen("4")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Shutter speed priority AE");
						}
						else if(!strncmp(local_ptr->Value, "3", strlen("3")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Aperture-priority AE");
						}
						else if(!strncmp(local_ptr->Value, "1", strlen("1")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Manual");
						}
						else
						{
							my_printf("\n%s: %s", local_ptr->Desc, local_ptr->Value);
						}
						break;
					case 0x9207:
						if(!strncmp(local_ptr->Value, "5", strlen("5")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Multi-segment");
						}
						else if(!strncmp(local_ptr->Value, "3", strlen("3")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Spot");
						}
						else if(!strncmp(local_ptr->Value, "2", strlen("2")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Center-weighted average");
						}
						else
						{
							my_printf("\n%s: %s", local_ptr->Desc, local_ptr->Value);
						}
						break;
					case 0x0112:
						if(!strncmp(data_type, "SUB_IFD1", strlen("SUB_IFD1")))
							break;

						if(!strncmp(local_ptr->Value, "1", strlen("1")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Horizontal (normal)");
						}
						else if(!strncmp(local_ptr->Value, "2", strlen("2")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Mirrored horizontal");
						}
						else if(!strncmp(local_ptr->Value, "3", strlen("3")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Rotated 180");
						}
						else if(!strncmp(local_ptr->Value, "4", strlen("4")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Mirrored vertical");
						}
						else if(!strncmp(local_ptr->Value, "5", strlen("5")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Mirrored horizontal then rotated 90 CCW");
						}
						else if(!strncmp(local_ptr->Value, "6", strlen("6")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Rotated 90 CW");
						}
						else if(!strncmp(local_ptr->Value, "7", strlen("7")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Mirrored horizontal then rotated 90 CW");
						}
						else if(!strncmp(local_ptr->Value, "8", strlen("8")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "Rotated 90 CCW");
						}
						else
						{
							my_printf("\n%s: %s", local_ptr->Desc, local_ptr->Value);
						}
						break;
					case 0x0084:		/* lens	*/
						my_printf("\n%s: %s", local_ptr->Desc, convert_lens(local_ptr->Value));
						break;
					case 0x920a:
						my_printf("\n%s: %smm", local_ptr->Desc, truncate(local_ptr->Value, 0));
						break;
					case 0xa405:
						my_printf("\n%s: %smm", local_ptr->Desc, local_ptr->Value);
						break;
					case 0x0083:
						if(!strncmp(local_ptr->Value, "2", strlen("2")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "D");
						}
						else if(!strncmp(local_ptr->Value, "6", strlen("6")))
						{
							my_printf("\n%s: %s", local_ptr->Desc, "G");
						}
						else
						{
							my_printf("\n%s: %s", local_ptr->Desc, local_ptr->Value);
						}
						break;
					case 0x8827:
					case 0x010f:
					case 0x0110:
					case 0x0131:
					case 0x9004:
					case 0x829d:
					case 0x0002:
					case 0x0013:
					case 0x0004:
					case 0x00a7:
					case 0x0007:
					case 0x0008:
					case 0x0009:
					case 0x0081:
					case 0x008b:
					case 0x008d:
					case 0x0090:
					case 0x0095:
		//			case 0x00a0:
					case 0x00a9:
					case 0x00aa:
					case 0x00ab:
					case 0xa002:
					case 0xa003:
					case 0x9204:
					case 0x9286:
		//			case 0x010E:
					case 0xffff:
						my_printf("\n%s: %s", local_ptr->Desc, local_ptr->Value);
						break;
					default:
						break;
				}	// end switch
			}	// end is_tag_printed
		}

		local_ptr = local_ptr->next;
	}

}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
char * convert_lens(char *str_lens)
{
	char *temp_ptr;
	char *final_ptr = "lens";
	char *token1;
	char *token2;
	char *token3;
	char *token4;
	char buffer[256];

	trace("+convert_lens\n");

	memset(buffer, (int) NULL, 256);

	temp_ptr = strdup(str_lens);

	token1 = strtok(temp_ptr, " ");
	token2 = strtok(NULL, " ");
	token3 = strtok(NULL, " ");
	token4 = strtok(NULL, " ");

	if((!strcmp(token1, token2)) && (!strcmp(token3, token4)))
	{
		sprintf(buffer, "%smm f/%s", truncate(token1, 0), truncate(token3, 2));
	}
	else
	{
		if(!strcmp(token3, token4))
			sprintf(buffer, "%s-%smm f/%s", truncate(token1, 0), truncate(token2, 0), truncate(token3, 2));
		else
			sprintf(buffer, "%s-%smm f/%s-%s", truncate(token1, 0), truncate(token2, 0), truncate(token3, 2), truncate(token4, 2));
	}

	final_ptr = (char *) malloc(strlen(buffer) + 1);
	memset(final_ptr, (int) NULL, strlen(buffer) + 1);
	strcpy(final_ptr, buffer);

	trace("-convert_lens\n");
	return(final_ptr);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
char *truncate(char *str_token, int dec_len)
{
	char *temp_ptr;
	char *char_ptr;

	temp_ptr = strdup(str_token);

	char_ptr = strchr(temp_ptr, '.');

	char_ptr += dec_len;

	*char_ptr = (char) NULL;
	
	return(temp_ptr);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void debug_printf(char *str_format, unsigned short us_tag, char *str_desc, char *str_value)
{
	if(html_header_ptr == NULL)
	{
		html_header_ptr = get_new_html_header_ptr();

		html_header_ptr->Desc = (char *) malloc(strlen(str_desc) + 1);
		memset(html_header_ptr->Desc, (int) NULL, strlen(str_desc) + 1);
		strncpy(html_header_ptr->Desc, str_desc, strlen(str_desc));

		html_header_ptr->Value = (char *) malloc(strlen(str_value) + 1);
		memset(html_header_ptr->Value, (int) NULL, strlen(str_value) + 1);
		strncpy(html_header_ptr->Value, str_value, strlen(str_value));

		html_header_start_ptr = html_header_ptr;
	}
	else
	{
		html_header_ptr->next = get_new_html_header_ptr();
		html_header_ptr =  html_header_ptr->next;

		html_header_ptr->Desc = (char *) malloc(strlen(str_desc) + 1);
		memset(html_header_ptr->Desc, (int) NULL, strlen(str_desc) + 1);
		strncpy(html_header_ptr->Desc, str_desc, strlen(str_desc));

		html_header_ptr->Value = (char *) malloc(strlen(str_value) + 1);
		memset(html_header_ptr->Value, (int) NULL, strlen(str_value) + 1);
		strncpy(html_header_ptr->Value, str_value, strlen(str_value));
	}

	if((!iHtml) && (!iXml) && (!iCsv))
		printf(str_format, us_tag, str_desc, str_value);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void my_printf(char *str_format, char *str_desc, char *str_value)
{
	if(html_header_ptr == NULL)
	{
		html_header_ptr = get_new_html_header_ptr();

		html_header_ptr->Desc = (char *) malloc(strlen(str_desc) + 1);
		memset(html_header_ptr->Desc, (int) NULL, strlen(str_desc) + 1);
		strncpy(html_header_ptr->Desc, str_desc, strlen(str_desc));

		html_header_ptr->Value = (char *) malloc(strlen(str_value) + 1);
		memset(html_header_ptr->Value, (int) NULL, strlen(str_value) + 1);
		strncpy(html_header_ptr->Value, str_value, strlen(str_value));

		html_header_start_ptr = html_header_ptr;
	}
	else
	{
		html_header_ptr->next = get_new_html_header_ptr();
		html_header_ptr =  html_header_ptr->next;

		html_header_ptr->Desc = (char *) malloc(strlen(str_desc) + 1);
		memset(html_header_ptr->Desc, (int) NULL, strlen(str_desc) + 1);
		strncpy(html_header_ptr->Desc, str_desc, strlen(str_desc));

		html_header_ptr->Value = (char *) malloc(strlen(str_value) + 1);
		memset(html_header_ptr->Value, (int) NULL, strlen(str_value) + 1);
		strncpy(html_header_ptr->Value, str_value, strlen(str_value));
	}

	if((!iHtml) && (!iXml) && (!iCsv))
		printf(str_format, str_desc, str_value);
}

//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
void extract_and_format_data(struct image_file_directory_entry *ifde_ptr, struct data_header *local_ptr, int iHex)
{
	int ibyte_count;
	unsigned int ubyte1;
	unsigned int ubyte2;
	unsigned int ubyte3;
	unsigned int ubyte4;
	unsigned int ubyte5;
	unsigned int ubyte6;
	unsigned long ulong;

	trace("+extract_and_format_data\n");

	ulong = Get32u(&ifde_ptr->value_offset);

	ubyte1 = (ulong & 0xff000000) >> 24;
	ubyte2 = (ulong & 0x00ff0000) >> 16;
	ubyte3 = (ulong & 0x0000ff00) >> 8;
	ubyte4 = (ulong & 0x000000ff) >> 0;
	ubyte5 = (ulong & 0xffff0000) >> 16;
	ubyte6 = (ulong & 0x0000ffff) >> 0;

	if(iTrace)
	{
		if (MotorolaOrder)
			printf("\nMM\n");
		else
			printf("\nII\n");

		printf("\ntag: %x\n", Get16u(&ifde_ptr->tag));
		printf("field_type: %d\n", Get16u(&ifde_ptr->field_type));
		printf("count: %d\n", Get32u(&ifde_ptr->count));
		printf("value_offset: %x\n", Get32u(&ifde_ptr->value_offset));
		printf("value_offset(no-Get32u): %x\n", ifde_ptr->value_offset);

		printf("\nulong: %x\n", ulong);
		printf("ubyte1: %x\n", ubyte1);
		printf("ubyte2: %x\n", ubyte2);
		printf("ubyte3: %x\n", ubyte3);
		printf("ubyte4: %x\n", ubyte4);
		printf("ubyte5: %x\n", ubyte5);
		printf("ubyte6: %x\n\n", ubyte6);
	}

	memset(trace_buffer, (int) NULL, 256);

	switch(Get16u(&ifde_ptr->field_type))
	{
		case 1:
			ibyte_count = Get32u(&ifde_ptr->count) * 1;

			if(MotorolaOrder)
			{
				if(ibyte_count == 1)
				{
					sprintf(trace_buffer, "%x", ubyte1);
				}
				else if(ibyte_count == 2)
				{
					sprintf(trace_buffer, "%x %x", ubyte1, ubyte2);
				}
				else if(ibyte_count == 3)
				{
					sprintf(trace_buffer, "%x %x %x", ubyte1, ubyte2, ubyte3);
				}
				else if(ibyte_count == 4)
				{
					sprintf(trace_buffer, "%x %x %x %x", ubyte1, ubyte2, ubyte3, ubyte4);
				}
			}
			else
			{
				if(ibyte_count == 1)
				{
					sprintf(trace_buffer, "%x", ubyte4);
				}
				else if(ibyte_count == 2)
				{
					sprintf(trace_buffer, "%x %x", ubyte4, ubyte3);
				}
				else if(ibyte_count == 3)
				{
					sprintf(trace_buffer, "%x %x %x", ubyte4, ubyte3, ubyte2);
				}
				else if(ibyte_count == 4)
				{
					sprintf(trace_buffer, "%x %x %x %x", ubyte4, ubyte3, ubyte2, ubyte1);
				}
			}
			break;
		case 2:
			ibyte_count = Get32u(&ifde_ptr->count) * 1;

			if(ibyte_count == 1)
			{
				sprintf(trace_buffer, "%c", ubyte1);
			}
			else if(ibyte_count == 2)
			{
				sprintf(trace_buffer, "%c%c", ubyte1, ubyte2);
			}
			else if(ibyte_count == 3)
			{
				if(MotorolaOrder)
					sprintf(trace_buffer, "%c%c%c", ubyte1, ubyte2, ubyte3);
				else
					sprintf(trace_buffer, "%c%c%c", ubyte4, ubyte3, ubyte2);
			}
			else if(ibyte_count == 4)
			{
				sprintf(trace_buffer, "%c%c%c%c", ubyte1, ubyte2, ubyte3, ubyte4);
			}
			break;
		case 6:
			ibyte_count = Get32u(&ifde_ptr->count) * 1;

			if(ibyte_count == 1)
			{
				sprintf(trace_buffer, "%d", ubyte1);
			}
			else if(ibyte_count == 2)
			{
				sprintf(trace_buffer, "%d %d", ubyte1, ubyte2);
			}
			else if(ibyte_count == 3)
			{
				sprintf(trace_buffer, "%d %d %d", ubyte1, ubyte2, ubyte3);
			}
			else if(ibyte_count == 4)
			{
				sprintf(trace_buffer, "%d %d %d %d", ubyte1, ubyte2, ubyte3, ubyte4);
			}
			break;
		case 3:
		case 8:
			ibyte_count = Get32u(&ifde_ptr->count) * 2;

			if((Get16u(&ifde_ptr->tag) == 0x0002) || (Get16u(&ifde_ptr->tag) == 0x0013))
			{
				if(ubyte6 != 0)
					sprintf(trace_buffer, "%d", ubyte6);
				else
					sprintf(trace_buffer, "%d", ubyte5);
			}
			else
			{
				if(ibyte_count == 2)
				{
					if(MotorolaOrder)
						sprintf(trace_buffer, "%d", ubyte5);
					else
						sprintf(trace_buffer, "%d", ubyte6);
				}
				else if(ibyte_count == 4)
				{
					sprintf(trace_buffer, "%d %d", ubyte5, ubyte6);
				}
			}
			break;
		case 4:
		case 9:
			ibyte_count = Get32u(&ifde_ptr->count) * 4;
			sprintf(trace_buffer, "%ld", ulong);
			break;
		default:
			my_exit("Unknown Field Type");
			break;
	}

        local_ptr->Value = (char *) malloc(strlen(trace_buffer) + 1);
        strcpy(local_ptr->Value, trace_buffer);

	if(iTrace)
		printf("\ntrace_buffer: %s\n", trace_buffer);

	trace("-extract_and_format_data\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void dump_jpg_image_file_directory(FILE *rfd, unsigned long offset_ifd, unsigned long offset_base, char *type_ptr)
{
	char *buff_ptr = NULL;
	char buffer[256];
	char type_buffer[256];
	struct image_file_directory_entry *ifde_ptr;
	unsigned short count;
	unsigned short num_ifd;
	unsigned long ctr1;
	unsigned long ctr3;
	long old_position;
	long temp_position;
	int ByteCount;
	unsigned long components;      		//count
	unsigned long value_offset;     	//value offset
	unsigned char *byte_ptr;
	unsigned long *long_byte_ptr;

	unsigned long maker_note_header_offset;

	trace("+dump_jpg_image_file_directory\n");

	if(iTrace)
		printf("type_ptr: %s\n", type_ptr);

	ifde_ptr = (struct image_file_directory_entry *) malloc(sizeof(struct image_file_directory_entry));
	memset(ifde_ptr, (int) NULL, sizeof(struct image_file_directory_entry));

	if(fseek(rfd, offset_ifd, 0) != -1)
	{
		fread(&count, sizeof(unsigned short), 1, rfd);
		num_ifd = Get16u(&count);

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "Number of Image File Directories: %d\n", num_ifd);
		trace(trace_buffer);
	}
	else
	{
		my_error(rfd);
	}

	for(ctr1 = 0; ctr1 < num_ifd; ctr1++)
	{
		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "\nctr1: %d\n", ctr1);
		trace(trace_buffer);

		memset(ifde_ptr, (int) NULL, sizeof(struct image_file_directory_entry));
		fread(ifde_ptr, sizeof(struct image_file_directory_entry), 1, rfd);

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "tag: %x\n", Get16u(&ifde_ptr->tag));
		trace(trace_buffer);

		jpg_header_ptr->tag = Get16u(&ifde_ptr->tag);
		jpg_header_ptr->field_type = Get16u(&ifde_ptr->field_type);
		jpg_header_ptr->count = Get32u(&ifde_ptr->count);
		jpg_header_ptr->value_offset = Get32u(&ifde_ptr->value_offset);

		if(!strncmp(type_ptr, "IFD0", 4))
			jpg_header_ptr->record_type = 1;
		else if(!strncmp(type_ptr, "SUB_IFD0", 8))
			jpg_header_ptr->record_type = 3;
		else if(!strncmp(type_ptr, "SUB_IFD1", 8))
			jpg_header_ptr->record_type = 4;
		else if(!strncmp(type_ptr, "EXIF", 4))
			jpg_header_ptr->record_type = 5;
		else if(!strncmp(type_ptr, "MAKER_NOTES", 11))
			jpg_header_ptr->record_type = 6;
		else
			jpg_header_ptr->record_type = 99;

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "Field Type: %x\n", Get16u(&ifde_ptr->field_type));
		trace(trace_buffer);

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "Number of Values: %x\n", Get32u(&ifde_ptr->count));
		trace(trace_buffer);

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "Value Offset: %x\n", Get32u(&ifde_ptr->value_offset));
		trace(trace_buffer);

		components = Get32u(&ifde_ptr->count);
		value_offset = Get32u(&ifde_ptr->value_offset) + offset_base;

		memset(trace_buffer, (int) NULL, 256);
		sprintf(trace_buffer, "components: %d\n", components);
		trace(trace_buffer);

		old_position = ftell(rfd);

		switch(Get16u(&ifde_ptr->field_type))
		{
			case 1:
				ByteCount = components * 1;
				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "ByteCount: %d\n", ByteCount);
				trace(trace_buffer);
				jpg_header_ptr->byte_count = ByteCount;


				if (ByteCount > 4)
				{
					byte_ptr = (unsigned char *) malloc(ByteCount);
					fseek(rfd, Get32u(&ifde_ptr->value_offset), 0);
					fread(byte_ptr, ByteCount, 1, rfd);
					jpg_header_ptr->data_at_offset = byte_ptr;
				}

				break;
			case 2:
				ByteCount = components * 1;
				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "ByteCount: %d\n", ByteCount);
				trace(trace_buffer);
				jpg_header_ptr->byte_count = ByteCount;

				if (ByteCount > 4)
				{
					byte_ptr = (unsigned char *) malloc(ByteCount);
					fseek(rfd, Get32u(&ifde_ptr->value_offset) + offset_base, 0);
					fread(byte_ptr, ByteCount, 1, rfd);
					jpg_header_ptr->data_at_offset = byte_ptr;
				}

				break;
			case 3:
			case 8:
				ByteCount = components * 2;
				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "ByteCount: %d\n", ByteCount);
				trace(trace_buffer);
				jpg_header_ptr->byte_count = ByteCount;

				if (ByteCount > 4)
				{
					byte_ptr = (unsigned char *) malloc(ByteCount);
					fseek(rfd, Get32u(&ifde_ptr->value_offset) + offset_base, 0);
					fread(byte_ptr, ByteCount, 1, rfd);
					jpg_header_ptr->data_at_offset = byte_ptr;
				}

				break;
			case 4:
				ByteCount = components * 4;
				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "ByteCount: %d\n", ByteCount);
				trace(trace_buffer);
				jpg_header_ptr->byte_count = ByteCount;

				if (ByteCount > 4)
				{
					if(Get16u(&ifde_ptr->tag) == TAG_SUBIFD_S)
					{
						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "Value Offset: %x\n", Get32u(&ifde_ptr->value_offset));
						trace(trace_buffer);

						my_fseek(rfd, Get32u(&ifde_ptr->value_offset), 0);
						temp_position = ftell(rfd);

						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "temp_position: %x\n", temp_position);
						trace(trace_buffer);

						for(ctr3 = 0; ctr3 < components; ctr3++)
						{
							long_byte_ptr = (unsigned long *) malloc(sizeof(unsigned long));
							*long_byte_ptr = 0;
							memset(buffer, (int) NULL, 256);
							fread(long_byte_ptr, sizeof(unsigned long), 1, rfd);
							sprintf(buffer, "%-04.4x", Get32u(long_byte_ptr));

							trace("------Start SubIFD------\n");

							//save file ptr
							temp_position = ftell(rfd);
		
							memset(trace_buffer, (int) NULL, 256);
							sprintf(trace_buffer, "temp_position: %x\n", temp_position);
							trace(trace_buffer);

							memset(trace_buffer, (int) NULL, 256);
							sprintf(trace_buffer, "offset to count: %x\n", (Get32u(long_byte_ptr)));
							trace(trace_buffer);

							memset(type_buffer, (int) NULL, 256);
							sprintf(type_buffer, "SUB_IFD%d", ctr3);

							dump_jpg_image_file_directory(rfd, (Get32u(long_byte_ptr)), 0, type_buffer);
		
							//restore file ptr
							fseek(rfd, temp_position, 0);

							trace("------End SubIFD------\n");
						}

						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "get33u_long_byte_ptr: %x\n", Get32u(long_byte_ptr));
						trace(trace_buffer);

						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "buffer: %s\n", buffer);
						trace(trace_buffer);
	
						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "long_byte_ptr: %x\n", *long_byte_ptr);
						trace(trace_buffer);

						free(long_byte_ptr);
					}
					else
					{
						byte_ptr = (unsigned char *) malloc(ByteCount);
						fseek(rfd, Get32u(&ifde_ptr->value_offset) + offset_base, 0);
						fread(byte_ptr, ByteCount, 1, rfd);
						jpg_header_ptr->data_at_offset = byte_ptr;
					}
				}
				else
				{
					if(Get16u(&ifde_ptr->tag) == TAG_THUMBNAIL_OFFSET)
					{
						lThumbnailOffset = Get32u(&ifde_ptr->value_offset);

						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "lThumbnailOffset: %ld\n", lThumbnailOffset);
						trace(trace_buffer);
					}

					if(Get16u(&ifde_ptr->tag) == TAG_THUMBNAIL_LENGTH)
					{
						lThumbnailLength = Get32u(&ifde_ptr->value_offset);

						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "lThumbnailLength: %ld\n", lThumbnailLength);
						trace(trace_buffer);
					}

					if(Get16u(&ifde_ptr->tag) == TAG_EXIF_OFFSET)
					{
						trace("------Start EXIF------\n");
						//save file ptr
						temp_position = ftell(rfd);

						memset(trace_buffer, (int) NULL, 256);
						sprintf(trace_buffer, "temp_position: %x\n", temp_position);
						trace(trace_buffer);

						memset(type_buffer, (int) NULL, 256);
						sprintf(type_buffer, "EXIF");

						//call dump_.... with offset
						dump_jpg_image_file_directory(rfd, Get32u(&ifde_ptr->value_offset) + jpg_type_offset(), jpg_type_offset(), type_buffer);

						//restore file ptr
						fseek(rfd, temp_position, 0);
						trace("------End EXIF------\n");
					}
				}
				break;
			case 5:
				ByteCount = components * 8;
				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "ByteCount: %d\n", ByteCount);
				trace(trace_buffer);
				jpg_header_ptr->byte_count = ByteCount;

				byte_ptr = (unsigned char *) malloc(ByteCount);
				memset(byte_ptr, (int) 0xFF, ByteCount);
				fseek(rfd, Get32u(&ifde_ptr->value_offset) + offset_base, 0);
				fread(byte_ptr, ByteCount, 1, rfd);
				jpg_header_ptr->data_at_offset = byte_ptr;

				break;
			case 10:
				ByteCount = components * 8;
				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "ByteCount: %d\n", ByteCount);
				trace(trace_buffer);
				jpg_header_ptr->byte_count = ByteCount;

				byte_ptr = (unsigned char *) malloc(ByteCount);
				fseek(rfd, Get32u(&ifde_ptr->value_offset) + offset_base, 0);
				fread(byte_ptr, ByteCount, 1, rfd);
				jpg_header_ptr->data_at_offset = byte_ptr;

				break;
			case 7:
				ByteCount = components * 1;
				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "ByteCount: %d\n", ByteCount);
				trace(trace_buffer);
				jpg_header_ptr->byte_count = ByteCount;

				byte_ptr = (unsigned char *) malloc(ByteCount);
				fseek(rfd, Get32u(&ifde_ptr->value_offset) + offset_base, 0);
				fread(byte_ptr, ByteCount, 1, rfd);
				jpg_header_ptr->data_at_offset = byte_ptr;

				if(Get16u(&ifde_ptr->tag) == TAG_MAKER_NOTE)
				{
					trace("------Start Maker Notes------\n");

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "%x", Get32u(&ifde_ptr->value_offset));

					//save file ptr
					temp_position = ftell(rfd);

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "old_file_position: %x\n", temp_position);
					trace(trace_buffer);

					old_byte_order = MotorolaOrder;

					maker_note_header_offset = Get32u(&ifde_ptr->value_offset) + MAKER_NOTE_PRE_HEADER_LENGTH + jpg_type_offset();

					memset(trace_buffer, (int) NULL, 256);
					sprintf(trace_buffer, "maker_note_header_offset: %x\n", maker_note_header_offset);
					trace(trace_buffer);

					fseek(rfd, maker_note_header_offset, 0);

					memset(type_buffer, (int) NULL, 256);
					sprintf(type_buffer, "MAKER_NOTES");

					//call dump_.... with offset
					dump_jpg_image_file_directory(rfd, (maker_note_header_offset + inspect_image_file_header(rfd, 1)), maker_note_header_offset, type_buffer);

					MotorolaOrder = old_byte_order;

					//restore file ptr
					fseek(rfd, temp_position, 0);
					trace("------End Maker Notes------\n");
				}

				break;
			default:
				memset(trace_buffer, (int) NULL, 256);
				sprintf(trace_buffer, "Unknown Format: %x\n", Get16u(&ifde_ptr->field_type));
				trace(trace_buffer);
				break;
		}

		jpg_header_ptr->next = (struct jpg_data_header *) malloc(sizeof(struct jpg_data_header));
		jpg_header_ptr = jpg_header_ptr->next;
		memset(jpg_header_ptr, (int) NULL, sizeof(struct jpg_data_header));
		iTagCount++;

		fseek(rfd, old_position, 0);
	}

	trace("-dump_jpg_image_file_directory\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
struct jpg_data_header * get_new_jpg_data_header_ptr()
{
	struct jpg_data_header *local_header_ptr;
	local_header_ptr = (struct jpg_data_header *) malloc(sizeof(struct jpg_data_header));
	memset(local_header_ptr, (int) NULL, sizeof(struct jpg_data_header));
	return(local_header_ptr);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
unsigned short count_tags(struct jpg_data_header *local_ptr)
{
	unsigned short tag_count = 0;

	while(local_ptr->next != NULL)
	{
		switch(local_ptr->tag)
		{
			case 0x0112:
				if(local_ptr->record_type == 1)
					break;
			case 0x829a:
			case 0x9209:
			case 0x8822:
			case 0x9207:
			case 0x0084:
			case 0x920a:
			case 0xa405:
			case 0x0083:
			case 0x8827:
			case 0x010f:
			case 0x0110:
			case 0x0131:
			case 0x9004:
			case 0x829d:
			case 0x0002:
			case 0x0013:
			case 0x0004:
			case 0x00a7:
			case 0x0007:
			case 0x0008:
			case 0x0009:
			case 0x0081:
			case 0x008b:
			case 0x008d:
			case 0x0090:
			case 0x0095:
			case 0x00a9:
			case 0x00aa:
			case 0x00ab:
			case 0xa002:
			case 0xa003:
			case 0x9204:
			case 0x9286:
				tag_count++;
				break;
			default:
				break;
		}

		local_ptr = local_ptr->next;
	}

	return(tag_count);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void output_thumbnail(char *filename, FILE *rfd)
{
	FILE *ofd;
	char buffer[256];
	unsigned long size;
	unsigned char *byte_ptr;
	unsigned char *file_ptr;
	unsigned char *file_tmp_ptr;

	char *local_argv[10];

	struct image_file_directory_entry ifde;

	struct exif_header
	{
		unsigned char ff;
		unsigned char soi;
		unsigned char pad;
		unsigned char marker;
		unsigned short length;
		unsigned char exif[6];
		unsigned char byte_order[2];
		unsigned short flag;
		unsigned int offset;
		unsigned short dir_count;
	};

	struct type5
	{
		unsigned long numerator;
		unsigned long denominator;
	};

	struct type5 *type5_ptr;

	struct lens
	{
		struct type5 field_1;
		struct type5 field_2;
		struct type5 field_3;
		struct type5 field_4;
	};

	struct lens *lens_ptr;

	struct exif_header *exif_header_ptr;
	struct jpg_data_header *temp_start_ptr = NULL;
	unsigned char *dir_buffer_ptr = NULL;
	unsigned char *temp_dir_buffer_ptr = NULL;
	unsigned char *data_buffer_ptr = NULL;
	unsigned char *temp_data_buffer_ptr = NULL;

	unsigned short dir_count = 0;
	int iStructSize = 0;
	unsigned int data_offset = 0;
	unsigned short short_length = 0;
	unsigned int ubyte1;
	unsigned int ubyte5;
	unsigned long ulong;
	unsigned long ulOrientation;

	trace("+output_thumbnail\n");

	exif_header_ptr = (struct exif_header *) malloc(sizeof(struct exif_header));
	memset(exif_header_ptr, (int) 0xFF, sizeof(struct exif_header));
	iStructSize = sizeof(struct exif_header);

	exif_header_ptr->ff = 0xFF;
	exif_header_ptr->soi = 0xD8;
	exif_header_ptr->pad = 0xFF;
	exif_header_ptr->marker = 0xE1;
	exif_header_ptr->length = 0x00;		//set this later
	memcpy(exif_header_ptr->exif,"Exif\0\0", 6);
	memcpy(exif_header_ptr->byte_order,"II", 2);
	exif_header_ptr->flag = 0x002A;
	exif_header_ptr->offset = 0x0008;

	temp_start_ptr = start_header_ptr;

	dir_count += count_tags(temp_start_ptr);

	if(iTrace)
	{
		printf("dir_count: %d\n", dir_count);
		printf("iTagCount: %d\n", iTagCount);
	}

	exif_header_ptr->dir_count = dir_count;

	dir_buffer_ptr = (unsigned char *) malloc((12 * dir_count) + 4);
	temp_dir_buffer_ptr = dir_buffer_ptr;
	data_buffer_ptr = (unsigned char *) malloc(1024);

	data_offset = sizeof(struct exif_header) + ((12 * dir_count) + 4) - 14;

	memset(dir_buffer_ptr, (int) NULL, ((12 * dir_count) + 4));
	memset(data_buffer_ptr, (int) NULL, 1024);

	short_length = ((12 * dir_count) + 4) + sizeof(struct exif_header) + 1024 - 6;
	exif_header_ptr->length = Get16u(&short_length);

	temp_data_buffer_ptr = data_buffer_ptr;

	temp_start_ptr = start_header_ptr;

	while(temp_start_ptr->next != NULL)
	{
		switch(temp_start_ptr->tag)
		{
			case 0x0112:
				if(temp_start_ptr->record_type == 1)
					break;
			case 0x829a:
			case 0x9209:
			case 0x8822:
			case 0x9207:
			case 0x0084:
			case 0x920a:
			case 0xa405:
			case 0x0083:
			case 0x8827:
			case 0x010f:
			case 0x0110:
			case 0x0131:
			case 0x9004:
			case 0x829d:
			case 0x0002:
			case 0x0013:
			case 0x0004:
			case 0x00a7:
			case 0x0007:
			case 0x0008:
			case 0x0009:
			case 0x0081:
			case 0x008b:
			case 0x008d:
			case 0x0090:
			case 0x0095:
			case 0x00a9:
			case 0x00aa:
			case 0x00ab:
			case 0xa002:
			case 0xa003:
			case 0x9204:
			case 0x9286:
				if(iTrace)
				{
					printf("tag: %x\n", temp_start_ptr->tag);
					printf("Field_type: %d\n", temp_start_ptr->field_type);
					printf("count: %d\n", temp_start_ptr->count);
					printf("value_offset: %x\n", temp_start_ptr->value_offset);
					printf("record_type: %d\n", temp_start_ptr->record_type);
				}

				ifde.tag = temp_start_ptr->tag;
				ifde.field_type = temp_start_ptr->field_type;
				ifde.count = temp_start_ptr->count;

				if(temp_start_ptr->byte_count > 4)
				{
					if(temp_start_ptr->tag == 0x829a ||
						temp_start_ptr->tag == 0x829d ||
						temp_start_ptr->tag == 0x9204 ||
						temp_start_ptr->tag == 0x920a)
					{
						type5_ptr = (struct type5 *) malloc(sizeof(struct type5));

						type5_ptr->numerator = (unsigned long) Get32u(temp_start_ptr->data_at_offset);
						type5_ptr->denominator = (unsigned long) Get32u((temp_start_ptr->data_at_offset + 4));

						memcpy(temp_data_buffer_ptr, type5_ptr, temp_start_ptr->byte_count);
						free(type5_ptr);
					}
					else if(temp_start_ptr->tag == 0x0084)
					{
						lens_ptr = (struct lens *) malloc(sizeof(struct lens));

						lens_ptr->field_1.numerator = (unsigned long) Get32u(temp_start_ptr->data_at_offset);
						lens_ptr->field_1.denominator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 4);
						lens_ptr->field_2.numerator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 8);
						lens_ptr->field_2.denominator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 12);
						lens_ptr->field_3.numerator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 16);
						lens_ptr->field_3.denominator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 20);
						lens_ptr->field_4.numerator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 24);
						lens_ptr->field_4.denominator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 28);

						memcpy(temp_data_buffer_ptr, lens_ptr, temp_start_ptr->byte_count);
						free(lens_ptr);
					}
					else
					{
						if(temp_start_ptr->tag == 0x0004)
						{
							memcpy(temp_data_buffer_ptr, "BASIC\0", strlen("BASIC\0"));
							temp_start_ptr->byte_count = strlen("BASIC\0") + 1;
							ifde.count = strlen("BASIC\0") + 1;
						}
						else if(temp_start_ptr->tag == 0x0131)
						{
							memset(buffer, (int) NULL, 256);
							sprintf(buffer, "D70Reader - v%s\0", D70_VERSION);
							memcpy(temp_data_buffer_ptr, buffer, strlen(buffer));
							temp_start_ptr->byte_count = strlen(buffer) + 1;
							ifde.count = strlen(buffer) + 1;
						}
						else
							memcpy(temp_data_buffer_ptr, temp_start_ptr->data_at_offset, temp_start_ptr->byte_count);
					}

					temp_data_buffer_ptr += temp_start_ptr->byte_count;
					ifde.value_offset = data_offset;
					data_offset += temp_start_ptr->byte_count;
				}
				else
				{
					if(temp_start_ptr->tag == 0xa405 || 
						temp_start_ptr->tag == 0x0112 ||
						temp_start_ptr->tag == 0x8822 || 
						temp_start_ptr->tag == 0x9209 || 
						temp_start_ptr->tag == 0x9207)
					{
						ulong = temp_start_ptr->value_offset;

						ubyte5 = (ulong & 0xffff0000) >> 16;

						ifde.value_offset = ubyte5;

						if(temp_start_ptr->tag == 0x0112)
						{
							ulOrientation = ubyte5;

							if(ALLOW_ROTATE)
								ifde.value_offset = 1;
						}
					}
					else if(temp_start_ptr->tag == 0x0083)
					{
						ulong = temp_start_ptr->value_offset;

						ubyte1 = (ulong & 0xff000000) >> 24;

						ifde.value_offset = ubyte1;
					}
					else
						ifde.value_offset = temp_start_ptr->value_offset;
				}

				memcpy(temp_dir_buffer_ptr, &ifde, 12);
				temp_dir_buffer_ptr += 12;
				break;
			default:
				break;
		}
	
		temp_start_ptr = temp_start_ptr->next;
	}

	switch(temp_start_ptr->tag)
	{
		case 0x0112:
			if(temp_start_ptr->record_type == 1)
				break;
		case 0x829a:
		case 0x9209:
		case 0x8822:
		case 0x9207:
		case 0x0084:
		case 0x920a:
		case 0xa405:
		case 0x0083:
		case 0x8827:
		case 0x010f:
		case 0x0110:
		case 0x0131:
		case 0x9004:
		case 0x829d:
		case 0x0002:
		case 0x0013:
		case 0x0004:
		case 0x00a7:
		case 0x0007:
		case 0x0008:
		case 0x0009:
		case 0x0081:
		case 0x008b:
		case 0x008d:
		case 0x0090:
		case 0x0095:
		case 0x00a9:
		case 0x00aa:
		case 0x00ab:
		case 0xa002:
		case 0xa003:
		case 0x9204:
		case 0x9286:
			if(iTrace)
			{
				printf("tag: %x\n", temp_start_ptr->tag);
				printf("Field_type: %d\n", temp_start_ptr->field_type);
				printf("count: %d\n", temp_start_ptr->count);
				printf("value_offset: %x\n", temp_start_ptr->value_offset);
				printf("record_type: %d\n", temp_start_ptr->record_type);
			}

			ifde.tag = temp_start_ptr->tag;
			ifde.field_type = temp_start_ptr->field_type;
			ifde.count = temp_start_ptr->count;

			if(temp_start_ptr->byte_count > 4)
			{
				if(temp_start_ptr->tag == 0x829a ||
					temp_start_ptr->tag == 0x829d ||
					temp_start_ptr->tag == 0x9204 ||
					temp_start_ptr->tag == 0x920a)
				{
					type5_ptr = (struct type5 *) malloc(sizeof(struct type5));

					type5_ptr->numerator = (unsigned long) Get32u(temp_start_ptr->data_at_offset);
					type5_ptr->denominator = (unsigned long) Get32u((temp_start_ptr->data_at_offset + 4));

					memcpy(temp_data_buffer_ptr, type5_ptr, temp_start_ptr->byte_count);
					free(type5_ptr);
				}
				else if(temp_start_ptr->tag == 0x0084)
				{
					lens_ptr = (struct lens *) malloc(sizeof(struct lens));

					lens_ptr->field_1.numerator = (unsigned long) Get32u(temp_start_ptr->data_at_offset);
					lens_ptr->field_1.denominator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 4);
					lens_ptr->field_2.numerator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 8);
					lens_ptr->field_2.denominator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 12);
					lens_ptr->field_3.numerator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 16);
					lens_ptr->field_3.denominator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 20);
					lens_ptr->field_4.numerator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 24);
					lens_ptr->field_4.denominator = (unsigned long) Get32u(temp_start_ptr->data_at_offset + 28);

					memcpy(temp_data_buffer_ptr, lens_ptr, temp_start_ptr->byte_count);
					free(lens_ptr);
				}
				else
				{
					if(temp_start_ptr->tag == 0x0004)
					{
						memcpy(temp_data_buffer_ptr, "BASIC\0", strlen("BASIC\0"));
						temp_start_ptr->byte_count = strlen("BASIC\0") + 1;
						ifde.count = strlen("BASIC\0") + 1;
					}
					else if(temp_start_ptr->tag == 0x0131)
					{
						memset(buffer, (int) NULL, 256);
						sprintf(buffer, "D70Reader - v%s\0", D70_VERSION);
						memcpy(temp_data_buffer_ptr, buffer, strlen(buffer));
						temp_start_ptr->byte_count = strlen(buffer) + 1;
						ifde.count = strlen(buffer) + 1;
					}
					else
						memcpy(temp_data_buffer_ptr, temp_start_ptr->data_at_offset, temp_start_ptr->byte_count);
				}

				temp_data_buffer_ptr += temp_start_ptr->byte_count;
				ifde.value_offset = data_offset;
				data_offset += temp_start_ptr->byte_count;
			}
			else
			{
				if(temp_start_ptr->tag == 0xa405 || 
					temp_start_ptr->tag == 0x0112 ||
					temp_start_ptr->tag == 0x8822 || 
					temp_start_ptr->tag == 0x9209 || 
					temp_start_ptr->tag == 0x9207)
				{
					ulong = temp_start_ptr->value_offset;

					ubyte5 = (ulong & 0xffff0000) >> 16;

					ifde.value_offset = ubyte5;

					if(temp_start_ptr->tag == 0x0112)
					{
						ulOrientation = ubyte5;

						if(ALLOW_ROTATE)
							ifde.value_offset = 1;
					}
				}
				else if(temp_start_ptr->tag == 0x0083)
				{
					ulong = temp_start_ptr->value_offset;

					ubyte1 = (ulong & 0xff000000) >> 24;

					ifde.value_offset = ubyte1;
				}
				else
					ifde.value_offset = temp_start_ptr->value_offset;
			}

			memcpy(temp_dir_buffer_ptr, &ifde, 12);
			temp_dir_buffer_ptr += 12;
			break;
		default:
			break;
	}

	if(ALLOW_ROTATE)
	{
		if(ulOrientation == 6 || ulOrientation == 8)
		{
			file_tmp_ptr = (char *) malloc(strlen(filename) + strlen(".tmp") + strlen(".JPG") + 1);
			memset(file_tmp_ptr, (int) NULL, (strlen(filename) + strlen(".tmp") + strlen(".JPG") + 1));
			strcat(file_tmp_ptr, filename);
			strcat(file_tmp_ptr, ".tmp.JPG");

			if(iTrace)
				printf("\nfile_tmp_ptr: %s\n", file_tmp_ptr);
		}
	}

	file_ptr = (char *) malloc(strlen(filename) + strlen(".JPG") + 1);
	memset(file_ptr, (int) NULL, (strlen(filename) + strlen(".JPG") + 1));
	strcat(file_ptr, filename);
	strcat(file_ptr, ".JPG");

	if(iTrace)
		printf("\nfile_ptr: %s\n", file_ptr);

	byte_ptr = (char *) malloc(lThumbnailLength);

	fseek(rfd, lThumbnailOffset + 2, 0);
	fread(byte_ptr, lThumbnailLength, 1, rfd);

	if(ulOrientation == 6 || ulOrientation == 8)
	{
		if(ALLOW_ROTATE)
		{
			if((ofd = fopen(file_tmp_ptr, "wb")) == NULL)
			{
				printf("\nFile not created: %s\n\n", file_tmp_ptr);
				exit(1);
			}
		}
		else
		{
			if((ofd = fopen(file_ptr, "wb")) == NULL)
			{
				printf("\nFile not created: %s\n\n", file_ptr);
				exit(1);
			}
		}
	}
	else
	{
		if((ofd = fopen(file_ptr, "wb")) == NULL)
		{
			printf("\nFile not created: %s\n\n", file_ptr);
			exit(1);
		}
	}

	if((size = fwrite(exif_header_ptr, (sizeof(struct exif_header) - 2), 1, ofd)) == 0)
	{
		printf("\nFile not written: %s\n\n", file_ptr);
		exit(1);
	}


	if((size = fwrite(dir_buffer_ptr, ((12 * dir_count) + 4), 1, ofd)) == 0)
	{
		printf("\nFile not written: %s\n\n", file_ptr);
		exit(1);
	}

	if((size = fwrite(data_buffer_ptr, 1024, 1, ofd)) == 0)
	{
		printf("\nFile not written: %s\n\n", file_ptr);
		exit(1);
	}

	if((size = fwrite(byte_ptr, lThumbnailLength, 1, ofd)) == 0)
	{
		printf("\nFile not written: %s\n\n", file_ptr);
		exit(1);
	}

	printf("Created file: %s\n", file_ptr);

	fclose(ofd);

	if(ALLOW_ROTATE)
	{
		if(ulOrientation == 6 || ulOrientation == 8)
		{
			local_argv[0] = "jpgtran";
			local_argv[1] = "-rot";
	
			if(ulOrientation == 6)
				local_argv[2] = "90";
			else
				local_argv[2] = "270";
	
			local_argv[3] = "-copy";
			local_argv[4] = "all";
			local_argv[5] = file_tmp_ptr;
			local_argv[6] = file_ptr;
			local_argv[7] = NULL;

			jpegtran(7, local_argv);

			if(remove(file_tmp_ptr))
				printf("File not deleted: %s\n", file_tmp_ptr);
		}
	}

	free(byte_ptr);
	free(file_ptr);

	free(exif_header_ptr);
	free(dir_buffer_ptr);
	free(data_buffer_ptr);

	trace("-output_thumbnail\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void free_jpg_data_header_list(struct jpg_data_header *header_ptr)
{
	struct jpg_data_header *temp_header_ptr = NULL;

	trace("+free_jpg_data_header_list\n");

	while(header_ptr->next != NULL)
	{
		temp_header_ptr = header_ptr;
		header_ptr = header_ptr->next;
		free(temp_header_ptr);
	}

	free(header_ptr);
	trace("-free_jpg_data_header_list\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void ProcessFileJPG(int argc, char *filename)
{
	FILE *rfd;
	char buffer[256];
	char *temp_ptr = NULL;
	unsigned long offset_ifd;
	int ctr1 = 0;
	struct data_header_ptr *temp_header_start_ptr = NULL;
	struct data_header_ptr *free_header_start_ptr = NULL;
	struct html_header *free_html_header_start_ptr = NULL;

	trace("+ProcessFileJPG\n");

	temp_ptr = get_extension(filename);

	memset(trace_buffer, (int) NULL, 256);
	sprintf(trace_buffer, "File Extension: %s\n", temp_ptr);
	trace(trace_buffer);

	if(!strncmp(upper_case(temp_ptr), "JPG", 3))
	{
		iFile_Type = 0;
		my_jpg_exit("Only files of type NEF can be processed using opton -j");
	}
	else
	{
		iJPG_Type = 99;
		iFile_Type = 1;
	}

	if((rfd = fopen(filename, "rb")) == NULL)
	{
		printf("\nFile not found: %s\n\n", filename);
		exit(1);
	}

	memset(buffer, (int) NULL, 256);
	sprintf(buffer, "IFD%d", ctr1++);

	offset_ifd = inspect_image_file_header(rfd, iFile_Type);
	jpg_header_ptr = get_new_jpg_data_header_ptr();
	start_header_ptr = jpg_header_ptr;
	dump_jpg_image_file_directory(rfd, offset_ifd, jpg_type_offset(), buffer);

	if(iThumbnail)
	{
		if(iFile_Type)
			output_thumbnail(filename, rfd);
	}

	fclose(rfd);

	free_jpg_data_header_list(start_header_ptr);

	trace("-ProcessFileJPG\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
int check_for_exif_data(FILE *rfd)
{
	int ctr1 = 0;
	int iFoundEXIF = 0;

	long position;
	long old_position;
	int oldMotorolaOrder;

	struct marker
	{
		unsigned char pad;
		unsigned char marker;
		unsigned short length;
		char test_data[6];
	};

	struct marker *temp_ptr;

	oldMotorolaOrder = MotorolaOrder;
	MotorolaOrder = 1;

	old_position = ftell(rfd);

	temp_ptr = (struct marker *) malloc(sizeof(struct marker));

	fseek(rfd, 2, 0);

	do
	{
		ctr1++;
		position = ftell(rfd);

		memset(temp_ptr, (int) NULL, sizeof(struct marker));
		fread(temp_ptr, sizeof(struct marker), 1, rfd);

		if(!strncmp(temp_ptr->test_data, "Exif\0\0", 6))
		{
			iFoundEXIF = 1;
			break;
		}
		else
			fseek(rfd, Get16u(&temp_ptr->length) - sizeof(struct marker) + 2, 1);

		if(temp_ptr->marker == 0xda)
			break;
	}
	while(strncmp(temp_ptr->test_data, "Exif\0\0", 6));	

	fseek(rfd, old_position, 0);

	MotorolaOrder = oldMotorolaOrder;

	return(iFoundEXIF);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void check_for_config()
{
	int ctr1 = 0;
	unsigned long size;
	struct stat buf;
	char buffer[256];
	char *file_ptr = NULL;
	char *data_buffer_ptr = NULL;
	FILE *ofd;
	FILE *rfd;
	struct wanted_tags *local_header_ptr;

	trace("\n+check_for_config");

	if(iSystemType)
	{
		file_ptr = (char *) malloc(strlen(file_sys_dir_ptr) + strlen("\\d70reader.conf") + 1);
		memset(file_ptr, (int) NULL, strlen(file_sys_dir_ptr) + strlen("\\d70reader.conf") + 1);
		strcat(file_ptr, file_sys_dir_ptr);
		strcat(file_ptr, "\\d70reader.conf");
	}
	else
	{
		file_ptr = (char *) malloc(strlen(file_sys_dir_ptr) + strlen("/d70reader.conf") + 1);
		memset(file_ptr, (int) NULL, strlen(file_sys_dir_ptr) + strlen("/d70reader.conf") + 1);
		strcat(file_ptr, file_sys_dir_ptr);
		strcat(file_ptr, "/d70reader.conf");
	}

	if(stat(file_ptr, &buf) == (-1))
	{
		if((ofd = fopen(file_ptr, "w")) == NULL)
		{
			printf("\nFile not created: %s\n", file_ptr);
			printf("\nThis must be done by the 'root' user.\n\n");
			exit(0);
		}

		//fputs("D70ReaderProgramVersion=yes", ofd);
		//fputs("Filename=yes", ofd);

		for(ctr1 = 0; ctr1 < SizeTagTable; ctr1++)
		{
			switch(TagTable[ctr1].Tag)
			{
				case 0x0112:
				case 0x829a:
				case 0x9209:
				case 0x8822:
				case 0x9207:
				case 0x0084:
				case 0x920a:
				case 0xa405:
				case 0x0083:
				case 0x8827:
				case 0x010f:
				case 0x0110:
				case 0x0131:
				case 0x9004:
				case 0x829d:
				case 0x0002:
				case 0x0013:
				case 0x0004:
				case 0x00a7:
				case 0x0007:
				case 0x0008:
				case 0x0009:
				case 0x0081:
				case 0x008b:
				case 0x008d:
				case 0x0090:
				case 0x0095:
				case 0x00a9:
				case 0x00aa:
				case 0x00ab:
				case 0xa002:
				case 0xa003:
				case 0x9204:
				case 0x9286:

					data_buffer_ptr = (char *) malloc(strlen(strip(TagTable[ctr1].Desc)) + 6);
					memset(data_buffer_ptr, (int) NULL, strlen(strip(TagTable[ctr1].Desc)) + 6);
					sprintf(data_buffer_ptr, "%s=yes\n", strip(TagTable[ctr1].Desc));

					if((size = fwrite(data_buffer_ptr, (strlen(strip(TagTable[ctr1].Desc)) + 5), 1, ofd)) == 0)
					{
						printf("\nFile not written: %s\n\n", file_ptr);
						return;
					}

					store_tags(data_buffer_ptr);
					free(data_buffer_ptr);

					break;
				default:
					break;
			}
		}

		fclose(ofd);

#ifdef __UNIX_ONLY__
		chmod(file_ptr, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
#endif
	}
	else
	{
		if((rfd = fopen(file_ptr, "r")) == NULL)
		{
			printf("\nFile not opened: %s\n\n", file_ptr);
			return;
		}

		do
		{
			memset(buffer, (int) NULL, 256);
			data_buffer_ptr = fgets(buffer, 256, rfd);

			if(data_buffer_ptr == NULL)
				break;

			store_tags(buffer);

			if(iTrace)
				printf("buffer: %s", buffer);
		}
		while(data_buffer_ptr != NULL);

		if(iTrace)
		{
			printf("\nDumping wanted_tags list\n");

			local_header_ptr = start_wanted_tags_ptr;

			do
			{
				printf("\nTag: %x", local_header_ptr->tag);
				local_header_ptr = local_header_ptr->next;
			}
			while(local_header_ptr != NULL); 
		}
	}

	trace("\n+check_for_config");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
void store_tags(char *local_ptr)
{
	int ctr1;
	char *temp_ptr = NULL;
	
	trace("\n+store_tags\n");

	temp_ptr = strdup(local_ptr);

	temp_ptr = get_description(temp_ptr);

	if(iTrace)
		printf("\nlocal_ptr: %s", temp_ptr);

	for(ctr1 = 0; ctr1 < SizeTagTable; ctr1++)
	{
		if(!strncmp(TagTable[ctr1].Desc, temp_ptr, strlen(temp_ptr)) && (strlen(strip(TagTable[ctr1].Desc)) == strlen(temp_ptr)))
		{
			if(tag_is_yes(local_ptr))
			{
				if(iTrace)
					printf("\nFound Tag: %x\n", TagTable[ctr1].Tag);

				if(main_wanted_tags_ptr == NULL)
				{
					main_wanted_tags_ptr = get_new_main_wanted_tags_ptr();
					main_wanted_tags_ptr->next = NULL;
					main_wanted_tags_ptr->tag = TagTable[ctr1].Tag;
					start_wanted_tags_ptr = main_wanted_tags_ptr;
				}
				else
				{
					main_wanted_tags_ptr->next = get_new_main_wanted_tags_ptr();
					main_wanted_tags_ptr =  main_wanted_tags_ptr->next;
					main_wanted_tags_ptr->next = NULL;
					main_wanted_tags_ptr->tag = TagTable[ctr1].Tag;
				}

				trace("\n-store_tags\n");
				return;
			}
		}
	}

	trace("\n-store_tags\n");
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
struct wanted_tags *get_new_main_wanted_tags_ptr()
{
	struct wanted_tags *local_header_ptr;
	local_header_ptr = (struct wanted_tags *) malloc(sizeof(struct wanted_tags));
	memset(local_header_ptr, (int) NULL, sizeof(struct wanted_tags));
	return(local_header_ptr);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
int tag_is_yes(char *local_ptr)
{
	int iWanted = 0;
	char *temp_ptr;
	char *final_ptr;
	char *token;

	trace("\n+tag_is_yes");

	temp_ptr = strdup(local_ptr);

	token = strtok(temp_ptr, "=");

	do
	{
		if(token != NULL)
			final_ptr = token;

		token = strtok(NULL, "=");
	}
	while(token != NULL);

	if(!strncmp(upper_case(final_ptr), "YES", strlen("YES")))
		iWanted = 1;
	else
		iWanted = 0;

	trace("\n-tag_is_yes");
	return(iWanted);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
int is_tag_printed(unsigned short tag)
{
	int iWanted = 0;

	struct wanted_tags *local_header_ptr;

	trace("\n+is_tag_printed");

	local_header_ptr = start_wanted_tags_ptr;

	if(iTrace)
		printf("\ntag: %x", tag);

	do
	{
		if(local_header_ptr->tag == tag)
		{
			iWanted = 1;
			break;
		}
		else
			iWanted = 0;

		local_header_ptr = local_header_ptr->next;
	}
	while(local_header_ptr != NULL); 

	if(iTrace)
		printf("\niWanted: %d", iWanted);

	trace("\n-is_tag_printed");
	return(iWanted);
}

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
char *get_description(char *str_input)
{
	char *temp_ptr;
	char *token;

	trace("+get_description\n");

	temp_ptr = strdup(str_input);

	token = strtok(temp_ptr, "=");

	trace("-get_description\n");
	return(token);
}

