import java.awt.*;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;


/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

public class AboutBox extends Dialog implements ActionListener, KeyListener{

	private static Button okayButton, cancelButton;
	Label lineLabel;
	private static TextArea text;

	public AboutBox(){
		super(MuckMain.textWindow, "(JamochaMUD) About", true);
		// The "About Box" for JamochaMUD information
		
		// Design look for gridbag layout
		GridBagLayout dLayout = new GridBagLayout();
		GridBagConstraints constraints = new GridBagConstraints();
		this.setLayout(dLayout);
		
		// Add the components to the dialog
				
		text = new TextArea("", 18, 60, TextArea.SCROLLBARS_NONE);
		text.addKeyListener(this);
		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.fill = GridBagConstraints.BOTH;
		constraints.anchor = GridBagConstraints.CENTER;
		dLayout.setConstraints(text, constraints);
		add(text);
	
		okayButton = new Button(RB("credits"));
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 1;
		constraints.fill = GridBagConstraints.NONE;
		constraints.anchor = GridBagConstraints.WEST;
		dLayout.setConstraints(okayButton, constraints);
		okayButton.addActionListener(this);
		add(okayButton);
		
		cancelButton = new Button(RB("thanksalot!"));
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 1;
		constraints.gridy = 1;
		constraints.fill = GridBagConstraints.NONE;
		constraints.anchor = GridBagConstraints.EAST;
		dLayout.setConstraints(cancelButton, constraints);
		cancelButton.addActionListener(this);
		add(cancelButton);

		pack();
	}

	public static void Content(){
		// Create the dialogue box
		AboutBox aBDialogue = new AboutBox();
		
		// Now set the size and location of the dialogue
		aBDialogue.setLocation(83, 55);
		aBDialogue.setSize(475, 370);
		DisplayLicense();
		aBDialogue.show();
	}

	/*
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "AboutBox", itemTarget);
	}


	private static void DisplayLicense() {
		// First, empty the text area
		text.setText("");

		// Write the GPL information
		text.append("JamochaMUD - a (Java) MUD / MUCK client \n");
		text.append("Copyright (C) 1998-1999  Jeff Robinson (jeffnik@autobahn.mb.ca)\n");
		text.append("\n");
		text.append("This program is free software; you can redistribute it and/or\n");
		text.append("modify it under the terms of the GNU General Public License\n");
		text.append("as published by the Free Software Foundation; either version 2\n");
		text.append("of the License, or any later version.\n");
		text.append("\n");
		text.append("This program is distributed in the hope that it will be useful,\n");
		text.append("but WITHOUT ANY WARRANTY; without even the implied\n");
		text.append("warranty of MERCHANTABILITY or FITNESS FOR A\n");
		text.append("PARTICULAR PURPOSE.  See the GNU General Public License\n");
		text.append("for more details.\n");
		text.append("\n");
		text.append("You should have received a copy of the GNU General Public License\n");
		text.append("along with this program; if not, write to the\n");
		text.append("Free Software Foundation, Inc., 59 Temple Place - Suite 330,\n");
		text.append("Boston, MA  02111-1307, USA.");
		okayButton.setLabel(RB("credits"));		
	}

	private void ShowCredits() {
		// First, empty the text area
		text.setText("");

		// Write the credits
		// In the future, perhaps this will be on a Canvas instead
		text.append("Jeff Robinson - High(ly caffeinated) Muckymuck (jeffnik@autobahn.mb.ca) \n");
		text.append("\n");
		text.append("Jason Holmgren - Annoying Vermin \n");
		text.append("\n");
		text.append("Sean Simpson - Head Haranguer \n"); 		
		text.append("\n");
		text.append("Sara Palmer - Chief of Wahness \n");
		text.append("\n");
		text.append("Sandi Wilkinson - Wizzywizz \n");
		text.append("\n");
		text.append("Miguel Estrugo - Man of many words \n");

		// Change the button to 'About'
		okayButton.setLabel(RB("aboutJamochaMUD"));		
	}
	
	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();
		
		if (arg.equals(cancelButton.getLabel())) {
			// dismiss the dialogue
			dispose();
		}

		if (arg.equals(okayButton.getLabel())) {
			// Check to see which function to call
			if (arg.equals(RB("credits"))) {
				// Change to display the credits
				ShowCredits();
			} else {
				// Change to display the license
				DisplayLicense();
			}
		}

	}

	public void keyPressed(KeyEvent event){
		event.consume();
		return;
	}
	
	public void keyTyped(KeyEvent event){}

	public void keyReleased(KeyEvent event){}


}
