
import java.awt.*;
import java.awt.event.*;

import java.io.IOException;

import java.util.Vector;

/*
 * Allows the designation of external programs for
 * extension of JamochaMUD's capabilities
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

public class ExternalProgs extends Dialog implements ActionListener, MouseListener{

	private Button browser1B, browser2B, fTPClientB, eMailClientB, pictureViewerB, okayButton, cancelButton;
	private FileDialog progDialogue;	
	private Label ePLabel;
	private TextField browser1, browser2, fTPClient, eMailClient, pictureViewer;
	private boolean returnText;
	
	private static ExternalProgs eProg;
	private static Frame ePFrame;
	

	public ExternalProgs(Frame frameParent){

		super(frameParent, "JamochaMUD - " + RB("title"), true);
		
		// Set Gridbag layout
		GridBagLayout ePLayout = new GridBagLayout();
		GridBagConstraints constraints = new GridBagConstraints();
		this.setLayout(ePLayout);
		
		// Add dialogue components	
		Label ePLabel = new Label(RB("primaryWebBrowser"));
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.fill = GridBagConstraints.NONE;
		ePLayout.setConstraints(ePLabel, constraints);
		add(ePLabel);

		browser1 = new TextField("", 30);
		constraints.gridwidth = 4;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 1;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(browser1, constraints);
		add(browser1);
		browser1.setText((String)MuckConn.jmVars.get("Browser1"));	
		System.out.println("Browser 1 set from Hashtable");

		browser1B = new Button(RB("locate"));
		browser1B.setActionCommand("Browser1");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 4;
		constraints.gridy = 1;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(browser1B, constraints);
		browser1B.addActionListener(this);
		add(browser1B);


		// A blank label for spacing
		// ePLabel = new Label("");
		// constraints.gridwidth = 5;
		// constraints.gridheight = 1;
		// constraints.gridx = 0;
		// constraints.gridy = 2;
		// constraints.fill = GridBagConstraints.BOTH;
		// ePLayout.setConstraints(ePLabel, constraints);
		// add(ePLabel);

		ePLabel = new Label(RB("secondaryWebBrowser"));
		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 3;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(ePLabel, constraints);
		add(ePLabel);

		browser2 = new TextField("", 30);
		constraints.gridwidth = 4;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 4;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(browser2, constraints);
		add(browser2);
		browser2.setText((String)MuckConn.jmVars.get("Browser2"));	

		browser2B = new Button(RB("locate"));
		browser2B.setActionCommand("Browser2");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 4;
		constraints.gridy = 4;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(browser2B, constraints);
		browser2B.addActionListener(this);
		add(browser2B);

		// A blank label for spacing
		// ePLabel = new Label("");
		// constraints.gridwidth = 5;
		// constraints.gridheight = 1;
		// constraints.gridx = 0;
		// constraints.gridy = 5;
		// constraints.fill = GridBagConstraints.BOTH;
		// ePLayout.setConstraints(ePLabel, constraints);
		// add(ePLabel);
		
		ePLabel = new Label(RB("fTPClient"));
		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 7;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(ePLabel, constraints);
		add(ePLabel);

		fTPClient = new TextField("", 30);
		constraints.gridwidth = 4;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 8;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(fTPClient, constraints);
		add(fTPClient);
		fTPClient.setText((String)MuckConn.jmVars.get("FTPClient"));	

		fTPClientB = new Button(RB("locate"));
		fTPClientB.setActionCommand("FTPClient");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 4;
		constraints.gridy = 8;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(fTPClientB, constraints);
		fTPClientB.addActionListener(this);
		add(fTPClientB);

		ePLabel = new Label(RB("eMailClient"));
		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 10;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(ePLabel, constraints);
		add(ePLabel);

		eMailClient = new TextField("", 30);
		constraints.gridwidth = 4;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 11;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(eMailClient, constraints);
		add(eMailClient);
		eMailClient.setText((String)MuckConn.jmVars.get("EMailClient"));	

		eMailClientB = new Button(RB("locate"));
		eMailClientB.setActionCommand("E-mail");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 4;
		constraints.gridy = 11;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(eMailClientB, constraints);
		eMailClientB.addActionListener(this);
		add(eMailClientB);

		// Add the 'okay' and 'cancel' buttons at the end.
		okayButton = new Button(RB("okay"));
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 1;
		constraints.gridy = 12;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(okayButton, constraints);
		okayButton.addActionListener(this);
		add(okayButton);

		cancelButton = new Button(RB("cancel"));
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 3;
		constraints.gridy = 12;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(cancelButton, constraints);
		cancelButton.addActionListener(this);
		add(cancelButton);

		pack();
	}


	public static void Content(Frame frameParent){
		ePFrame = new Frame();
		eProg = new ExternalProgs(frameParent);
		Dimension d = (Dimension)MuckConn.jmVars.get("ScreenSize");
		int swidth = (int) d.width; // Cast 'd' to integer
		int bwidth = (int) ((swidth / 2) - 100);
		eProg.setLocation(bwidth, 160);
		eProg.setSize(350, 250);
		eProg.setResizable(false);
		eProg.show();
	}

	/*
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "ExternalProgs", itemTarget);
	}


	private void showFileDialogue(String title, TextField affectedItem) {
		// Create the dialogue
		progDialogue = new FileDialog(ePFrame, title);
		progDialogue.show();

		// Check to see if a file was selected
		try {
			String directoryName = new String(progDialogue.getDirectory());
			String fileName = new String(progDialogue.getFile());
			affectedItem.setText(directoryName + fileName);
		} catch (Exception e) {
			System.out.println("ExternalProgs (file selected exception) " + e);
		}		
		
	}

	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();
		
		if (arg.equals(okayButton.getLabel())) {
			// Save new choices
			MuckConn.jmVars.put("Browser1", browser1.getText());
			MuckConn.jmVars.put("Browser2", browser2.getText());
			MuckConn.jmVars.put("FTPClient", fTPClient.getText());
			MuckConn.jmVars.put("EMailClient", eMailClient.getText());

			JMWriteRC.Content();
			dispose();
		}

		if (arg.equals(cancelButton.getLabel())) {
			// discard any changes
			dispose();
		}

		if (arg.equals("Browser1")) {
			showFileDialogue(RB("primaryWebBrowser"), browser1);	
		}

		if (arg.equals("Browser2")) {
			showFileDialogue(RB("secondaryWebBrowser"), browser2);
		}

		if (arg.equals("FTPClient")) {
			showFileDialogue(RB("fTPClient"), fTPClient);
		}

		if (arg.equals("E-mail")) {
			showFileDialogue(RB("eMailClient"), eMailClient);
		}

	}

	// Mouse events
	public void mousePressed(MouseEvent e) {}

	public void mouseReleased(MouseEvent e) {}

        public void mouseClicked(MouseEvent e) {}

	public void mouseEntered(MouseEvent e) {}

	public void mouseExited(MouseEvent e) {}

	// A separate class to launch selected programs...
	public static void LaunchProgram(CloseableFrame workingFrame, StringBuffer tentativeURL) {
	
		// First, determine if it is a valid URL
		String uRLToUse = new String("");
		uRLToUse = testURL(tentativeURL);	
		
		// Now determine correct program to launch
		String progName = new String("null");	
		progName = whichProgram(uRLToUse.trim());	
		
		// Check to see if the response is a valid type
		if (progName.toLowerCase().equals("null")) {
			System.out.println("No viewer configured");
		} else {
			// Launch the selected program
			try {
				Process p = Runtime.getRuntime().exec(progName + " " + uRLToUse.trim());
			
				//...("start netscape") under windows
				// p.waitFor();
			} catch (IOException ioe) {
				System.out.println("ExternalProgs: Doing IOException");
				// There was an IO Exception, most likely
				// generated due to no program being
				// assigned to this 'URL' type
//				MuckConn.oKDOkay = true;
//				MuckConn.oKDCancel = true;
//				MuckConn.oKDIgnore = false;
				MuckConn.jmVars.put("Okay", "true");
				MuckConn.jmVars.put("Cancel", "false");
				MuckConn.jmVars.put("Ignore", "false");
				Vector tempVector = new Vector(0, 1);
				tempVector.addElement("There is no program currently");
				tempVector.addElement("configured for this file type.");
				tempVector.addElement("Select 'OKAY' to configure");
				tempVector.addElement("the external programs now.");
				tempVector.addElement("");
		OKBox.RunOkay(workingFrame, null, null, false, false, null, null, true, tempVector, "Configure external programs?", 250, 200);

//				if (MuckConn.oKDOkay) {
				if (((String)MuckConn.jmVars.get("Okay")).equals("true")) {
					// Yes was chosen, set the programs
					Content(workingFrame);
				}

			} catch (Exception e) {
				System.out.println("warning: " + e);
			}
		}
	}

	private static String testURL(StringBuffer tentativeURL) {
		boolean testResult;

		// Test the URL to see if it is in fact a *valid* URL
		// First, test for superfluous characters
		// such as . , " and perhaps others
		
		// Test beginning of the string
		for (int i = 0; i<=tentativeURL.length(); i++) {
			
			// A result of true means that it is a valid character
			if (characterCheck(tentativeURL.charAt(i))) {
				// End loop
				break;
			} else {
				// The result is false, change that char
				// into a blank space
				tentativeURL.setCharAt(i, ' ');
			}
		}		

		// Now check from the back end of the StringBuffer
		for (int i = (tentativeURL.length() - 1); i>=1; i--) {
			// Call a generic routine to test
			
			// A result of true means that it is a valid character
			if (characterCheck(tentativeURL.charAt(i))) {
				// End the loop
				break;
			} else {
				// The result if false, change that
				// char into a blank space
				tentativeURL.setCharAt(i, ' ');
			}	
		}
		String finalURL = tentativeURL.toString();
		finalURL.trim();
		
		// temporary return to allow compiling
		return finalURL;
	
	}

	private static boolean characterCheck(char testChar) {
		boolean result = true;
		
		// See if the character is "legal"
		if (!Character.isLetterOrDigit(testChar)) {
			System.out.println("The character is not a letter or digit");
			result = false;
		}
		return result;
	}

	private static String whichProgram(String tU) {
		String fileType = new String("null");
		String browserPath = new String("null");
	
		// Hopefully, this will be replaced with user
		// defined file-browser associations in the future

		// Check for tell-tale signs of which program to use
		// Do HTML first, being probably the most common
		if (tU.toLowerCase().endsWith("html") || tU.toLowerCase().startsWith("www") || tU.toLowerCase().startsWith("http")) {
			fileType = "HTML";
		}
	
		// Check for E-mail address
		if (tU.indexOf("@") >= 0) {
			fileType = "E-mail";
		}

		if (tU.startsWith("ftp")) {
			fileType = "FTP";
		}

		if (tU.endsWith("jpeg") || tU.endsWith("jpg") || tU.endsWith("gif")) {
			fileType = "Image";
		}

		// Find a more efficient way of doing this, too?
		if (fileType.equals("HTML"))
//			browserPath = MuckConn.browser1;
			browserPath = (String)MuckConn.jmVars.get("Browser1");
		if (fileType.equals("E-mail"))
//			browserPath = MuckConn.eMailClient;
			browserPath = (String)MuckConn.jmVars.get("Browser2");
		if (fileType.equals("FTP"))
//			browserPath = MuckConn.fTPClient;
			browserPath = (String)MuckConn.jmVars.get("FTPClient");
		if (fileType.equals("Image"))
			browserPath = (String)MuckConn.jmVars.get("EMailClient");
//			browserPath = MuckConn.browser2;
		
		  
		// This returns fileType for now.  Later it will return
		// program location, etc.
		return browserPath;
	}

}
