import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;

import java.util.Hashtable;
import java.util.Vector;

/*
 * WriteRC, a replacement for WriteINI (January 17, 1999)
 * Write .jamocha.rc and from all
 * from all information available
*/

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

public class JMWriteRC{

	private boolean readLoop;
	private File oldFile, renamedFile;
	private FileOutputStream outFile;
	private Hashtable jmSections;
	private PrintWriter out;
	private String str;
	private RandomAccessFile file;
	private Vector oldRC, newFile;
	

	public JMWriteRC(){

		jmSections = new Hashtable();

		readLoop = true;
		oldRC = new Vector(0, 1);
		newFile = new Vector(0, 1);

		// Read the existing INI file into a vector
		// adding the new information when applicable
		try {
			// First make sure the vector is empty
			newFile.removeAllElements();

			// Now try to open the file
			file = new RandomAccessFile(EnumPlugIns.userDirectory + ".jamocha.rc", "r");
			while (readLoop) {
				str = (file.readLine()).trim();
				
				// Check to see if it's a comment, blank space
				// or a flag.
				try {
					if (str.startsWith("#") || str.startsWith("[")) {
						// The string starts with # or [, so we keep it!
						oldRC.addElement(str);
					}
					
				} catch (Exception ns) {
					// Null string.  Replace with a blank line
					// newFile.addElement("");
					// System.out.println("Blank line " + ns);
				}						
			}
		} catch (Exception e) {
			// System.out.println("WriteINI: (Writeloop) Exception " + e);
			// End of file
			readLoop = false;
		}	
	
		try {
			// close .jamocha.rc
			file.close();
		} catch (Exception e) {
			// File is already closed?
		}

		// Add the new information to the new vector
		JMBuildNewRC();

		// Now it is time to write this information to a new temp file
		try {
			outFile = new FileOutputStream(EnumPlugIns.userDirectory + ".jamocha.rc.temp", false);
			out = new PrintWriter(outFile, true);
			
			// Loop through until all the information is written out
			for (int i = 0; i<newFile.size(); i++) {
				out.println(newFile.elementAt(i).toString());
			}
			outFile.close();
		} catch (Exception e) {
			System.out.println("JMWriteRC: (outFile) Exception generated : " + e);
			e.printStackTrace();
		}

		// We've written the temporary file.
		// now copy this file onto the original
		
		try {
			RandomAccessFile from = new RandomAccessFile(EnumPlugIns.userDirectory + ".jamocha.rc.temp", "r");
    			RandomAccessFile to = new RandomAccessFile(EnumPlugIns.userDirectory + ".jamocha.rc", "rw");
    			int b;
    			while((b = from.read()) >= 0){
        			to.write(b);
    			}

			try {
	    			to.close();
			} catch (Exception ce) {
				System.out.println("JMWriteRC: to.close exception");
			}

			try {
				from.close();
			} catch (Exception ce) {
				System.out.println("JMWriteRC: from.close exception");
			}

		} catch (Exception e) {
			System.out.println("JMWriteRC: Renaming file exception : " + e);
		}

			// We have successfully written the .rc file
			// and it is now safe to delete the temp file
		try {
			File tempFile = new File(EnumPlugIns.userDirectory + ".jamocha.rc.temp");
			tempFile.delete();
		} catch (Exception de) {
			System.out.println("Temp file delete exception " + de);
		}

		// Last but not least, lets serialise the macros
		SerialiseMacros();

//		MuckConn.editor = false;  // This allows the program to close
	}

	public static void Content() {
		JMWriteRC a = new JMWriteRC();
	}
	
	// These section will each write the data for their relevant area
	private void WriteWorlds() {
		newFile.addElement("[Worlds]");

		Vector muckName = new Vector(0, 1);
		Vector muckAddy = new Vector(0, 1);
		Vector muckPort = new Vector(0, 1);
		muckName = (Vector)MuckConn.jmVars.get("MuckName");
		muckAddy = (Vector)MuckConn.jmVars.get("MuckAddy");
		muckPort = (Vector)MuckConn.jmVars.get("MuckPort");

		// loop through until all worlds are gone		
		for (int i = 0; i < muckName.size(); i++) {
			// Add all the world elements to the vector

			try {
				newFile.addElement(muckName.elementAt(i).toString());
				newFile.addElement(muckAddy.elementAt(i).toString());			
				newFile.addElement(muckPort.elementAt(i).toString());
			} catch (Exception e) {
				System.out.println("JMWriteRC: Exception writing worlds " + e);
			}

			newFile.addElement("");
		}

		jmSections.put("MUWorlds", "false");
	}


	private void WriteForegroundColour() {
		// Get the colour of the font from the window
		Color tempColour = MuckMain.mainText.getForeground();
		
		newFile.addElement("[FGColour]");
		newFile.addElement(tempColour.getRed() + "");
		newFile.addElement(tempColour.getGreen() + "");
		newFile.addElement(tempColour.getBlue() + "");
		newFile.addElement("");
		jmSections.put("ForegroundColour", "false");
	}
	
	private void WriteBackgroundColour() {
		// Get the colour of the font from the window
		Color tempColour = MuckMain.mainText.getBackground();
		
		newFile.addElement("[BGColour]");
		newFile.addElement(tempColour.getRed() + "");
		newFile.addElement(tempColour.getGreen() + "");
		newFile.addElement(tempColour.getBlue() + "");
		newFile.addElement("");
		jmSections.put("BackgroundColour", "false");
	}

	private void WriteMainWindow() {
		newFile.addElement("[MainWindow]");
		
		if (MuckConn.jmVars.contains("MainWindow")) {
			Rectangle tempFrame = (Rectangle)MuckConn.jmVars.get("MainWindow");
			newFile.addElement(((tempFrame.getLocation()).x) + "");
			newFile.addElement(((tempFrame.getLocation()).y) + "");
			newFile.addElement((tempFrame.getSize().width) + "");
			newFile.addElement((tempFrame.getSize().height) + "");
			
		} else {
			newFile.addElement(((MuckMain.textWindow.getLocationOnScreen()).x) + "");
			newFile.addElement(((MuckMain.textWindow.getLocationOnScreen()).y) + "");
			newFile.addElement((MuckMain.textWindow.getSize().width) + "");
			newFile.addElement((MuckMain.textWindow.getSize().height) + "");
		}

		newFile.addElement("");
		jmSections.put("MainWindow", "false");
	}

	private void WriteDataBar() {
		newFile.addElement("[DataBar]");

		if (MuckConn.jmVars.containsKey("DataBar")) {
			Rectangle tempFrame = (Rectangle)MuckConn.jmVars.get("DataBar");
			newFile.addElement(((tempFrame.getLocation()).x) + "");
			newFile.addElement(((tempFrame.getLocation()).y) + "");
			newFile.addElement((tempFrame.getSize().width) + "");
			newFile.addElement((tempFrame.getSize().height) + "");
		} else {
			newFile.addElement(((DataIn.dataBar.getLocationOnScreen()).x) + "");
			newFile.addElement(((DataIn.dataBar.getLocationOnScreen()).y) + "");
			newFile.addElement((DataIn.dataBar.getSize().width) + "");
			newFile.addElement((DataIn.dataBar.getSize().height) + "");
		} 

		newFile.addElement("");
		jmSections.put("DataBar", "false");
	}

	private void WriteMacroWindow() {
	
		// These two lines will be correct regardless
		newFile.addElement("[Macrobar]");
//		newFile.addElement(MuckConn.macroVisible + "");
		newFile.addElement(MuckConn.jmVars.get("MacroVisible"));
			
		if (MuckConn.jmVars.containsKey("MacroFrame")) {
			// Take the variables from the hashtable, the frame isn't visible
			Rectangle tempFrame = (Rectangle)MuckConn.jmVars.get("MacroFrame");
			newFile.addElement(((tempFrame.getLocation()).x) + "");
			newFile.addElement(((tempFrame.getLocation()).y) + "");
			newFile.addElement((tempFrame.getSize().width) + "");
			newFile.addElement((tempFrame.getSize().height) + "");
		} else {
			// Take the variables from the frame, since it is visible
			newFile.addElement((MuMacros.macroFrame.getLocationOnScreen()).x + "");
			newFile.addElement((MuMacros.macroFrame.getLocationOnScreen()).y + "");
			newFile.addElement(MuMacros.macroFrame.getSize().width + "");
			newFile.addElement(MuMacros.macroFrame.getSize().height + "");

		}

		// MacroBar isn't visible, so use the
		// information provided from the
		// static variables
		newFile.addElement("");
		jmSections.put("MacroWindow", "false");				
	}

	private void WriteFontFace() {
		newFile.addElement("[FontFace]");
		try {
			newFile.addElement((MuckMain.mainText.getFont().getName()) + "");
			newFile.addElement((MuckMain.mainText.getFont().getStyle()) + "");
			newFile.addElement((MuckMain.mainText.getFont().getSize()) + "");
			newFile.addElement("");
			jmSections.put("FontFace", "false");
		} catch (Exception e) {
			System.out.println("Exception in font " + e);
		}
	}

	private void WriteMacros() {
	}

	public void WriteBrowser(String number) {
		if (number.equals("1")) {
			newFile.addElement("[Browser1]");
			try {
				String temp1 = new String(MuckConn.jmVars.get("Browser1").toString().trim());
				if (temp1.equals("")) {
					newFile.addElement("empty");
				} else {
					newFile.addElement(temp1);
				}
			} catch (Exception e) {
				newFile.addElement("empty");
			}
			
		} else {
			newFile.addElement("[Browser2]");
			try {
				String temp1 = new String(MuckConn.jmVars.get("Browser2").toString());
				if (temp1.equals("")) {
					temp1 = new String("empty");	
				}
				newFile.addElement(temp1);
			} catch (Exception e) {
				newFile.addElement("empty");
			}
			System.out.println("Complete");
		}

		newFile.addElement("");
	}

	public void WriteFTPClient() {
		newFile.addElement("[FTP Client]");
		
			// Add the configured client
			try {
				String temp1 = new String(MuckConn.jmVars.get("FTPClient").toString().trim());
				if (temp1.equals("")) {
					temp1 = new String("empty");
				}
				newFile.addElement(temp1);
			} catch (Exception e) {
				newFile.addElement("empty");
			}

		newFile.addElement(" ");

	}

	public void WriteEMailClient() {
		newFile.addElement("[E-Mail Client]");
		
			try {
				String temp1 = MuckConn.jmVars.get("EMailClient").toString().trim();
				if (temp1.equals("")) {
					temp1 = new String("empty");
				}
				newFile.addElement(temp1);
			} catch (Exception e) {
				newFile.addElement("empty");
			}

		newFile.addElement(" ");

	}

	public void JMUseUnicode() {
		newFile.addElement("[Unicode]");
		newFile.addElement(MuckConn.jmVars.get("UseUnicode").toString());
		newFile.addElement(" ");
	}

	public void SerialiseMacros() {
		// This new method (as of 12/09/98) will serialise the macro
		// labels and their associated actions
		try {
			FileOutputStream outputFile = new FileOutputStream(EnumPlugIns.userDirectory + ".macros.rc");
			ObjectOutputStream serializeStream = new ObjectOutputStream(outputFile);
			serializeStream.writeObject(MuckConn.jmVars.get("MacroLabels"));
			serializeStream.writeObject(MuckConn.jmVars.get("MacroDefs"));
			serializeStream.flush();
		} catch (Exception e) {
			System.out.println("(JMWriteRC) Macro serialization error " + e);
		}

	}

	private void WriteAutoFocusInput() {
		newFile.addElement("[AutoFocusInput]");
		newFile.addElement(MuckConn.jmVars.get("AutoFocusInput"));
		newFile.addElement("");
		jmSections.put("AutoFocusInput", "false");
	}

	/**
	 * Sorts the tags, making sure that the 
	 * current tag has not been already filled
	 */
	private void JMSortTags(String str) {
		if (str.equalsIgnoreCase("[worlds]") && !jmSections.containsKey("MUWorlds")) {
			WriteWorlds();
		}

		if (str.equalsIgnoreCase("[FGColour]") && !jmSections.containsKey("ForegroundColour")) {
			WriteForegroundColour();
		}

		if (str.equalsIgnoreCase("[BGColour]") && !jmSections.containsKey("BackgroundColour")) {
			WriteBackgroundColour();
		}

		if (str.equalsIgnoreCase("[mainwindow]") && !jmSections.containsKey("MainWindow")) {
			WriteMainWindow();
		}

		if (str.equalsIgnoreCase("[databar]") && !jmSections.containsKey("DataBar")) {
			WriteDataBar();
		}

		if (str.equalsIgnoreCase("[macrobar]") && !jmSections.containsKey("MacroWindow")) {
			WriteMacroWindow();
		}

		if (str.equalsIgnoreCase("[fontface]") && !jmSections.containsKey("FontFace")) {
			WriteFontFace();
		}

		if (str.equalsIgnoreCase("[autofocusinput]") && !jmSections.containsKey("AutoFocusInput")) {
			WriteAutoFocusInput();
		}

	}

	private void JMBuildNewRC() {
		// Build the new .rc vector
		// First, empty the newFile vector
		newFile.removeAllElements();
		String str;

		// Now loop through oldRC, and insert proper information when needed
		for (int i = 0; i < oldRC.size(); i++) {

			str = oldRC.elementAt(i).toString();
			if (str.startsWith("[")) {
				// This is a world tag... we'll see if it is valid
				JMSortTags(str);
			} else {
				// Check to see if this is a comment.
				// If not, discard the line.  (Double-checking never hurts)
				if (str.startsWith("#")) {
					newFile.addElement(str);
				}
			}
		}
		// Add "constant" items
		JMUseUnicode();

		// now add the External programs
		WriteBrowser("1");
		WriteBrowser("2");
		WriteFTPClient();
		WriteEMailClient();
	}

}
