import java.awt.*;
import java.awt.event.*;


/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

public class MacroDialog extends Dialog implements ActionListener, KeyListener, MouseListener{

	private List buttonList;
	private Button okayButton, cancelButton, applyButton, deleteButton;
	private String mLArray[], mDArray[]; 	// Temp arrays to hold changes
	private TextArea macroDef;
	private TextField macroName;
		
	public MacroDialog(){
		super(MuMacros.macroFrame, "JamochaMUD - " + RB("title"), true);
		// Add/Edit/Remove modal dialogue
		// This will create a specialised modal dialogue simply
		// for adding/editing/removing Macro buttons and definitions
		
		// Design look for gridbag layout
		GridBagLayout dLayout = new GridBagLayout();
		GridBagConstraints constraints = new GridBagConstraints();
		this.setLayout(dLayout);
		
		// Add the components to the dialog
		
		// Add list of Macro button names
		buttonList = new List(8, false); 	// Multiple selections not allowed
		
		mLArray = (String[]) MuckConn.jmVars.get("MacroLabels");
		mDArray = (String[]) MuckConn.jmVars.get("MacroDefs");
		for (int i = 0; i<8; i++) {
			buttonList.add(mLArray[i]);
		}
		buttonList.select(0);
		buttonList.addMouseListener(this);
		
		constraints.gridwidth = 2;
		constraints.gridheight = 5;
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.insets = new Insets(7, 7, 2, 2);
		constraints.fill = GridBagConstraints.BOTH;
		dLayout.setConstraints(buttonList, constraints);
		add(buttonList);

		// Add label and text field for editable button name
		Label mdLabel = new Label(RB("macroName"));
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 2;
		constraints.gridy = 0;
		constraints.insets = new Insets(7, 2, 2, 2);
		constraints.anchor = GridBagConstraints.CENTER;
		constraints.fill = GridBagConstraints.NONE;
		dLayout.setConstraints(mdLabel, constraints);
		add(mdLabel);
		
		macroName = new TextField(mLArray[buttonList.getSelectedIndex()], 15);
		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 3;
		constraints.gridy = 0;
		constraints.insets = new Insets(7, 2, 2, 7);
		constraints.fill = GridBagConstraints.HORIZONTAL;
		constraints.gridwidth = GridBagConstraints.RELATIVE;
		dLayout.setConstraints(macroName, constraints);
		add(macroName);

		// Add macro definition box, and fill with 'selected' macro
		macroDef = new TextArea(mDArray[buttonList.getSelectedIndex()], 7, 20, TextArea.SCROLLBARS_VERTICAL_ONLY);
		constraints.gridwidth = 3;
		constraints.gridheight = 3;
		constraints.gridx = 2;
		constraints.gridy = 1;
		constraints.insets = new Insets(2, 2, 2, 7);
		constraints.fill = GridBagConstraints.BOTH;
		constraints.anchor = GridBagConstraints.CENTER;
		constraints.gridwidth = GridBagConstraints.RELATIVE;
		dLayout.setConstraints(macroDef, constraints);
		add(macroDef);
		macroDef.addKeyListener(this);
		
		// Add APPLY button
		applyButton = new Button(RB("applyButton"));
		constraints.gridwidth = 3;
		constraints.gridheight = 1;
		constraints.gridx = 2;
		constraints.gridy = 4;
		constraints.insets = new Insets(2, 2, 2, 7);
		constraints.fill = GridBagConstraints.NONE;
		dLayout.setConstraints(applyButton, constraints);
		add(applyButton);
		applyButton.addActionListener(this);

		// Add OKAY button
		okayButton = new Button(RB("okayButton"));
		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 1;
		constraints.gridy = 6;
		constraints.insets = new Insets(7, 7, 7, 7);
		constraints.fill = GridBagConstraints.NONE;
		dLayout.setConstraints(okayButton, constraints);
		add(okayButton);
		okayButton.addActionListener(this);

		// Add DELETE button
		deleteButton = new Button(RB("deleteButton"));
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 2;
		constraints.gridy = 6;
		constraints.insets = new Insets(7, 7, 7, 7);
		constraints.fill = GridBagConstraints.NONE;
		constraints.anchor = GridBagConstraints.CENTER;
		dLayout.setConstraints(deleteButton, constraints);
		add(deleteButton);
		deleteButton.addActionListener(this);

		cancelButton = new Button(RB("cancelButton"));
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 3;
		constraints.gridy = 6;
		constraints.insets = new Insets(7, 7, 7, 7);
		constraints.fill = GridBagConstraints.NONE;
		constraints.anchor = GridBagConstraints.WEST;
		dLayout.setConstraints(cancelButton, constraints);
		add(cancelButton);
		cancelButton.addActionListener(this);

		pack();
	}

	public static void Content(){
		MacroDialog mDialogue = new MacroDialog();
		
		// Now set the size and location of the dialogue
		mDialogue.setLocation(150, 200);
		mDialogue.setSize(375, 300);
		mDialogue.show();
	}

	public void ChangeItem() {
		// When the list is clicked, this assigns the new values to
		// the appropriate sections
		int a = buttonList.getSelectedIndex();
		macroName.setText(mLArray[a]);
		macroDef.setText(mDArray[a]);	
	}

	/*
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "MacroDialog", itemTarget);
	}

	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();
		
		if (arg.equals(cancelButton.getLabel())){
			// Hit the cancel button
			setVisible(false);
			dispose();
			// This returns the dialog, without changes
		}
		
		if (arg.equals(okayButton.getLabel())){
			// Write new information into the static Vector
			for (int i = 0; i < 8; i++) {
				MuckConn.jmVars.put("MacroLabels", mLArray);
				MuckConn.jmVars.put("MacroDefs", mDArray);
			}	
			
			// Use 'brute force' to assign new names to the Macro Buttons
			MuMacros.macro0.setLabel(mLArray[0]);
			MuMacros.macro1.setLabel(mLArray[1]);
			MuMacros.macro2.setLabel(mLArray[2]);
			MuMacros.macro3.setLabel(mLArray[3]);
			MuMacros.macro4.setLabel(mLArray[4]);
			MuMacros.macro5.setLabel(mLArray[5]);
			MuMacros.macro6.setLabel(mLArray[6]);
			MuMacros.macro7.setLabel(mLArray[7]);
			setVisible(false);
			dispose();
			
		}
		
		if (arg.equals(applyButton.getLabel())) {
			int a = buttonList.getSelectedIndex();
			mLArray[a] = macroName.getText();	// add new macro name
			mDArray[a] = macroDef.getText();	// add new macro definition
			buttonList.replaceItem(macroName.getText(), a);	// change list name
			buttonList.requestFocus();
			buttonList.select(a);
		}

		if (arg.equals(deleteButton.getLabel())) {
			int a = buttonList.getSelectedIndex();
			mLArray[a] = "";
			mDArray[a] = "";
			macroName.setText(mLArray[a]);
			macroDef.setText(mDArray[a]);	
			buttonList.replaceItem(macroName.getText(), a);	// change list name
			buttonList.select(a);
		}
	}

	// Keyboard events
	public void keyPressed(KeyEvent event){
		int arg = event.getKeyCode();
		
		if (arg == KeyEvent.VK_ENTER || arg == KeyEvent.VK_PAGE_UP || arg == KeyEvent.VK_PAGE_DOWN || arg == KeyEvent.VK_END || arg == KeyEvent.VK_HOME || arg ==KeyEvent.VK_UP || arg == KeyEvent.VK_DOWN) {
			// Consume unwanted keystrokes, namely:
			// Enter key
			// Page Up
			// Page Down
			// End
			// Home
			// up arrrow
			// down arrow
			
			event.consume();
		}
	}

	public void keyTyped(KeyEvent event){}
	
	public void keyReleased(KeyEvent event){}

	// Mouse Events
	public void mousePressed(MouseEvent e) {
		ChangeItem();
	}
	public void mouseReleased(MouseEvent e) {
		ChangeItem();
	}
        public void mouseClicked(MouseEvent e) {
	}
	public void mouseEntered(MouseEvent e) {
	}
	public void mouseExited(MouseEvent e) {
	}
	
}

