
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/*
 * MuMacros
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

public class MuMacros extends Frame implements ActionListener, KeyListener, WindowListener{


	public static Button macro0, macro1, macro2, macro3, macro4, macro5, macro6, macro7;
	public static String mLabel[], mDef[];
	// public static Frame macroFrame;
	public static SyncFrame macroFrame;
	String arg;
	static MuMacros z;
	private MenuItem editMacros, hideMacros;
	private Vector tempVector;
	
	public MuMacros() {
		macroFrame = new SyncFrame("Macros");
		macroFrame.addWindowListener(this);
	

		String[] mLabel = (String[])MuckConn.jmVars.get("MacroLabels");
		mDef = (String[])MuckConn.jmVars.get("MacroDefs");			

		// Create the windows
		Panel macroPanel = new Panel();
		macro0 = new Button(mLabel[0]);
		macro0.addActionListener(this);
		macro0.addKeyListener(this);
		macroPanel.add(macro0);
		macro1 = new Button(mLabel[1]);
		macro1.addActionListener(this);
		macro1.addKeyListener(this);
		macroPanel.add(macro1); // Add Buttons to Frame
		macro2 = new Button(mLabel[2]);
		macro2.addActionListener(this);
		macro2.addKeyListener(this);
		macroPanel.add(macro2);
		macro3 = new Button(mLabel[3]);
		macro3.addActionListener(this);
		macroPanel.add(macro3);
		macro4 = new Button(mLabel[4]);
		macro4.addActionListener(this);
		macro4.addKeyListener(this);
		macroPanel.add(macro4);
		macro5 = new Button(mLabel[5]);
		macro5.addActionListener(this);
		macro5.addKeyListener(this);
		macroPanel.add(macro5);
		macro6 = new Button(mLabel[6]);
		macro6.addActionListener(this);
		macro6.addKeyListener(this);
		macroPanel.add(macro6);
		macro7 = new Button(mLabel[7]);
		macro7.addActionListener(this);
		macro7.addKeyListener(this);
		macroPanel.add(macro7);

		// parent.add(macroPanel);
		macroFrame.add(macroPanel);
		macroPanel.addKeyListener(this);

	
	
	
		// Add Menu Bar and items to textWindow

		MenuBar macroMenuBar = new MenuBar();
		// parent.setMenuBar(macroMenuBar);
		macroFrame.setMenuBar(macroMenuBar);
		Menu macroMenu = new Menu(RB("label.options"));
		macroMenuBar.add(macroMenu);
		macroMenu.add(editMacros = new MenuItem(RB("editMacros")));
		macroMenu.addSeparator();
		macroMenu.add(hideMacros = new MenuItem(RB("hideMacros")));
		macroMenu.addActionListener(this);

		// Set size and location
		macroFrame.setBounds((Rectangle)MuckConn.jmVars.get("MacroFrame"));
		macroFrame.setIconImage((Image)MuckConn.jmVars.get("JamochaMUDImage"));
		macroFrame.setVisible(true);

	}

	/*
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "MuMacros", itemTarget);
	}

	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();
		
			if (arg.equals(hideMacros.getLabel())) {
				// Call HideFrame to save location of Frame
				HideFrame();
			}
		
			if (arg == "Add Macro") {
				MacroDialog.Content();
			}

			if (arg.equals(editMacros.getLabel())) {
				MacroDialog.Content();
			}

			// Do a quick loop through the button tags
			for (int i = 0; i<8; i++) {
				String[] mLabel = (String[]) MuckConn.jmVars.get("MacroLabels");
				if (arg.equals(mLabel[i])) {
					// One of the macro buttons has been selected
					// Send the content of the button to the databar
					DataIn.dataText.requestFocus();
					String[] mDef = (String[]) MuckConn.jmVars.get("MacroDefs");
					DataIn.dataText.setText(mDef[i]);
					
				}
			}
	}

	public void keyPressed(KeyEvent event){
		if (event.getKeyCode() == KeyEvent.VK_ALT) {
			MuckMain.mainText.requestFocus();
		} else {
			DataIn.dataText.requestFocus();
		}
		return;
	}
	
	public void keyTyped(KeyEvent event){}

	public void keyReleased(KeyEvent event){}

	// Frame events
	public void windowActivated(WindowEvent event) {
//		try {
//			MuckConn.jmVars.remove("MacroFrame");
//		} catch (Exception e) {
//			// Nothing to worry about
//			System.out.println("Error removing MacroBar from hashtable");
//		}	
		MuckConn.jmVars.put("MacroFrame", macroFrame.getBounds());
		
	}

	public void windowClosed(WindowEvent event) {}

	public void windowClosing(WindowEvent event) {
		// Hide the macroWindow
		MuckConn.jmVars.put("MacroFrame", macroFrame.getBounds());
		HideFrame();
	}

	public void windowDeactivated(WindowEvent event) {}

	public void windowDeiconified(WindowEvent event) {
	}

	public void windowIconified(WindowEvent event) {
		MuckConn.jmVars.put("MacroFrame", macroFrame.getBounds());
	}

	public void windowOpened(WindowEvent event) {}

	public static void Content() {

		z = new MuMacros();

		try {
			MuckConn.jmVars.remove("MacroFrame");
		} catch (Exception e) {
			// Okay, we won't remove it, then
			System.out.println("Some sort've error removing the MacroFrame key." + e);
		}

	}

	public static void HideFrame() {
		// This gathers the parameters of the frame, for use with .jamocha.rc
		MuckConn.jmVars.put("MacroFrame", macroFrame.getBounds());

		// Send focus to the Databar, and then destroy the Macro Window
		DataIn.dataText.requestFocus();
		macroFrame.setVisible(false);
		
		// Return to MuckConn that window is no longer visible
		MuckConn.jmVars.put("MacroVisible", "false");

		// Change MuckMain menu item to show window is not visible
		MuckMain.tWMacro.setState(false);

		// Destroy this class
		macroFrame.dispose();
			
	}

}
