
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/*
 * OKBox (Re-usable dialog box)
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

public class OKBox extends Dialog implements ActionListener{
	protected static Frame oKDFrame;
	private Button okayButton, cancelButton, ignoreButton;
	private GridBagLayout oKBoxLayout;
	private GridBagConstraints constraints;
	private Label gLabel;
	private static boolean jmOkay, jmCancel, jmIgnore;		
				
	public OKBox(Frame frameParent, TextField oKDText1, TextField oKDText2, boolean 			oKDTy1, boolean oKDTy2, String oKDLabel1, String oKDLabel2, boolean 			oKDModal, Vector oKDMessage, String boxLabel){


		super(frameParent, boxLabel, oKDModal);
			
		oKBoxLayout = new GridBagLayout();
		constraints = new GridBagConstraints();

		setLayout(oKBoxLayout);

		int lineCount = 0;

		// Set this one constraint first, so that the initial inset
		// leaves more room at the top.

		constraints.insets = new Insets(7, 7, 0, 7);

		if (oKDMessage.size() > 0) {
			for (int i = 0; i < oKDMessage.size(); i++) {
				gLabel = new Label(oKDMessage.elementAt(i).toString());
				System.out.println(oKDMessage.elementAt(i).toString());
				// constraints.gridx = 0;
				constraints.gridy = i;
				constraints.fill = GridBagConstraints.HORIZONTAL;
				constraints.anchor = GridBagConstraints.WEST;
				constraints.gridwidth = GridBagConstraints.REMAINDER;					oKBoxLayout.setConstraints(gLabel, constraints);
				add(gLabel);

				constraints.insets = new Insets(0, 7, 0, 7);
				// oKDMessage.removeElementAt(0);
				
				lineCount++;
			}
			// Now empty the message vector
			oKDMessage.removeAllElements();
		}

		// Give the buttons a new line;		
		lineCount++;

		if (jmOkay) {
			// System.out.println("OkD");
			okayButton = new Button(RB("okayButton"));
			// oKPanel1.add("South", okayButton);
			constraints.gridy = lineCount;
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			if (!jmCancel && !jmIgnore) {
				constraints.gridwidth = GridBagConstraints.REMAINDER;
			} else {
				constraints.gridwidth = GridBagConstraints.RELATIVE;
			}
			oKBoxLayout.setConstraints(okayButton, constraints);
			add(okayButton);	
			okayButton.addActionListener(this);
				
		}

		if (jmCancel) {
			// System.out.println("Cancel");
			cancelButton = new Button(RB("cancelButton"));
			// oKPanel1.add("South", cancelButton);
			constraints.gridy = lineCount;
			constraints.fill = GridBagConstraints.NONE;
			if (!jmOkay && !jmIgnore) {
				constraints.anchor = GridBagConstraints.EAST;
			} else {
				constraints.anchor = GridBagConstraints.CENTER;
			}
			if (!jmIgnore) {
				constraints.gridwidth = GridBagConstraints.REMAINDER;
			} else {
				constraints.gridwidth = GridBagConstraints.RELATIVE;
			}
			oKBoxLayout.setConstraints(cancelButton, constraints);
			add(cancelButton);
			cancelButton.addActionListener(this);
		}
		
		if (jmIgnore) {
			// System.out.println("Ignore");
			ignoreButton = new Button(RB("ignoreButton"));
			// oKPanel1.add("South", ignoreButton);
			constraints.gridy = lineCount;
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			constraints.gridwidth = GridBagConstraints.REMAINDER;
			oKBoxLayout.setConstraints(ignoreButton, constraints);
			add(ignoreButton);
			ignoreButton.addActionListener(this);
			}
		
		// add(oKPanel1);
		pack();
	}


	public static void RunOkay(Frame frameParent, TextField oKDText1, TextField 				oKDText2, boolean oKDTy1, boolean okDTy2, String oKDLabel1, String 			oKDLabel2, boolean oKDModal, Vector oKDMessage, String boxLabel, int 			oKDWidth, int oKDHeight){

		// Set the variables for the 'buttons'
		if (((String)MuckConn.jmVars.get("Okay")).equals("true")) {
			jmOkay = true;
		} else {
			jmOkay = false;
		}
	
		if (((String)MuckConn.jmVars.get("Cancel")).equals("true")) {
			jmCancel = true;
		} else {
			jmCancel = false;
		}

		if (((String)MuckConn.jmVars.get("Ignore")).equals("true")) {
			jmIgnore = true;
		} else {
			jmIgnore = false;
		}
	
		oKDFrame = new Frame();
		OKBox editIt = new OKBox(frameParent, oKDText1, oKDText2, oKDTy1, okDTy2, 			oKDLabel1, oKDLabel2, oKDModal, oKDMessage, boxLabel);
		Dimension d = new Dimension((Dimension)MuckConn.jmVars.get("ScreenSize"));

		int swidth = (int) d.width; // Cast 'd' to integer
		int bwidth = (int) ((swidth / 2) - (oKDWidth / 2));
		editIt.setLocation(bwidth, 160);
		editIt.setSize(oKDWidth, oKDHeight);
		editIt.show();
	}

	/*
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "OKBox", itemTarget);
	}


	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();
		
		if (jmOkay) {
			if (arg.equals(okayButton.getLabel())){
//				jmOkay = true;
//				jmIgnore = false;
//				jmCancel = false;
				setVisible(false);
				JMWriteBooleans();
				dispose();
			}
		}

		if (jmCancel) {
			if (arg.equals(cancelButton.getLabel())){
				jmOkay = false;
				jmIgnore = false;
				jmCancel = true;
				JMWriteBooleans();
				setVisible(false);
				dispose();
			}
		}

		if (jmIgnore) {
			if (arg.equals(ignoreButton.getLabel())){
				jmOkay = false;
				jmIgnore = true;
				jmCancel = false;
				JMWriteBooleans();
				setVisible(false);
				dispose();
			}
		}
		
	}

	private void JMWriteBooleans() {
		// This is really kludgy, but I like it
		MuckConn.jmVars.put("Okay", jmOkay + "");
		MuckConn.jmVars.put("Ignore", jmIgnore + "");
		MuckConn.jmVars.put("Cancel", jmCancel + "");
	}
	
}
