// 
// ResReader.java
// Contains functions to simplify reading
// language resource bundles, taking the bulk
// of the code out of the other classes
//

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


import java.util.ResourceBundle;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.StringTokenizer;

public class ResReader{

	private static ResourceBundle rB;
	private static String finalString;
	private static Vector finalVector;

	/* Method for reading simple Resource bundles,
	 * such as labels and short strings
	 */
	public static String LangString(String bundleName, String className, String itemName){
		rB = ResourceBundle.getBundle(bundleName);
		finalString = new String(ExtractString(rB, className, itemName));		
		// All we need is the single string, 
		// so return it to the calling class	
		return finalString.trim();
	}


	/* Method for reading multiple-line
	 * messages from resource bundles
	 */
	public static Vector LangVector(String bundleName, String className, String itemName) {
		rB = ResourceBundle.getBundle(bundleName);
		return RBFinalVector(rB, className, itemName);
	}

	// Grab the string from the Resource Bundle
	private static String ExtractString(ResourceBundle rB, String className, String itemName) {
		String extractString = new String("");

		try {
//			if ((labelName.trim()).equals("")) {
				extractString = rB.getString(className + "." + itemName);
//			} else {
//				extractString = rB.getString(className + "." + itemName + "." + labelName);
//			}

		} catch (MissingResourceException e) {
//			System.out.println("Missing Resource Exception " + className + "." + itemName + "." + labelName);
			System.out.println("Missing Resource Exception " + className + "." + itemName);
		}

		return extractString;
	}
	

	private static Vector RBFinalVector(ResourceBundle rB, String className, String itemName) {
		// This method grabs a multi-lined message
		String tempString = new String("");				

		try {
//			if ((labelName.trim()).equals("")) {
				tempString = rB.getString(className + "." + itemName);

//			} else {
//				tempString = rB.getString(className + "." + itemName + "." + labelName);
//			}

		} catch (MissingResourceException e) {
//			System.out.println("Missing Resource Exception " + className + "." + itemName + "." + labelName);
			System.out.println("Missing Resource Exception " + className + "." + itemName);
		}	

		return RBStringToVector(tempString);
	}

	private static Vector RBStringToVector(String tempString) {
		// Tokenize the string into an array
		StringTokenizer tokenizer = new StringTokenizer(tempString, "||");
		Vector tokenVector = new Vector(0, 1);
		
		while (tokenizer.hasMoreTokens()) {
			tokenVector.addElement(tokenizer.nextToken());
		}

		return tokenVector;
	}
}
