


GP(1)                     User Commands                     GP(1)



NNNNAAAAMMMMEEEE
     gp - PARI calculator

SSSSYYYYNNNNOOOOPPPPSSSSIIIISSSS
     ggggpppp [----eeeemmmmaaaaccccssss] [----ffff] [----tttteeeesssstttt] [----qqqq] [----ssss _s_t_a_c_k_s_i_z_e] [----pppp _p_r_i_m_e_l_i_m_i_t]


DDDDEEEESSSSCCCCRRRRIIIIPPPPTTTTIIIIOOOONNNN
     Invokes the PARI-GP calculator. This  is  an  advanced  pro-
     grammable calculator, which computes symbolically as long as
     possible, numerically where needed, and contains a wealth of
     number-theoretic  functions  (elliptic  curves,  class field
     theory...). Its basic data types are

     numbers
          integers, real numbers, exact rational  numbers,  alge-
          braic numbers, pppp-adic numbers, complex numbers,

     modular integers
          integers modulo nnnn,

     polynomials
          and rational functions,

     power series,

     binary quadratic forms,

     matrices, vectors,
          and lists,

     character strings,

     and recursive combinations of these.


OOOOPPPPTTTTIIIIOOOONNNNSSSS
     A numeric argument to the following options can be  followed
     by  a  kkkk  or a MMMM at the user's convenience. In that case the
     argument is multiplied by 1000 or 1000000 respectively.  The
     following command line options are available:

     ----eeeemmmmaaaaccccssss
          GP can be run in an _E_m_a_c_s shell (see GP  User's  manual
          for  details).  This  flag  is then required for smooth
          interaction with the relevant _E_m_a_c_s package  (pari.el).
          It  is  set  automatically  by the pari.el package, and
          will produce nice display oddities if you set  it  out-
          side of an _E_m_a_c_s session.

     ----ffff    Fast start (or factory settings). Do  not  read  ....ggggpppprrrrcccc
          (see below) upon startup.



SunOS 5.5.1         Last change: 25 June 1999                   1






GP(1)                     User Commands                     GP(1)



     ----qqqq    Quiet mode. Don't print headers  or  history  numbers,
          don't say goodbye.

     ----pppp _p_r_i_m_e_l_i_m_i_t
          Upon startup, GP computes a table of small primes  used
          in most number-theoretic applications. If _p_r_i_m_e_l_i_m_i_t is
          set here, include primes up to that  bound  instead  of
          the  default.   Unreasonably high values will consider-
          ably increase startup time.  Exceedingly  small  values
          will cause some number-theoretic functions to fail with
          the message "not enough precomputed primes".

     ----ssss _s_t_a_c_k_s_i_z_e
          Size of GP internal stack. The stack is increased  from
          within GP in case of need but might interrupt an impor-
          tant computation.  If your machine can stand it,  start
          with  a  bigger stack (especially if you make heavy use
          of  linear  algebra).  Not  that  computations  with  a
          ssssmmmmaaaalllllllleeeerrrr  stack may be more efficient due to better data
          locality. Sensible computations should need  less  than
          20MB.

     ----tttteeeesssstttt
          run GP in  test  mode:  suppress  printing  of  history
          numbers  and  wrap  long  output lines (to get readable
          diff output). For benches only.

UUUUSSSSEEEE
     ????    to get online help.

     ????????   to get extended online help (more  precisely,  to  call
          the external help program, ggggpppphhhheeeellllpppp by default)

     qqqquuuuiiiitttt (or \q), or EEEEOOOOFFFF (Ctrl-D) to quit ggggpppp.

     The following works only when gp was linked with  GNU  _r_e_a_d_-
     _l_i_n_e library:

     arrow keys
          for editing and viewing the input history.

     TTTTAAAABBBB   for automatic completion


MMMMAAAANNNNUUUUAAAALLLLSSSS
     The following material is included in the standard distribu-
     tion (originally in TeX format):

     _T_h_e _P_A_R_I/_G_P _U_s_e_r_s'_s _M_a_n_u_a_l
          (users.dvi)

     _P_A_R_I/_G_P, _a _t_u_t_o_r_i_a_l



SunOS 5.5.1         Last change: 25 June 1999                   2






GP(1)                     User Commands                     GP(1)



          (tutorial.dvi): not yet completed but still useful.

     _P_A_R_I/_G_P _r_e_f_e_r_e_n_c_e _c_a_r_d
          (refcard.ps): 4 pages, based on an earlier  version  by
          Joseph H. Silverman.

     _p_a_r_i_e_m_a_c_s._t_x_t
          explains the use of the pari.el  package,  and  how  to
          customize it (prompt, colors).


FFFFIIIILLLLEEEESSSS
     _g_p   main executable

     $_H_O_M_E/._g_p_r_c
          (or $GPRC if set) read at  beginning  of  execution  by
          each ggggpppp shell. A default gprc _g_p_r_c._d_f_t is provided with
          the  distribution.  If  this  file  cannot  be   found,
          /_e_t_c/_g_p_r_c is checked instead.

     _p_a_r_i._l_o_g
          default logfile (can be changed in  ._g_p_r_c  or  interac-
          tively using ddddeeeeffffaaaauuuulllltttt(((()))) )

     _p_a_r_i._p_s
          default psfile used for postscript output (as above)

     /_u_s_r/_l_o_c_a_l/_b_i_n/_g_p_h_e_l_p
          default external help program (as above)

     /_u_s_r/_l_o_c_a_l/_l_i_b/_p_a_r_i/_p_a_r_i._e_l
          elisp package to run pari in an _E_m_a_c_s  shell.  Must  be
          loaded from your ._e_m_a_c_s file.

     *._g_p gp programs


PPPPRRRRIIIIMMMMAAAARRRRYYYY FFFFTTTTPPPP SSSSIIIITTTTEEEE
     The most recent distributions can be found at
          _f_t_p://_m_e_g_r_e_z._m_a_t_h._u-_b_o_r_d_e_a_u_x._f_r/_p_u_b/_p_a_r_i

     Tips, development info, nice icons  and  bad  jokes  can  be
     found at PARI home page, set up by Gerhard Niklasch at
          _h_t_t_p://_w_w_w._p_a_r_i_g_p-_h_o_m_e._d_e/


MMMMAAAAIIIILLLLIIIINNNNGGGG LLLLIIIISSSSTTTTSSSS
     There are three mailing lists devoted to the PARI/GP package
     (run courtesy of Dan Bernstein), and most feedback should be
     directed to those. They are:





SunOS 5.5.1         Last change: 25 June 1999                   3






GP(1)                     User Commands                     GP(1)



     - ppppaaaarrrriiii----aaaannnnnnnnoooouuuunnnncccceeee (moderated): for us to announce  major  ver-
     sion changes.

     - ppppaaaarrrriiii----ddddeeeevvvv:::: for everything related  to  the  development  of
     PARI,   including   suggestions,  technical  questions,  bug
     reports or patch submissions.


     - ppppaaaarrrriiii----uuuusssseeeerrrrssss:::: for everything else.

     To subscribe, send empty messages respectively to


        pari-announce-subscribe@list.cr.yp.to

        pari-users-subscribe@list.cr.yp.to

        pari-dev-subscribe@list.cr.yp.to


BBBBUUUUGGGG RRRREEEEPPPPOOOORRRRTTTTSSSS
     If you find a bug, you should report it. But first make sure
     that  it  really  is a bug and that it appears in the latest
     version of ggggpppp that you have. Then you can actually mail your
     bug  report (make it short and easily reproducible if possi-
     ble), including the header ggggpppp displays on  startup,  to  the
     _p_a_r_i-_d_e_v   mailing  list  (preferably)  or  to  _p_a_r_i@_m_a_t_h._u-
     _b_o_r_d_e_a_u_x._f_r.  Fixes are welcome too !


TTTTRRRRIIIIVVVVIIIIAAAA
     Despite the leading G, GP has nothing to do  with  GNU.  The
     first version was originally called GPC, for Great Programm-
     able Calculator. For some reason, the trailing C was eventu-
     ally dropped.

     PARI has nothing to do with the French capital. The name  is
     a  pun  about  the  project's  early stages when the authors
     started to implement a library for  "Pascal  ARIthmetic"  in
     the  PASCAL  programming  language (they quickly switched to
     C).

     For the benefit of  non-native  French  speakers,  here's  a
     slightly  expanded  explanation:   BBBBllllaaaaiiiisssseeee PPPPaaaassssccccaaaallll (1623-1662)
     was a famous French mathematician and  philosopher  who  was
     one  of  the  founders of probability and devised one of the
     first "arithmetic machines". He once proposed the  following
     "proof" of the existence of God for the unbelievers: whether
     He exists or not I lose nothing by believing in Him, whereas
     if He does and I misbehave... This is the so-called "pari de
     Pascal" (Pascal's bet).




SunOS 5.5.1         Last change: 25 June 1999                   4






GP(1)                     User Commands                     GP(1)



     Note that PARI also means "fairy" in Persian.


AAAAUUUUTTTTHHHHOOOORRRRSSSS
     PARI was originally written by  Christian  Batut,  Dominique
     Bernardi, Henri Cohen, and Michel Olivier in Laboratoire A2X
     (Universite Bordeaux I, France), and was maintained by Henri
     Cohen  up  to  version  1.39.15,  and by Karim Belabas since
     then.

     A great number of people have contributed to the  successive
     improvements  which  eventually resulted in the present ver-
     sion. See the AUTHORS file in the distribution.


SSSSEEEEEEEE AAAALLLLSSSSOOOO
     _d_v_i_p_s(1),   _e_m_a_c_s(1),   _g_a_p(1),   _g_h_o_s_t_v_i_e_w(1),   _g_p_h_e_l_p(1),
     _m_a_p_l_e(1), _p_e_r_l(1), _r_e_a_d_l_i_n_e(3), _t_e_x(1), _x_d_v_i(_1)


CCCCOOOOPPPPYYYYIIIINNNNGGGG
     This program is  free  software;  you  can  redistribute  it
     and/or  modify  it under the terms of the GNU General Public
     License as published by the Free Software Foundation.

     This program is distributed in the hope that it will be use-
     ful, but WITHOUT ANY WARRANTY; without even the implied war-
     ranty of MERCHANTABILITY or FITNESS FOR  A  PARTICULAR  PUR-
     POSE.  See the GNU General Public License for more details.

     You should have received a copy of the  GNU  General  Public
     License  along  with this program; if not, write to the Free
     Software Foundation,  Inc.,  675  Mass  Ave,  Cambridge,  MA
     02139, USA.





















SunOS 5.5.1         Last change: 25 June 1999                   5



