unit AStringUtilityUnit;

// Utilities for TAString

interface

uses
  Classes,
  ACLString;

// Puts specified program command line parameter
// into AString
procedure AString_ParamStr( item: byte;
                            S: TAString );

// Splits up an AString at the given separator CHAR
// Puts the individual strings into List, truncating
// each string at 255 chars max.
procedure AStringToList( S: TAstring;
                         List: TStrings;
                         const Separator: char );

// Converts the given stringlist to an AString
// with the given separator between entries
procedure ListToAString( List: TStrings;
                         S: TAstring;
                         const Separator: char );

// Adds the given value to an AString containing
// a list with entries separated by separator
Procedure AddToListAString( S: TAString;
                            const NewValue: string;
                            const Separator: char );

implementation

uses
  ACLUtility;

procedure AString_ParamStr( item: byte;
                            S: TAString );
var
  p: pchar;
  l: longint;
begin
  GetCommandLineParameter( item, p, l );
  S.AssignPCharLen( p, l );
end;

procedure AStringToList( S: TAstring;
                         List: TStrings;
                         const Separator: char );
var
  Item: TAString;
  i: longint;
begin
  List.Clear;
  Item := TAString.Create;

  i := 0;
  while i < S.Length do
  begin
    S.ExtractNextValue( i, Item, Separator );
    List.Add( Item.AsString );
  end;

  Item.Destroy;
end;

Procedure AddToListAString( S: TAString;
                            const NewValue: string;
                            const Separator: char );
Begin
  if S.Length > 0 then
    S.AddString( Separator );
  S.AddString( NewValue );
End;

procedure ListToAString( List: TStrings;
                         S: TAstring;
                         const Separator: char );
Var
  i: longint;
Begin
  S.Clear;
  for i := 0 to List.Count - 1 do
    AddToListAString( S, List[ i ], Separator );
End;

end.