Unit HelpManagerUnit;

// Definitions affecting the interface with the new helpmgr.dll

Interface

uses
  PmWin;

const
  SharedMemSize = 4096;
  SharedMemReserveSize = 256;
  SharedMemBaseName = 'NEWVIEW_SHARED_MEM';

type
  TNewHelpMgrSharedStruct = record
    Title: array[ 0..31 ] of char;
    Version: array[ 0..31 ] of char;
  end;
  TPNewHelpMgrSharedStruct = ^TNewHelpMgrSharedStruct;

var
  // extract from shared memory once connected
  HelpManagerVersion: string;

const
  // External messages between helpmgr.dll and NewView
  WM_NEWHELPMGR            = WM_USER + 300;

  // sent by newview when startup is complete
  NHM_VIEWER_READY         = WM_NEWHELPMGR + 0;
    // Param1: viewer window handle

  NHM_HELP_CONTENTS        = WM_NEWHELPMGR + 1;

  NHM_HELP_INDEX           = WM_NEWHELPMGR + 2;

  NHM_TOPIC_BY_RESOURCE_ID = WM_NEWHELPMGR + 3;
    // Param1: resource id

  NHM_TEST                 = WM_NEWHELPMGR + 4;
    // Param1: ptr to text

  NHM_FORGET_VIEWER        = WM_NEWHELPMGR + 5;

  NHM_TOPIC_BY_PANEL_NAME  = WM_NEWHELPMGR + 6;
    // Param1: pointer to name in shared memory

Implementation

Initialization
End.
