#include <stdio.h>
#include <stdarg.h> 
#include <errno.h>
#include <string.h>
#include <stdlib.h>

#define INCL_DOSMISC
#include <os2.h>

char GetBootDrive()
{
  ULONG buffer;
  DosQuerySysInfo( QSV_BOOT_DRIVE, 
                   QSV_BOOT_DRIVE,
                   & buffer,
                   sizeof( buffer ) );
  return 'A' + buffer - 1;
}

void LogEvent( char* format, ... )
{
#ifdef DEBUG
  va_list ap;
  FILE* f;

  char ProfileFilename[ _MAX_PATH ];

  ProfileFilename[ 0 ] = GetBootDrive();
  strcpy( ProfileFilename + 1, ":\\hlpmgr2.log" );

  f = fopen( ProfileFilename, "a" );
  if ( f == NULL ) 
  {
    printf( "fopen failed, errno %d: %s", errno, strerror( errno ) );
    return;
  }
  
  va_start( ap, format );
  vfprintf( f, format, ap );
  fprintf( f, "\n" );
  fclose( f );
  va_end( ap );
#else
  ;
#endif
}
