#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define INCL_PM
#include <os2.h>

#include "Viewer.h"
#include "log.h"

char* pszViewerFilename = "view.exe";

// appends the given filenames to the output string,
// replace spaces between filenames with a +
// and stripping redundant spaces.
void ModifyFilenames( char* Filenames,
                      char* Output )
{
  BOOL First;
  BOOL InQuote;

  First = TRUE;
  InQuote = FALSE;
  while ( *Filenames != 0 )
  {
    // skip spaces
    while (    *Filenames != 0 
            && *Filenames == ' ' )
      Filenames ++;

    // add a plus sign (+), after first word
    if (    ! First
         && *Filenames != 0 )
    {
      * Output = '+';
      Output ++;
    }

    First = FALSE;
    // copy non-space characters    
    // or all characters if in quotes
    while (    *Filenames != 0 
            && ( *Filenames != ' ' || InQuote ) )
    {
      if ( *Filenames == '\'' )
        InQuote = ! InQuote;

      * Output = *Filenames;
      Output ++;
      Filenames ++;
    }
  }

  // null terminate
  *Output = 0;
}

void StartViewer( char* pszHelpFileName,
                  char* pszWindowTitle,
                  HWND hHelpWindow,
                  HWND hAppWindow )
{
  PROGDETAILS Details;
  char* pszParameters;
  char pszMessageCaption[ 1024 ];
  HAPP hApplication;

  pszParameters = (char*) malloc(   strlen( pszHelpFileName ) 
                                  + strlen( pszWindowTitle )
                                  + 512 );
  Details.Length                      = sizeof(PROGDETAILS);
  Details.progt.progc                 = PROG_PM;
  Details.progt.fbVisible             = SHE_VISIBLE;
  Details.pszTitle                    = "Help Viewer";
  Details.pszExecutable               = pszViewerFilename;
  Details.pszParameters               = pszParameters;
  Details.pszStartupDir               = "";
  Details.pszIcon                     = NULL; // default app icon
  Details.pszEnvironment              = NULL;
  Details.swpInitial.fl               = SWP_ACTIVATE;
  Details.swpInitial.cy               = 0;
  Details.swpInitial.cx               = 0;
  Details.swpInitial.y                = 0;
  Details.swpInitial.x                = 0;
  Details.swpInitial.hwndInsertBehind = HWND_TOP;
  Details.swpInitial.hwnd             = hAppWindow;
  Details.swpInitial.ulReserved1      = 0;
  Details.swpInitial.ulReserved2      = 0;

  // set up viewer parameters:
  // <helpfilename> /hm:<helpwindow> 
  // currently not used: /owner:<ownerwindow>

  sprintf( pszParameters,
           "/hm:%u ",
           hHelpWindow );

  if ( pszHelpFileName != NULL )
  {
    // add (modified) filenames to parameters
    ModifyFilenames( pszHelpFileName,
                     pszParameters + strlen( pszParameters ) );
  }

  if ( pszWindowTitle != NULL ) 
  {
    // add window title parameter
    strcat( pszParameters, " \"/title:" );
    strcat( pszParameters, pszWindowTitle );
    strcat( pszParameters, "\"" );
  }
  LogEvent( "Launching: %s %s",
            Details.pszExecutable,
            pszParameters );
             
  hApplication = 
    WinStartApp( hHelpWindow,         // window to be notified of termination
                 & Details,           // details
                 NULL,                // parameters - used Details
                 NULL,                // reserved
                 SAF_INSTALLEDCMDLINE ); // options

  if ( hApplication == NULL )
  {
    LogEvent( "  Failed to launch viewer" );  
    sprintf( pszMessageCaption,
             "Unable to start help viewer %s",
             pszViewerFilename );
    WinMessageBox( HWND_DESKTOP, // parent
                   hAppWindow,   // owner
                   pszMessageCaption,
                   "Help Error", // title
                   0,            // ID
                   MB_OK | MB_WARNING | MB_MOVEABLE );
  }    
  free( pszParameters );
}