Unit IPFFileFormatUnit;

// NewView - a new OS/2 Help Viewer
// Copyright 2001 Aaron Lawrence (aaronl at consultant dot com)
// This software is released under the Gnu Public License - see readme.txt

Interface

// Definition of IPF file header and other structures

uses
  DataTypes;

const
  INF_HEADER_ID = $5348;

Type
  THelpFileHeader = record
    ID: uint16;           // ID magic word (5348h = "HS")
    unknown1: uint8;      // unknown purpose, could be third letter of ID
    flags: uint8;         // probably a flag word...
                          //  bit 0: set if INF style file
                          //  bit 4: set if HLP style file
                          // patching this byte allows reading HLP files
                          // using the VIEW command, while help files
                          // seem to work with INF settings here as well.
    hdrsize: uint16;      // total size of header
    unknown2: uint16;     // unknown purpose

    ntoc: uint16;         // number of entries in the tocarray
    tocstart: uint32;     // file offset of the start of the toc
    toclen: uint32;       // number of bytes in file occupied by the toc
    tocoffsetsstart: uint32;     // file offset of the start of array of toc offsets
    nres: uint16;         // number of panels with ressource numbers
    resstart: uint32;     // 32 bit file offset of ressource number table
    nname: uint16;        // number of panels with textual name
    namestart: uint32;    // 32 bit file offset to panel name table
    nindex: uint16;       // number of index entries
    indexstart: uint32;   // 32 bit file offset to index table
    indexlen: uint32;     // size of index table
    unknown3: array[ 0..9 ] of uint8; // unknown purpose
    searchstart: uint32;  // 31 bit file offset of full text search table
                          // Note: top bit indicates 32 bit search record!
    searchlen: uint32;    // size of full text search table
    nslots: uint16;       // number of "slots"
    slotsstart: uint32;   // file offset of the slots array
    dictlen: uint32;      // number of bytes occupied by the "dictionary"
    ndict: uint16;        // number of entries in the dictionary
    dictstart: uint32;    // file offset of the start of the dictionary
    imgstart: uint32;     // file offset of image data
    unknown4: uint8;      // unknown purpose
    nlsstart: uint32;     // 32 bit file offset of NLS table
    nlslen: uint32;       // size of NLS table
    extstart: uint32;     // 32 bit file offset of extended data block
    reserved: array[ 0..2 ] of uint32; // for future use. set to zero.
    title: array[ 0..47 ] of char;    // ASCII title of database
  end;
  TPHelpFileHeader = ^ THelpFileHeader;

  TExtendedHelpFileHeader = record
    NumFontEntry: uint16;             // FONT TABLE:   Number entries
    FontTableOffset: uint32;          // FONT TABLE:   Offset in file
    NumDataBase: uint16;              // DATA BASE:    Number of files
    DataBaseOffset: uint32;           // DATA BASE:    Offset in file
    DataBaseSize: uint32;             // DATA BASE:    Size in bytes
    EntryInGNameTable: uint16;        // GLOBAL NAMES: Number entries
    HelpPanelGNameTblOffset: uint32;  // GLOBAL NAMES: Offset in file
    StringsOffset: uint32;            // STRINGS : Offset in file
    StringsSize: uint16;              // STRINGS : Total bytes of all strings
    ChildPagesOffset: uint32;         // CHILDPAGES : Offset in file
    ChildPagesSize: uint32;           // CHILDPAGES : Total bytes of all strings
    NumGIndexEntry: uint32;           // Total number of Global Index items
    CtrlOffset: uint32;               // CTRL BUTTONS : offset in file
    CtrlSize: uint32;                 // CTRL BUTTONS : size in bytes
    Reserved: array[0..3] of uint32;  // For future use. Set to zero
  end;
  TPExtendedHelpFileHeader = ^ TExtendedHelpFileHeader;

Type
  TTOCEntryStart = record
    length: uint8; // length of the entry including this byte
    flags: uint8; // flag byte, description folows (MSB first)
             // bit1 haschildren;  // following nodes are a higher level
             // bit1 hidden;       // this entry doesn't appear in VIEW.EXE's
                                   // presentation of the toc
             // bit1 extended;     // extended entry format
             // bit1 stuff;        // ??
             // int4 level;        // nesting level
    numSlots: uint8; // number of "slots" occupied by the text for
                                // this toc entry
  end;
  pTTOCEntryStart = ^TTOCEntryStart;

  TExtendedTOCEntry = record
    w1: uint8;
    w2: uint8;
  end;
  pExtendedTOCEntry = ^TExtendedTOCEntry;

  TTOCEntryOffsetArray =  array[ 0..0 ] of uint32;
  pTTOCEntryOffsetArray = ^ TTOCEntryOffsetArray;

Const
  TOCEntryExtended = 32;
  TOCEntryHidden = 64;
  TOCEntryHasChildren = 128;

type
  THelpXYPair = record
    Flags: uint8;
    X: uint16;
    Y: uint16;
  end;
  pHelpXYPair = ^ THelpXYPair;

  TSlotHeader = record
    stuff: uint8; // always 0??
    localdictpos: uint32; // file offset of the local dictionary
    nlocaldict: uint8; // number of entries in the local dict
    ntext: uint16; // number of bytes in the text
  end;
  pSlotHeader = ^TSlotHeader;

  THelpFontSpec = record
    FaceName: array[ 0..32 ] of char;
    Height: uint16;
    Width: uint16;
    Codepage: uint16;
  end;
  pTHelpFontSpec = ^ THelpFontSpec;

// List of IPF escape codes. Not complete! Many are just used
// as magic numbers in HelpTopic.pas

const
  // Basic byte codes
  IPF_END_PARA = $fa;
  IPF_CENTER = $fb;
  IPF_INVERT_SPACING = $fc;
  IPF_LINEBREAK = $fd;
  IPF_SPACE = $fe;
  IPF_ESC = $ff;

  // FF XX
  ecSetLeftMargin = $02;
  ecHighlight1 = $04; // hp1,2,3,5,6,7
  ecLinkStart = $05;
  ecFootnoteLinkStart = $07;
  ecLinkEnd = $08;
  ecStartCharGraphics = $0b;
  ecEndCharGraphics = $0c;
  ecHighlight2 = $0d; // hp4,8,9
  ecImage = $0e;
  ecLinkedImage = $0f;
  ecSetLeftMarginNewLine = $11;
  ecSetLeftMarginFit = $12;
  ecForegroundColor = $13;
  ecBackgroundColor = $14;
  ecFontChange = $19;
  ecStartLines = $1a;
  ecEndLines = $1b;
  ecStartLinkByResourceID = $1d;
  ecExternalLink = $1f;

  // Subescape codes of
  HPART_DEFINE = 0;
  HPART_PT_HDREF = 1;
  HPART_PT_FNREF = 2;
  HPART_PT_SPREF = 3;
  HPART_HDREF = 4;
  HPART_FNREF = 5;
  HPART_SPREF = 6;
  HPART_LAUNCH = 7;
  HPART_PT_LAUNCH = 8;
  HPART_INFORM = 9;
  HPART_PT_INFORM = 10;
  // ?? 11 ??
  HPART_EXTERN_PT_HDREF = 12;
  HPART_EXTERN_PT_SPREF = 13;
  HPART_EXTERN_HDREF = 14;
  HPART_EXTERN_SPREF = 15;
  HPART_GLOBAL_HDREF = 16;
  HPART_GLOBAL_PT_HDREF = 17;


Implementation

Initialization
End.
