Unit InformationFormUnit;

Interface

Uses
  Classes, Forms, Graphics, StdCtrls, Buttons,
  ACLLanguageUnit;

Type
  TInformationForm = Class (TForm)
    InformationMemo: TMemo;
    OKButton: TButton;
    Procedure InformationFormOnShow (Sender: TObject);
    Procedure InformationFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    FText: pchar; // for messages with long lines
    Procedure OnLanguageEvent( Language: TLanguageFile;
                               const Apply: boolean );
  End;

Var
  InformationForm: TInformationForm;

Implementation

Procedure TInformationForm.InformationFormOnShow (Sender: TObject);
Begin
  if FText <> nil then
    InformationMemo.Lines.SetText( FText );
  FText := nil;
End;

Procedure TInformationForm.InformationFormOnCreate (Sender: TObject);
Begin
  RegisterForLanguages( OnLanguageEvent );

  InformationMemo.XStretch := xsFrame;
  InformationMemo.YStretch := ysFrame;
  OKButton.XAlign := xaRight;
End;

Procedure TInformationForm.OnLanguageEvent( Language: TLanguageFile;
                                            const Apply: boolean );
begin
  Language.LoadComponentLanguage( self, Apply );
end;

Initialization
  RegisterClasses ([TInformationForm, TMemo, TButton]);
End.
