Unit MemoryFormUnit;

Interface

Uses
  Classes, Forms, Graphics, StdCtrls, Buttons;

Type
  TMemoryForm = Class (TForm)
    Memo1: TMemo;
    Button1: TButton;
    Button2: TButton;
    Procedure Button2OnClick (Sender: TObject);
    Procedure MemoryFormOnCreate (Sender: TObject);
    Procedure Button1OnClick (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  MemoryForm: TMemoryForm;

Implementation

uses
  SysUtils;

var
  MemStart: longword;
  MemLast: longword;

Procedure TMemoryForm.Button2OnClick (Sender: TObject);
Begin
  MemStart := MemAvail;
  MemLast := MemAvail;
End;

Procedure TMemoryForm.MemoryFormOnCreate (Sender: TObject);
Begin
  Button1.YAlign := yaTop;
  Button2.YAlign := yaTop;
  Memo1.XStretch := xsFrame;
  Memo1.YStretch := ysFrame;
  Button2OnClick( self );
End;

Procedure TMemoryForm.Button1OnClick (Sender: TObject);
Begin
  Memo1.Lines.Add( Format( '%10d', [ MemStart - MemAvail ] )
                   + ' '
                   + Format( '%10d', [ MemLast - MemAvail ] ) );
  MemLast := MemAvail;
End;

Initialization
  RegisterClasses ([TMemoryForm, TMemo, TButton]);
End.
