Unit PrintDialogUnit;

Interface

Uses
  Classes, Forms, Graphics, Buttons, ExtCtrls, StdCtrls,
  ACLLanguageUnit;

Type
  TPrintSelection =
  (
    ptCurrentTopic,
    ptVisibleTopics,
    ptAllTopics
  );

  TNewViewPrintDialog = Class (TForm)
    PrinterComboBox: TComboBox;
    PrinterLabel: TLabel;
    OKButton: TButton;
    SetupPrinterButton: TButton;
    CancelButton: TButton;
    Procedure NewViewPrintDialogOnCreate (Sender: TObject);
    Procedure PrinterComboBoxOnItemSelect (Sender: TObject; Index: LongInt);
    Procedure SetupPrinterButtonOnClick (Sender: TObject);
    Procedure PrintDialogOnShow (Sender: TObject);
  Public
  Protected
    Procedure OnLanguageEvent( Language: TLanguageFile;
                               const Apply: boolean );

    SetupPrinterErrorTitle: string;
    SetupPrinterError: string;
  End;

Var
  NewViewPrintDialog: TNewViewPrintDialog;

Implementation

uses
  SysUtils,
  Dialogs, Printers,
  ACLDialogs;

Procedure TNewViewPrintDialog.NewViewPrintDialogOnCreate (Sender: TObject);
Begin
  RegisterForLanguages( OnLanguageEvent );
End;

Procedure TNewViewPrintDialog.OnLanguageEvent( Language: TLanguageFile;
                                               const Apply: boolean );
begin
  Language.LoadComponentLanguage( self, Apply );

  Language.LL( Apply, SetupPrinterErrorTitle, 'SetupPrinterErrorTitle', 'Setup Printer' );
  Language.LL( Apply, SetupPrinterError, 'SetupPrinterError', 'Error displaying printer options: ' );
end;

Procedure TNewViewPrintDialog.PrinterComboBoxOnItemSelect (Sender: TObject;
  Index: LongInt);
Begin
  Printer.PrinterIndex := PrinterComboBox.ItemIndex;
End;

Procedure TNewViewPrintDialog.SetupPrinterButtonOnClick (Sender: TObject);
Begin
  try
    Printer.OptionsDlg;
  except
    on E: Exception do
    begin
      DoErrorDlg( SetupPrinterErrorTitle,
                  SetupPrinterError + E.Message );
    end;
  end;
End;

Procedure TNewViewPrintDialog.PrintDialogOnShow (Sender: TObject);
Begin
  PrinterComboBox.Items.Assign( Printer.Printers );
  PrinterComboBox.ItemIndex := Printer.PrinterIndex;
End;

Initialization
  RegisterClasses ([TNewViewPrintDialog, TComboBox, TLabel, TButton]);
End.
