Unit ProductInformationFormUnit;

// NewView - a new OS/2 Help Viewer
// Copyright 2001 Aaron Lawrence (aaronl at consultant dot com)
// This software is released under the Gnu Public License - see readme.txt

Interface

Uses
  Classes, Forms, Graphics, Buttons, StdCtrls, Gradient, ExtCtrls,
  ACLLanguageUnit;

Type
  TProductInformationForm = Class (TForm)
    Image1: TImage;
    OKButton: TButton;
    VersionEdit: TEdit;
    WebPageEdit: TEdit;
    CopyrightEdit: TEdit;
    CopyURLButton: TButton;
    Procedure CopyURLButtonOnClick (Sender: TObject);
    Procedure AboutBoxOnCreate (Sender: TObject);
  Private
    MouseMoved: boolean;
  Public
    Procedure OnLanguageEvent( Language: TLanguageFile;
                               const Apply: boolean );
    VersionMsg: string;
    CopyrightMsg: string;
  End;

Var
  ProductInformationForm: TProductInformationForm;

procedure EnsureProductInformationFormLoaded;

Implementation

uses
  PMSHL, OS2Def,
  Dos, SysUtils,
  ACLStringUtility,
  RichTextDocumentUnit, RichTextStyleUnit,
  VersionUnit,
  Dialogs;

Procedure TProductInformationForm.OnLanguageEvent( Language: TLanguageFile;
                                                   const Apply: boolean );
begin
  Language.LoadComponentLanguage( self, Apply );

  Language.LL( Apply, VersionMsg, 'VersionMsg', 'Version: ' );
  Language.LL( Apply, CopyrightMsg, 'CopyrightMsg', 'Copyright' );
end;

Procedure TProductInformationForm.CopyURLButtonOnClick (Sender: TObject);
Begin
  if Clipboard.Open( Handle ) then
  begin
    Clipboard.Empty;
    Clipboard.AsText := 'http://' + WebPageEdit.Text;
    Clipboard.Close;
  end;
End;

Procedure TProductInformationForm.AboutBoxOnCreate (Sender: TObject);
Begin
  RegisterForLanguages( OnLanguageEvent );

  VersionEdit.Text := VersionMsg + GetAppVersion + ' ';
  CopyrightEdit.Text := CopyrightMsg + ' 1999, 2003 Aaron Lawrence';
End;

procedure EnsureProductInformationFormLoaded;
begin
  if ProductInformationForm = nil then
    ProductInformationForm := TProductInformationForm.Create( nil );
end;

Initialization
  RegisterClasses ([TProductInformationForm, TImage, TButton,
    TEdit]);
  RegisterUpdateProcForLanguages( EnsureProductInformationFormLoaded );
End.
