Unit VersionUnit;

// NewView - a new OS/2 Help Viewer
// Copyright 2001 Aaron Lawrence (aaronl at consultant dot com)
// This software is released under the Gnu Public License - see readme.txt

Interface

// This file contains the version number and history.

function GetAppVersion: string;

Implementation

const
  Version =        'V2.4.30'; // $SS_REQUIRE_NEW_VERSION$
  BldLevelVersion = '2.4.30'; // Embedded for IBM BLDLEVEL tool

// RELEASE PROCESS
// - Record library versions
// - DISABLE PROFILE
// - TURN OFF DEBUG INFO
// - Package: distr NewViewX_Y_Z
// - Upload to Hobbes
// - Test download
// - Update webpage: index, NewView news, history, download
// - Notify eCS apps NG, OS/2 Apps NG
// 
// RTL: V2.0.3.13
// SPCC: V2.1.8.7
// Addon: V2.0.4
// Library: V1.4.6
// Components: V1.8.18
// HelpMgr: V1.5.6

{
Bugs
Bigger stuff:
- DBCS: cursor, find
- Viewdoc - reuse windows
- Run old view/hmgr
- Keyboard navigation of links/search results

- RTV: if it wraps during a word that has tags within it,
  then the tags may not be applied at the correct point.
  ... need to remember the style at start of word as well.
- RTV: should not lose cursor if just resizing
  only if text changed
- Univers- font not listed properly
- Bitmaps in 256 colors only???
- List indentions do not work with non-system fonts like "Times New Roman". But "Tms Rmn" works (MartinV)
- Exclusions - pass thru for helpmgr
- parse LANG to ignore bits AFTER LL_CC   ll=language cc=country e.g. DE_DE_EURO

- standalone install - A *.HLP and *.INF file association

- Cut/Copy/Paste From/to the BMP filename textbox in Settings.
- (Example, added later. Discovered answering something below: impossible to drag, or at least cut and copy, text from Search to Global Search boxes)

- FIle dialog - filelist cannot be tabbed to

- MauriceSearchCrash.log

- Problem pressing F1 in PMNews

- Maul Publisher - crash
  BMPHAND.INF - Might be fixed with fixes to loading
  Reconfirm...

- 3. While in MR/2 (news and mail reader, I just F1'd (twice) and got
the following: Newview was found hanging both times, in watchcat, very
politely I should say, and was easily dispatched.

- Describe - immediate crash of newview
  Reproducible (?) in Sibyl, [crash logs similar]

  after 1st help call, it crashes
 Somehow, we're getting
  into TControl.WndProc for a control that isn't a SIbyl control.
   Does not seem to require mouse movement - was able to cause 3 times in a
   row by being on a word in sibyl, pressing ctrl F1. Pointer was over title
   bar once newview launched.
   Happened again...
   Have removed the "lastwnd -> lastcontrol" optimisation in Forms - SubclassedWndProc
   - did not help

   Have added check in the TControl.WMChar to see that the window is owned by us.
   - did not helP!

   It's actually trying to get the parent class.. What's a parent class?

   Appears to be keyup event - wc_keyup
   Removing this "solves" the problem

  Logging in place - AARONS_DEBUG must be enabled.


- Crash log from global search dialog...

- the helpmgr replacement makes openchat fail openchat is a IRC program
  which can be found at hobbes
  It is using Helpmgr ordinal 37, HMSETHELPDATABASE, which is undocumented

- problem if closed before startup complete(?)
  or another one started...

NewView crash log
App Version: V2.2.25
Components Version: v1.7.33
Library Version: V1.3.1
  No match
Running as process: C:\OS2\VIEW.EXE
20 March 2003, 00:11:26
Exception type: EGPFault
Description: Access violation exception (EGPFault) occured
at CS:EIP  =$0000005B:$0003D18D
Location: $0003D18D
Callstack:
 $0003D18D  FORMS.PAS 16955
 $000E8615  MAINFORM.PAS 3115
 $000E85E6  MAINFORM.PAS 651
 $000F48DA  MAINFORM.PAS 4928
 $00018937  SYSTEM.PAS 10151
 $0003432F  FORMS.PAS 17810
 $0003424F  FORMS.PAS 6117
 $1E93D5D8  No match
 $1E938D87  No match
Loaded files (16651728):
Top-level open windows: 0
System version:20.45.0
  OS/2 4.5
RAM: 255 MB
Boot drive: C
Video resolution: 1152x864
Color depth: 32 bits
Video driver: GRADD: SDDGRADD
---- End of report ----

- [eCS compat] move ini file to appropriate place. (see AE)
- Alessandro: it makes EPM hang when I use keyword help
- Alessandro: unlike VIEW.EXE if I call it from EPM or from a command
    line window (e.g. HELP FORMAT) it creates each time a new
    window. This is a serious problem expecially when using it
    from EPM.
    Besides that you should avoid to mark the keyword in such
    cases (i.e. when the program is called via HELP or via EPM).
    The solution to the multiple windows problem might be to run
    NEWVIEW via a server program.
    The server program starts newview via WinStartApp storing:
    -1) handle of newview instance (HAPP returned by WinStartApp)
    -2) handle of newview window (I can send you a code snippet
        to get hwnd from happ)
    -3) inf file name
    each time an INF file has to be opened the server will check
    first in its list of opened instances, if the INF file is
    already opened, if there is a keyword parameter it store that
    into shared memory and sends a message to the already opened
    instance 

New Features
- Global bookmarks

- Remember own help size/position separately from main window
  Or just revise window positioning... shell-style cascade

- Hint (popup tooltip) for links

- Remember size/position of footnote windows

- Highlight words ideally needs to cater for multi-part search terms
  - use the current search query

- popup tooltips for toolbar
- Select/copy and save support, for images.
- Case sensitive search
- Whole word only match

- Drop file onto window
- drop file onto toolbar/toolbar image file edit

- Highlight Search Words does not work if searched with All Help Files!

- Reduce multiple repaints of first topic.

- Distribute default toolbar background.

- Associate with .INF, .IPF

- Turn off left-panel
- Optimise to not load contents tree/index if not visible...?
- Cache final index?
- Run WinHelp if format is WinHelp
  Also detect Win95 help?
- Find first match within topic when topic opened from search results
  (which window tho...)
- sort top level contents, would be nice
- Cross file and program links
  VAC++ Language Ref (cpplng)
    Preprocessor Directives/Predefined Macro Names
    Items in related information. FF 1F esc code.
  Esc Decoding is done, but not the linking itself.

- Linked images
    e.g. Export.hlp
- Page history remember file 1/2 day
- Display BOOKSHELF and HELP variables
- Show all found help files...
- Make global search an option on the search panel?
- Toolbar button for global search
- P'raps Esc should shift focus back to contents.
- Footnote window titles
- Tools - Mark Start Topic
- Fix tabbing so it goes to the appropriate window
- Make navigation back and forth
  detect differences in windows and make minimum changes 1/2 day
  zorder
- Better handling of windows
  - problem with CPPUG toc pane
  - leaving windows smaller than screen...
- Codepage support
- Detect version change for links
  (is text at insert point same as before?)

Sibyl bugs
- delete/close in tasklist sends close to mainwindow!
- extended multi-select listbox does not fire OnItemFocus
  in half the cases of dragging a selection. This is because
  TListBox.GetSelectItem is wrong and returns -1 for those cases.
  I'm not sure that there is any right way.
  WM_QUERYSELECTION wit LIT_CURSOR does not seem to work.
- Pick up window font from system?

Blue sky
- Option for wildcard searching
- Multi-topic printing
- Search for phrases
- All-directories global search option
  (not just HELP+BOOKSHELF)
- Make links from http:// ftp:// mailo:// news://
- I18N/Translations
- Export whole file 1 day?
- Show History ?
    Same problems with multiwindow...
- Turn tabs on/off
}

function GetAppVersion: string;
begin
  Result:= Version;
end;

const
  Vendor = 'Aaron Lawrence';
  Description = 'NewView';

  // BLDLevel - compatible - mostly
  EmbeddedVersion: string =
      '@#'
    + Vendor
    + ':'
    + BldLevelVersion
    + '#@'
    + Description
    + #0;

Initialization
End.
