/* Unsupported, collects historical Euronext quote data including "corrections" */

NUMERIC DIGITS 18

CALL RxFuncAdd 'SysFileDelete','RexxUtil','SysFileDelete'
CALL RxFuncAdd 'SysSleep','RexxUtil','SysSleep'

PARSE ARG sym datum1 datum2
sym=Strip(Translate(sym))
IF Left(sym,1)='/' | Left(sym,1)='-' THEN DO
   SAY
   SAY 'Usage: HISTDATA.CMD <SYMBOL> <YYYYMMDD> [<YYYYMMDD>]'
   SAY
   SAY '   Examples:'
   SAY
   SAY '      HISTDATA.CMD'
   SAY '      HISTDATA.CMD /?'
   SAY '      HISTDATA.CMD AEX 20171229'
   SAY '      HISTDATA.CMD CACMD 20171229 20181003'
   SAY
   SAY 'WGET.EXE is required, which may overwrite an existing file.'
   SAY
   SAY 'The sorted text file "AANDELEN.LST" (SHARES.LST) example contains all' 
   SAY 'required data. The text file may be outdated quite soon. Its relevant' 
   SAY 'file format is at the moment:'
   SAY
   SAY 'Pos.  1-10  Euronext symbol'   
   SAY 'Pos. 31-45  ISIN code'
   SAY 'Pos. 56-60  Market (excluding Ireland XAMS, XBRU, XLIS or XPAR)'
   SAY
   EXIT
END
IF sym='' THEN DO
   SAY
   CALL CharOut '','Which Euronext symbol/ticker? '
   PARSE PULL sym
   datum2=''
   sym=Strip(Translate(sym))
   IF sym='' THEN EXIT
END
IF datum2='' THEN datum2=datum1 
IF datum1='' THEN DO
   SAY
   CALL CharOut '','Which date or date range (YYYYMMDD [YYYYMMDD])? '
   PARSE PULL datum1 datum2
END
IF datum2='' THEN datum2=datum1 
datum1=Strip(datum1)
datum2=Strip(datum2)
IF Length(datum1)<>8 THEN EXIT
IF Length(datum2)<>8 THEN EXIT
IF DataType(datum1,'W')=0 THEN EXIT
IF DataType(datum2,'W')=0 THEN EXIT
IF datum2>=Date('S') THEN EXIT
IF datum2<datum1 THEN EXIT
SAY

bron='AANDELEN.LST'
teller=0
DO WHILE Lines(bron)>0
   regel=Strip(LineIn(bron))
   PARSE VAR regel 1 symbool 11 . 31 isin 46 . 56 markt 61 .
   IF Strip(symbool)==sym THEN DO
      teller=teller+1
      symbool.teller=Strip(symbool)
      isin.teller=Strip(isin)
      markt.teller=Strip(markt)
   END
END
CALL LineOut bron
isin.0=teller

SAY

from=(Date('B',datum1,'S')-719162)*86400000
to=(Date('B',datum2,'S')-719162)*86400000

browser='--user-agent="Mozilla/5.0 (OS/2; U; OS/2 4.50; nl-NL; rv:14.093)"'
delay=1
DO i=1 TO isin.0
   url='https://www.euronext.com/nyx_eu_listings/price_chart/download_'
   url=url||'historical?typefile=csv&layout=vertical&typedate=dmy&separator=com'
   url=url||'ma&mic='||markt.i||'&'||'isin='||isin.i||'&namefile=Price_Data_His'
   url=url||'torical&from='||from||'&to='||to||'&adjusted=1&base=0'
   SAY url
   SAY
   url='"'||url||'"'
   '@START "'||symbool.i||'" /C /B /WIN /MIN WGET.EXE -q --no-check-certificate --timeout=10 --tries=10 --waitretry=10 -O'||symbool.i browser url
END i
CALL SysSleep 3

SAY
CALL CharOut '','Press <ENTER> when all files are downloaded...'
PARSE PULL klaar
SAY
IF klaar<>'' THEN DO
   DO i=1 TO isin.0
      IF Stream(isin.i,'C','QUERY EXISTS')<>'' THEN CALL SysFileDelete isin.i
   END i
   EXIT
END

klaar=0
DO i=1 TO isin.0
   IF stream(symbool.i,'C','QUERY EXISTS')<>'' THEN DO
      IF stream(symbool.i,'C','QUERY SIZE')=0 THEN DO
	 klaar=klaar+1
	 SAY 'Retry:' symbool.i
	 url='"https://www.euronext.com/nyx_eu_listings/price_chart/download_'
	 url=url||'historical?typefile=csv&layout=vertical&typedate=dmy&separator=com'
	 url=url||'ma&mic='||markt.i||'&'||'isin='||isin.i||'&namefile=Price_Data_Hist'
	 url=url||'orical&from='||from||'&to='||to||'&adjusted=1&base=0"'
	 '@START "'||symbool.i||'" /C /B /WIN /MIN WGET.EXE -q --no-check-certificate --timeout=10 --tries=10 --waitretry=10 -O'||symbool.i browser url
      END
   END   
END i
IF klaar>0 THEN DO
   CALL SysSleep 6
   SAY
   CALL CharOut '','Press <ENTER> when all files are downloaded...'
   PARSE PULL klaar2
   SAY
   IF klaar2<>'' THEN DO
      DO i=1 TO isin.0
	 IF Stream(symbool.i,'C','QUERY EXISTS')<>'' THEN CALL SysFileDelete symbool.i
      END i
      EXIT
   END
END

klaar=0
DO i=1 TO isin.0
   IF stream(symbool.i,'C','QUERY EXISTS')<>'' THEN DO
      IF stream(symbool.i,'C','QUERY SIZE')=0 THEN DO
	 klaar=klaar+1
	 SAY 'Retry:' symbool.i
	 url='"https://www.euronext.com/nyx_eu_listings/price_chart/download_'
	 url=url||'historical?typefile=csv&layout=vertical&typedate=dmy&separator=com'
	 url=url||'ma&mic='||markt.i||'&'||'isin='||isin.i||'&namefile=Price_Data_Hist'
	 url=url||'orical&from='||from||'&to='||to||'&adjusted=1&base=0"'
	 '@START "'||symbool.i||'" /C /B /WIN /MIN WGET.EXE -q --no-check-certificate --timeout=10 --tries=10 --waitretry=10 -O'||symbool.i browser url
      END
   END   
END i
IF klaar>0 THEN DO
   CALL SysSleep 6
   SAY
   CALL CharOut '','Press <ENTER> when all files are downloaded...'
   PARSE PULL klaar2
   SAY
   IF klaar2<>'' THEN DO
      DO i=1 TO isin.0
	 IF Stream(symbool.i,'C','QUERY EXISTS')<>'' THEN CALL SysFileDelete symbool.i
      END i
      EXIT
   END
END

IF Stream(sym,'C','QUERY EXISTS')<>'' THEN SAY 'File downloaded:' sym

EXIT

