/* ************************************************************ */
/* Time Series Analyzer Macro File                              */
/*                                                              */
/* Created by    :    Wolfgang Reichenbach                      */
/* Creation Date :    05.03.96                                  */
/* Last updated  :    25.03.96                                  */
/* copyright by  :    Wolfgang Reichenbach 1996                 */
/*                                                              */
/* ************************************************************ */
/*                                                              */
/* This file loads the time series 'E:\NLD\2K\lorenz.ts.nld'    */
/* and calculates only the autocorrelation. After this the      */
/* length and the dimension of the time series is displayed.    */
/*                                                              */
/* ************************************************************ */
/*                                                              */
/* Used System REXX/2 functions                                 */
/*                                                              */
/*             1)  Say                                          */
/*             2)  Exit                                         */
/*                                                              */
/* Used internal functions                                      */
/*                                                              */
/*    1)  LoadTs              - Loading a time series           */
/*    2)  CalcAutocorrelation - Calculate the autocorrelation   */
/*    3)  GetTsLength         - Get the length of time series   */
/*    4)  GetTsDim            - Get dimension of time series    */
/* ************************************************************ */

VisualMode ON

SAY '******************************************'
SAY '*   Time Series Analyzer REXX programm   *'
SAY '******************************************'

SAY 'Loading Time Series'
rc = LOADTS("E:\math\NLD\2K\lorenz.ts.nld")
/*if rc <> 0 then exit*/
Say 'loaded'

SAY 'Die Autocorrelationsfunktion wird berechnet'
rc = CalcAutocorrelation()


SAY 'Header auslesen'
Size = GetTsLength()
dim  = GetTsDim()

SAY 'Dimension = ' dim
SAY 'Lnge     = ' Size

exit
