/* list0906.cmd */

PARSE ARG file

IF file = '' | file = '/?' | file = '-?' THEN
  DO
  SAY "Use the BAK command to create a .BAK version of a file."
  SAY
  SAY "SYNTAX:  BAK [drive:][path]filename"
  SAY
  SAY "Where:"
  SAY "  [drive:][path]filename Specifies the file to copy to"
  SAY "                         a .BAK file."
  EXIT
  END

IF Left(file, 1) = '"' THEN
  PARSE VAR file '"' file '"'

backFile = Reverse(file)
IF Pos('.', backFile) <= 4 THEN
  PARSE VAR backFile extension '.' backFile

backFile = Reverse(backFile) || '.bak'

IF Translate(file) = Translate(backFile) THEN
  DO
  SAY 'File already has a .BAK extension.'
  EXIT
  END

'@copy' '"'file'"' '"'backFile'"' '> NUL'

IF rc >< 0 THEN
  SAY "Error making backup file."

EXIT
