//
// scan_def.c
// 22-Apr-97
// (C)1997 Cornel Huth - http://www.40th.com
//
// reads .h file grabbing all #define lines and sorting those by number and ID(name)
// primarily intended to deal with auto-ID generators that don't really do a good
// job of helping you prevent duplicate IDs/numbers from begin generated, such as
// can easily happen when you duplicate/copy controls in a design
//
// 3-Jun-97 (chh)
// added * display on duplicate ID lines and number lines
// added -dups switch to show only duplicates

#define INCL_BASE
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_DEFINE_LINES 9999           // max #define lines accepted
#define MAX_LINE_LEN 260                // max length of any line read from disk
#define MAX_ID_LEN 50                   // max size of ID name part of #define
#define MAX_NUM_LEN 12                  // max size of "number" part of #define
#define MAX_BUFFER_LEN (MAX_ID_LEN+1+MAX_NUM_LEN+1) // qsort element size
#define FMT_STR "%12.12s %s"            // size should match MAX_NUM_LEN

#define MATCH_STR "#define"
#define MATCH_LEN sizeof(MATCH_STR)

int compareNum(VOID *arg1, VOID *arg2) {
   return stricmp(arg1, arg2);
}

int compareID(VOID *arg1, VOID *arg2) {
   return stricmp( (PVOID)((ULONG)arg1+MAX_NUM_LEN+1), (PVOID)((ULONG)arg2+MAX_NUM_LEN+1));
}

int main(int argc, const char *argv[]) {

 FILE *file;

 CHAR fName[260];
 CHAR lineBuffer[MAX_LINE_LEN];
 CHAR tID[MAX_LINE_LEN];        // in case tID/tNum larger than what is wanted
 CHAR tNum[MAX_LINE_LEN];
 CHAR tIDlast[MAX_LINE_LEN];
 CHAR tNumLast[MAX_LINE_LEN];
 CHAR *sortBuffer=NULL;
 CHAR *sbPtr=NULL;
 CHAR *tPos;
 int lineNo=0;
 int defNo=0;
 int i;
 int dupsOnly = 0;

 printf("scan_def 1.1  Copyright (C)1997 Cornel Huth  http://www.40th.com/\n");

 if (argc < 2) {
    printf("\n\tUse [G:\\]scan_def [-dups] filename.h [ > file.lst]\n");
    return 1;
 }

 fName[0] = 0;
 for (i=1; i < argc; i++) {

    if (*argv[i] == '-') {
       if (strlen(argv[i]) >= 5) {
          if (stricmp(argv[i],"-dups")==0) dupsOnly = 1;
       }
       continue;
    }
    strcpy(fName,argv[i]);
 }

 file = fopen(fName,"rt");
 if (file==NULL) {
    printf("Cannot open %s\n",fName);
    return 1;
 }

 sortBuffer = malloc(MAX_BUFFER_LEN*MAX_DEFINE_LINES);
 if (sortBuffer==NULL) {
    printf("Cannot allocate sortBuffer\n");
    return 1;
 }
 sbPtr = sortBuffer;

 printf("\nfile: %s  ",fName);
 if (dupsOnly) printf("(duplicate entries only)");
 printf("\n");


 if (dupsOnly == 0) printf("Unsorted ======================================\n\n");

 fgets(lineBuffer,sizeof(lineBuffer),file);    // read a line
 while (!feof(file)) {
    lineNo++;

    // load only #define's (even in comments, #ifdef 0, whatever)

    if (tPos=strstr(lineBuffer,MATCH_STR)) {

       defNo++;
       if (defNo > MAX_DEFINE_LINES) {
          printf("Exceed %d #define lines\n",MAX_DEFINE_LINES);
          break;
       }

       sscanf((tPos+MATCH_LEN),"%s %s",tID,tNum);

       // truncate ID/Num if size exceeds program's allocations

       if ( strlen(tID) >= MAX_ID_LEN) tID[MAX_ID_LEN] = 0;
       if ( strlen(tNum) >= MAX_NUM_LEN) tNum[MAX_NUM_LEN] = 0;

       sprintf(sbPtr,FMT_STR,tNum,tID);
       if (dupsOnly == 0) printf("%4.4d %s\n",defNo,sbPtr);
       sbPtr = (CHAR*) ((ULONG)sbPtr + MAX_BUFFER_LEN);
    }

    fgets(lineBuffer,sizeof(lineBuffer),file);  // read another line
 }

 // sort by number and display

 printf("\n\nSorted by Number ==============================\n\n");
 qsort(sortBuffer,defNo,MAX_BUFFER_LEN,compareNum);
 sbPtr = sortBuffer;

 tNumLast[0] = 0;

 for (i=0; i < defNo; i++) {
    if (strnicmp(sbPtr,tNumLast,MAX_NUM_LEN)==0) {
       printf("%4.4d *%s\n",i+1,sbPtr);
    }
    else {
       if (dupsOnly == 0) printf("%4.4d  %s\n",i+1,sbPtr);
    }
    strncpy(tNumLast,sbPtr,MAX_NUM_LEN);
    sbPtr = (CHAR*) ((ULONG)sbPtr + MAX_BUFFER_LEN);
 }

 // sort by ID name and display

 printf("\n\nSorted by ID ==================================\n\n");
 qsort(sortBuffer,defNo,MAX_BUFFER_LEN,compareID);
 sbPtr = sortBuffer;

 tIDlast[0] = 0;

 for (i=0; i < defNo; i++) {

    if (strnicmp( (PVOID)((ULONG)sbPtr+MAX_NUM_LEN+1), tIDlast, MAX_ID_LEN)==0) {
       printf("%4.4d *%s\n",i+1,sbPtr);
    }
    else {
       if (dupsOnly == 0) printf("%4.4d  %s\n",i+1,sbPtr);
    }
    strncpy(tIDlast, (PVOID)((ULONG)sbPtr+MAX_NUM_LEN+1),MAX_ID_LEN);
    sbPtr = (CHAR*) ((ULONG)sbPtr + MAX_BUFFER_LEN);
 }

 fclose(file);
 free(sortBuffer);
 return 0;
}
