//-------------------------------------------------------------------------
// The following is part of the VIOWIN user-interface library source code.
// The code is copyright (c) 1994-1995 by Larry Salomon, Jr. and may not
// be used in a for-profit application without the expressed, written
// consent of Larry Salomon, Jr.  All rights reserved.
//-------------------------------------------------------------------------
#define INCL_DOSPROCESS
#include "vwdefs.h"

BOOL EXPENTRY vwGetMsg(PVWQMSG pqmMsg)
//-------------------------------------------------------------------------
// This function gets the next message from the circular queue.
//
// Input:  pqmMsg - points to the VWQMSG structure
// Output:  pqmMsg - points to the initialized VWQMSG structure
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   if (hmqQueue==NULL) {
      return FALSE;
   } /* endif */

   while (hmqQueue->ulTail==hmqQueue->ulHead) {
      DosSleep(0);
   } /* endwhile */

   hmqQueue->ulHead++;
   if (hmqQueue->ulHead==VW_SIZEQUEUE) {
      hmqQueue->ulHead=0;
   } /* endif */

   *pqmMsg=hmqQueue->aqmMsgs[hmqQueue->ulHead];
   return (pqmMsg->ulMsg!=WM_QUIT);
}

BOOL EXPENTRY vwDispatchMsg(PVWQMSG pqmMsg)
//-------------------------------------------------------------------------
// This function calls the appropriate window procedure with the appropriate
// parameters.
//
// Input:  pqmMsg - points to the initialized VWQMSG structure
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   if (hmqQueue==NULL) {
      return FALSE;
   } /* endif */

   (*pqmMsg->hwndWnd->pciClass->pfnWndProc)(pqmMsg->hwndWnd,
                                            pqmMsg->ulMsg,
                                            pqmMsg->mpParm1,
                                            pqmMsg->mpParm2);
   return TRUE;
}

MRESULT EXPENTRY vwSendMsg(HVWWND hwndWnd,
                           ULONG ulMsg,
                           MPARAM mpParm1,
                           MPARAM mpParm2)
//-------------------------------------------------------------------------
// This function sends a message to the window.  This is done by
// dereferencing the class and calling the window class procedure
// directly.
//
// Input:  hwndWnd - specifies the window handle
//         ulMsg - specifies the message
//         mpParm1, mpParm2 - specify the message parameters
// Returns:  value specific to the message sent
//-------------------------------------------------------------------------
{
   BOOL bOldSendMsg;
   MRESULT mrRc;

   if (hwndWnd==VWHWND_DESKTOP) {
      hwndWnd=vwWindowFromID(VWWID_DESKTOP);
   } /* endif */

   if (!vwIsWindow(hwndWnd)) {
      return MRFROMLONG(0);
   } /* endif */

   bOldSendMsg=habAnchor->bIsSendMsg;
   habAnchor->bIsSendMsg=TRUE;

   mrRc=(*(hwndWnd->pciClass->pfnWndProc))(hwndWnd,ulMsg,mpParm1,mpParm2);

   habAnchor->bIsSendMsg=bOldSendMsg;
   return mrRc;
}

BOOL EXPENTRY vwPostMsg(HVWWND hwndWnd,
                        ULONG ulMsg,
                        MPARAM mpParm1,
                        MPARAM mpParm2)
//-------------------------------------------------------------------------
// This function sends a message to the window.  This is done by
// building a VWQMSG structure and placing it in the queue.
//
// Input:  hwndWnd - specifies the window handle
//         ulMsg - specifies the message
//         mpParm1, mpParm2 - specify the message parameters
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   PVWQMSG pqmMsg;

   if (hwndWnd==VWHWND_DESKTOP) {
      hwndWnd=vwWindowFromID(VWWID_DESKTOP);
   } /* endif */

   if (!vwIsWindow(hwndWnd)) {
      return FALSE;
   } /* endif */

   if (((hmqQueue->ulHead==0) && (hmqQueue->ulTail==VW_SIZEQUEUE)) ||
       (hmqQueue->ulHead==hmqQueue->ulTail+1)) {
      return FALSE;
   } /* endif */

   hmqQueue->ulTail++;
   if (hmqQueue->ulTail==VW_SIZEQUEUE) {
      hmqQueue->ulTail=0;
   } /* endif */

   pqmMsg=&hmqQueue->aqmMsgs[hmqQueue->ulTail];

   pqmMsg->hwndWnd=hwndWnd;
   pqmMsg->ulMsg=ulMsg;
   pqmMsg->mpParm1=mpParm1;
   pqmMsg->mpParm2=mpParm2;
   return TRUE;
}

BOOL EXPENTRY vwInSendMsg(VOID)
//-------------------------------------------------------------------------
// This function determines if the system is in the middle of processing
// a vwSendMsg() call.
//
// Returns:  TRUE if in vwSendMsg(), FALSE otherwise
//-------------------------------------------------------------------------
{
   if (hmqQueue==NULL) {
      return FALSE;
   } /* endif */

   return habAnchor->bIsSendMsg;
}
