/*

toggle.cmd verison 1.0
----------------------


What version of OS/2 is this for?
---------------------------------
This script will run on ANY OS/2 system. However, it is intended for Warp 3.0.


What it does:
-------------
This rexx script patches the OS/2 system files syslevel.os2 and syslevel.mpm to
allow the installation of applications that require a Warp 4.0 base operating
system. The most noteable of which is IBM's TCPIP 4.1. There are others and
hopefulyl this will aid those that wish to install those packages to existing
Warp 3.0 machines.

The ONLY two files that this script touches are \OS2\INSTALL\SYSLEVEL.OS2 and
\MMOS2\INSTALL\SYSLEVEL.MPM.


How it does it:
---------------
By patching these two files, most installers will be fooled into thinking that
they are installing to a computer with a Warp 4.0 base operating system. What is
patched is a SINGLE byte at offset location 28h. On a Warp 3.0 machine that
byte is 30h and on a Warp 4.0 machine it's 40h...


Should I use this rexx script?
------------------------------
Use TOTALLY on your on decision. I don't support this is ANY WAY, SHAPE or
MANNER than a very big, smiley... GOOD LUCK, BUB!


How often do I need to run this thing...
----------------------------------------
You can run this as often as you like! First time you run it on a Warp 3.0 box,
the syslevel files are patched to appear as Warp 4.0. The next time you run it,
it gets toggled BACK to appear as a Warp 3.0 machine again. Flippy-flop...


How do I do it?
---------------
Run this script from the command line, with the argument "COOL", on your OS/2
BOOT hard drive. If no errors pop up, then it worked!

The actual command looks like: toggle cool

*/

  '@echo off'

  parse arg stuff .

  stuff=translate(stuff)

  if stuff \= 'COOL' then do
    say'Before you can actually run his script, you MUST read the comments inside'
    say'of it.'
    exit 1
    end /* if */

  os2dir='\os2\install\'
  mpmdir='\mmos2\install\'

/* fix os2 */

  filename='syslevel.os2'

  if stream(os2dir||filename,'c','query exists')='' then do
    say''
    say'Can not find '||filename||', patch not applied!'
    say''
    exit 1
    end /* if */

  say'Found '||filename

/* make the file accessable */

  'attrib -r '||os2dir||filename||' 1>nul'
  say'Removed read restriction from '||filename

/* use charout instead of lineout... we don't want CRLF's in these files! */

  oldByte=c2x(charin(os2dir||filename,41,1))

  if oldByte=30 then newByte=x2c(40)
                else newByte=x2c(30)

  call charout os2dir||filename, newByte, 41
  call stream  os2dir||filename,'c','close'
  say'Applied patch to '||filename
  say'Changed system from Warp'oldByte' to Warp'c2x(newByte)' signature.'

/* fix mpm */

  filename='syslevel.mpm'

  if stream(mpmdir||filename,'c','query exists') ='' then do
    say''
    say'Can not find '||filename||', patch not applied!'
    say''
    exit 1
    end /* if */

  say''
  say'Found '||filename

/* make the file accessable */

  'attrib -r '||mpmdir||filename||' 1>nul'
  say'Removed read restriction from '||filename

/* use charout instead of lineout... we don't want CRLF's in these files! */

  oldByte=c2x(charin(mpmdir||filename,41,1))

  if oldByte=30 then newByte=x2c(40)
                else newByte=x2c(30)

  call charout mpmdir||filename, newByte, 41
  call stream  mpmdir||filename,'c','close'
  say'Applied patch to '||filename
  say'Changed system from Warp'oldByte' to Warp'c2x(newByte)' signature.'

