@echo off
rem ------------------------------------------------------------------------
rem  unrpm.cmd version 1.00          SAWATAISHI Jun <jsawa@attglobal.net>
rem                                  http://www2s.biglobe.ne.jp/~vtgf3mpr/
rem  
rem   To run this batch file, at least `rpm2cpio.exe' and `cpio.exe' are 
rem required. 
rem
rem If you have installed rpm system and can use `sed.exe', "-ll" option 
rem become available (see below) for rpm package. 
rem
rem   Get GNU sed from following URLs if needed. 
rem
rem        RPM - http://www2s.biglobe.ne.jp/~vtgf3mpr/index-e.htm
rem                                                            [English Page]
rem        ZIP - ftp://ftp.leo.org/pub/comp/os/os2/leo/gnu/systools/gnused.zip
rem              ftp://hobbes.nmsu.edu/apps/editors/gnused.zip
rem
rem  
rem    You must specify environment variables, TMP_DRV and TMP_DIR_NAME, 
rem  in this file. When your temporary directory is "f:\temp"
rem           set TMP_DRV=g:
rem           set TMP_DIR_NAME=tmp
rem 
rem    You can get the latest copy of OS/2 ported rpm and its related freewares
rem   from http://www2s.biglobe.ne.jp/~vtgf3mpr/indxos2.htm
rem 
rem 
rem Specify TMP_DRV and TMP_DIR_NAME according to your environment!
rem
set TMP_DRV=g:
set TMP_DIR_NAME=tmp
rem
rem
if "%2"=="" goto usage
if "%1"=="-e" goto extract
if "%1"=="-ef" goto force
if "%1"=="-ep" goto pattern
if "%1"=="-epf" goto pattern_f
if "%1"=="-o" goto view
if "%1"=="-l" goto list
if "%1"=="-lp" goto lpattern
if "%1"=="-ll" goto longlist
if "%1"=="-fm" goto fm
if "%1"=="-llp" goto llpattern
goto end

:extract
echo\
echo Extracting files with directories
echo\
rpm2cpio %2|cpio -id --preserve-modification-time --verbose
goto end

:force
echo\
echo Extracting files with directories even if newer files exist!!
echo\
rpm2cpio %2|cpio -id --preserve-modification-time --verbose  --unconditional
goto end

:pattern
echo\
echo Extracting specified files even if newer files exist!!
echo\
if "%3" == "" echo @@ Specify PATTERN of file name[s] !!!
rpm2cpio %2|cpio -id --preserve-modification-time --verbose  "%3"
goto end


:pattern_f
echo\
echo Extracting specified files even if newer files exist!!
echo\
if "%3" == "" echo @@ Specify PATTERN of file name[s] !!!
rpm2cpio %2|cpio -id --preserve-modification-time --verbose  --unconditional "%3"
goto end


:view
if "%3" == "" echo @@ Specify single file name !!!
%TMP_DRV%
cd \
cd %TMP_DIR_NAME%
rpm2cpio %2|cpio -id --preserve-modification-time --verbose  --unconditional "%3"
cat %3
rm -f %3
goto end


:list
rpm2cpio %2 | cpio --list
goto end

:lpattern
if "%3" == "" echo @@ Specify PATTERN of file names !!!
if "%3" == "" goto end
rpm2cpio %2 | cpio --list |grep -i "%3"
goto end

:longlist
rpm -v -qlp %2 | sed "s@ /@ @"
goto end
:fm
echo ------------------------------------------------------------------------------
rpm -v -qlp %2 | sed "s@ /@ @"
echo ------------------------------------------------------------------------------
goto end

:llpattern
if "%3" == "" echo @@ Specify PATTERN of file names !!!
if "%3" == "" goto end
rpm -v -qlp %2 | sed -e "s@ /@ @" |grep -i "%3"
goto end

:usage
echo\
echo ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
echo   unrpm -e   RPM  : Extract all files at currend directory
echo   unrpm -ef  RPM  : Extract all files even if newer files exist
echo   unrpm -l   RPM  : List all files
echo   unrpm -ll  RPM  : List all files with long format(rpm.exe is needed)
echo\
echo   unrpm -ep  RPM PATTERN : Extract files matching PATTERN
echo   unrpm -epf RPM PATTERN : Extract files matching PATTERN 
echo                                                even if newer files exist
echo\
echo   unrpm -lp  RPM PATTERN : List files files matching PATTERN
echo   unrpm -llp RPM PATTERN : List files files matching PATTERN 
echo                                      with long format(rpm.exe is needed)
echo\
echo   unrpm -o   RPM  : Output single file onto standard output
echo\
echo\~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
echo  Example
echo         x:\foo] unrpm -e  x:/redhat/RPMS/i386/foo.rpm 
echo         x:\foo] unrpm -lp x:/redhat/RPMS/i386/foo.rpm *.exe
echo         x:\foo] unrpm -ep x:/redhat/RPMS/i386/foo.rpm emx/doc/*
echo         x:\foo] unrpm -o  x:/redhat/RPMS/i386/foo.rpm emx/doc/foo/README 
echo\
:end

