;
; mdsubs.asm - OS/2 Mime decoder subroutines
; Copyright (C) 1994, Richard Curry Consulting: trindflo@rain.org
; All Rights Reserved
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program in a file name 'COPYING'; if not, write to the
; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;


        TITLE   mdsubs.asm
	.386
	.387
	INCLUDELIB os2386.lib
	INCLUDELIB dde4sbs.lib
CODE32	SEGMENT DWORD USE32 PUBLIC 'CODE'
CODE32	ENDS
DATA32	SEGMENT DWORD USE32 PUBLIC 'DATA'
DATA32	ENDS
CONST32	SEGMENT DWORD USE32 PUBLIC 'CONST'
CONST32	ENDS
BSS32	SEGMENT DWORD USE32 PUBLIC 'BSS'
BSS32	ENDS
DGROUP	GROUP CONST32, BSS32, DATA32
	ASSUME	CS:FLAT, DS:FLAT, SS:FLAT, ES:FLAT
DATA32	SEGMENT
DATA32	ENDS
BSS32	SEGMENT
BSS32	ENDS
CONST32	SEGMENT
CONST32	ENDS
CODE32	SEGMENT

;
; int xlatblk(char *bufr, char *xlatab, int count);
;
; Translate count chars in bufr using xlatab
;
	ALIGN 04H
        PUBLIC xlatblk
xlatblk         PROC
        PUSH    EDI             ; Save so we can use
        XCHG    EBX, EDX        ; Need to use EBX for xlation
        MOV     EDI, EAX        ; Load bufr adrs into destination index
xlaloop:
        MOV     AL, [EDI]       ; Load a byte
        XLATB                   ; Translate the byte
        STOSB                   ; Store byte and increment index
        LOOP    xlaloop

        XCHG    EBX, EDX        ; Restore EBX
        POP     EDI             ; Restore
        RET     
xlatblk         ENDP

;
; int Pack4to3(char *sp, char *dp);
;
; Pack 4 6-bit bytes from sp into 3 8-bit bytes in dp
;       WARNING: wipes out 4 bytes at dp!
;
	ALIGN 04H
        PUBLIC Pack4to3
Pack4to3        PROC
        MOV     CX, [EAX]       ; Pick up first two bytes
        SHL     CH, 2           ; Make 1st two bytes adjacent
        ROL     CX, 2           ; Then move them to ls 12 bits
        MOV     AX, [EAX+2]     ; Pick up next two bytes
        SHL     AH, 2           ; Make 2nd two bytes adjacent
        ROR     AX, 2           ; Align bits in the proper bytes
        SHL     EAX, 8          ; And move to next 12 bits
        OR      AX, CX          ; Combine
        MOV     [EDX], EAX      ; Store 4 bytes (4th byte is garbage)
        RET     
Pack4to3        ENDP

CODE32  ENDS
END

