/*
  REXX Script to install DreckBak - create necessary directories, and create a folder on the desktop.
  This Script will also re-create the DreckBak folder and Program objects.
*/

If rxfuncquery('SysLoadFuncs') Then Do
  Call rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call Sysloadfuncs
End

Say "Installing the DreckBak Hard Disk Backup Utility."
Say "...by Murray Weismer"
Say "EMAIL:  Murray@weismer.virtualave.net"
Say "Latest version available at http://weismer.virtualave.net/DreckBak.html"
Say ""
Say "For easiest installation make sure to select a TARGET DIRECTORY"
Say "called D:\DRECKBAK, a BACKUP DIRECTORY called j:\FRESHBAK,"
Say "and a LOGS directory called D:\LOGS."
Say "If using other locations, be sure to edit the files in the"
Say "DreckBak EDIT ME folder."
Say ""
Say 'Press Y to continue installation, or N to Abort (y|n) : ';
Call charout , '-------> ';
Pull answer;
If answer='N' Then Exit
If answer='Y' Then Do

  /* Ask Directory */

  Say 'Enter target directory to install DreckBak files in. (e.g.: D:\DRECKBAK):'
  Say '(<return> = current directory, object creation only, no copy operation)'
  Parse Pull instdir 
  instdir = strip(instdir, 'T', '\')

  If instdir="" Then
    Do
      instdir=directory()
      Signal Makeicons
    End

  /* Create Target Directory */
  Say
  Say '--------------------------------------------'
  Say 'creating DreckBak Program home (target) directory' instdir
  Say '--------------------------------------------'

  If instdir <> "." Then
    Do
      Call Sysfiletree instdir, "SearchDir", "D"
      If searchdir.0 = 0 Then Do
        rc = Sysmkdir(instdir)
        If rc <> 0 Then Do
          Say "Error: Cannot create directory!" instdir
          Exit
        End
      End
    End

  /* Copy files */
  Say 'copying files to DreckBak home directory...' instdir

  '@Copy beep.exe 'instdir'\beep.exe'
  '@Copy logit.exe 'instdir'\logit.exe'
  '@Copy logit.txt 'instdir'\logit.txt'
  '@Copy DreckBak.cmd 'instdir'\DreckBak.cmd'
  '@Copy DreckBak.txt 'instdir'\DreckBak.txt'
  '@Copy FRESHBAK.CMD 'instdir'\FreshBak.cmd'
  '@Copy history.txt 'instdir'\history.txt'
  '@Copy install.cmd 'instdir'\install.cmd'
  '@Copy file_id.diz 'instdir'\file_id.diz'
  '@Copy test.lst 'instdir'\test.lst'
  '@Copy test.saf 'instdir'\test.saf'
  '@Copy DB1.ico 'instdir'\db1.ico'
  '@Copy dbf1.ico 'instdir'\dbf1.ico'
  '@Copy EDFLD.ICO 'instdir'\edfld.ico'
  '@Copy fb1.ICO 'instdir'\fb1.ico'
  '@Copy files.lst 'instdir'\files.lst'
  '@Copy rest.ico 'instdir'\rest.ico'
  '@Copy filz.cmd 'instdir'\filz.cmd'
  '@copy html.ico 'instdir'\html.ico'
  '@Type dummy.dat >'instdir'\dummy.dat'
End
MAKEICONS:


dir = instdir'\'
Say ""
Say "Creating DreckBak folders"
Call Syscreateobject "WPFolder", "DreckBak Backup Utility", "<WP_DESKTOP>", "OBJECTID=<DRECKBAKFLD>;ICONVIEW=NORMAL;ALWAYSSORT=YES;ICONFONT=10.Helv;ICONFILE=" || dir || "DBF1.ICO", "replace"
Call Syscreateobject "WPFolder", "DreckBak EDIT ME", "<DRECKBAKFLD>", "OBJECTID=<DRECKBAKEDITFLD>;ICONVIEW=NORMAL;ALWAYSSORT=YES;ICONFONT=10.Helv;ICONFILE=" || dir || "EDFLD.ICO", "replace"

Say "Creating DreckBak program objects"

Call Syscreateobject "WPProgram", "DreckBak.TXT", "<DRECKBAKFLD>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DreckBak.txt", "replace"
Call Syscreateobject "WPProgram", "Logit.txt", "<DRECKBAKFLD>", "EXENAME=E.EXE;PARAMETERS=" || dir || "Logit.txt", "replace"
Call Syscreateobject "WPProgram", "Edit test.lst", "<DRECKBAKEDITFLD>", "EXENAME=E.EXE;PARAMETERS=" || dir || "test.lst", "replace"
Call Syscreateobject "WPProgram", "Edit DreckBak", "<DRECKBAKEDITFLD>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DreckBak.cmd", "replace"
Call Syscreateobject "WPProgram", "Edit FreshBak", "<DRECKBAKEDITFLD>", "EXENAME=E.EXE;PARAMETERS=" || dir || "FreshBak.cmd", "replace"


Call Syscreateobject "WPProgram", "Restore", "<DRECKBAKFLD>", "EXENAME=UNZIP.EXE;STARTUPDIR=" ||dir || ";PARAMETERS=" "[Source Drive:\Filename.zip] -d [Target Drive and Dir]" ";ICONFILE=" || dir || "REST.ICO", "replace"
Call Syscreateobject "WPProgram", "DreckBak", "<DRECKBAKFLD>", "EXENAME=" || dir || "DreckBak.cmd;STARTUPDIR=" || dir || ";PARAMETERS=" "F E C" ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;ICONFILE=" || dir || "DB1.ICO", "replace"
Call Syscreateobject "WPProgram", "FreshBak", "<DRECKBAKFLD>", "EXENAME=" || dir || "FreshBak.cmd;STARTUPDIR=" || dir || ";PARAMETERS=" "[Target Drive:\file.zip] [source drive:\dir] [LogNameOnly]" ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;ICONFILE=" || dir || "FB1.ICO", "replace"
/* Link to website */
/*call SysCreateObject "WPProgram"," WWW Home Page","<DRECKBAKFLD>","EXENAME=NETSCAPE.EXE;PARAMETERS=http://weismer.virtualave.net/DreckBak.html;ICONFILE=" || dir || html.ico,"replace" */
/*Call Syscreateobject "WPUrl", "DreckBack ^HomePage", "<DRECKBAKFLD>", "OBJECTID=<DRECKBAKURL>; URL="http://weismer.virtualave.net/DreckBak.html"; ","U" */
If SysCreateObject('WPUrl', DRECKBAK'^Homepage', '<DRECKBAKFLD>',,
       'OBJECTID=<DRECKBAKURL>;URL=http://weismer.virtualave.net/DreckBak.html;','U')=0 then
   do
      say aTitle' Homepage link could not be created'
      exit(1)
   end

Say "WPS objects Created for DreckBak"
Say ""
Say ""

/* Ask Backup Directory */

Say 'Enter target directory where the backups will be created (e.g.: j:\FreshBak):'
Say 'be sure there will be enough space on this drive.'
Say '(<return> = current directory, Probably not a good idea.)'
Parse Pull bakdir
instdir = strip(bakdir, 'T', '\')

If bakdir="" Then
  Do
    bakdir=directory()
    Signal Logs
  End
/* Create BACKUP Directory */
Say
Say '--------------------------------------------'
Say 'creating directory to hold backups - ' bakdir
Say '--------------------------------------------'

If bakdir <> "." Then
  Do
    Call Sysfiletree instdir, "SearchDir", "D"
    If searchdir.0 = 0 Then Do
      rc = Sysmkdir(bakdir)
      If rc <> 0 Then Do
        Say "Error: Cannot create directory! - " bakdir
        Exit
      End
    End
  End

LOGS:
/* Ask Logs Directory */

Say 'Enter Logging directory (e.g.: d:\Logs):'
Say '(<return> = current directory, Probably not a good idea.)'
Parse Pull logdir
instdir = strip(logdir, 'T', '\')

If logdir="" Then
  Do
    logdir=directory()
    Signal Done
  End
/* Create LOG Directory */
Say
Say '--------------------------------------------'
Say 'creating directory to hold LogFiles - ' logdir
Say '--------------------------------------------'

If logdir <> "." Then
  Do
    Call Sysfiletree instdir, "SearchDir", "D"
    If searchdir.0 = 0 Then Do
      rc = Sysmkdir(logdir)      If rc <> 0 Then Do
        Say "Error: Cannot create directory! - " logdir
        Exit
      End
    End
  End
DONE:
Say ""
Say "Be sure to edit all SET statements In DRECKBAK and FILZ.cmd to reflect your system."
Say "Open DreckBak.txt for full instructions for editing."
Say "DO NOT RUN DRECKBAK.CMD until you have edited it!!!!!"
Say ""
Say "PLEASE READ THE DOCS!!!!"
Say "Schedb2.zip is not copied to the DreckBak directory"
Say "It will remain in this install directory." 
Say "It wil not be deleted if you choose to have me clean up."
Say ""
Say "Installation Complete"
Say 'Do you wish me to clean up the install directory? (y|n) : ';
Call charout , '-------> ';
Pull answer;
If answer='N' Then DONE
If answer='Y' Then Do
  del beep.exe 
  del logit.exe 
  del logit.txt 
  del DreckBak.cmd 
  del DreckBak.txt 
  del FRESHBAK.CMD 
  del history.txt 
  del install.cmd 
  del file_id.diz 
  del test.lst 
  del test.saf
  del DB1.ico 
  del dbf1.ico 
  del EDFLD.ICO 
  del fb1.ICO 
  del files.lst 
  del rest.ico 
  del filz.cmd
  del html.ico 
  del dummy.dat 
End

DONE:
'@beep.exe 25 200'
'@beep.exe 117 200'
'@beep.exe 1046 200'
'@beep.exe 2093 200'
'@beep.exe 4096 200'
Exit

