/* Don't edit this file, as it is generated by 'PPREXX' version 1.0 from the ..\src directory. */
/* Please edit the following:
    ..\src\putini.cmd
    ..\src\lib.cmd
    ..\src\ascii.cmd
*/
/*  ͻ
      PUTINI puts selected USER and SYSTEM INI data for multiple drive     
      support.                                                             
                                                                           
      17/06/02: V1.0 - Initial version (gjarvis@ieee.org)                  
      17/02/03: V1.1 - fix bootpath    (gjarvis@ieee.org)                  
      03/06/03: V1.2 - key in quotes (may have spaces)   (gjarvis@ieee.org)
      15/09/03: V1.3 - map datapath                      (gjarvis@ieee.org)
    ͼ */


'@echo off'
prgver = '1.3'
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs
call newascii 

call getosver prgver, os.
say os.0line
listFile = 'getini.lst'
datFile = 'getini.din'

/* statistics */
num.rd = 0
num.new = 0
num.upd = 0
num.err = 0

_d_ = '"'
parse arg file '(' opt
if file<>'' then datfile = file
call parseopt opt, copt.
writeflag = getopt('WRITE', copt.)
say 'reading' datfile 'and write =' writeflag

 /* read dat file */
say linein(datfile)
do while lines(datFile)
    call putkey
end
call closefile datfile

say os.0prgname 'read:' num.rd 'new:' num.new 'updated:' num.upd 'error' num.err
exit 0;





/* read linein and put key value for ini & app & key & val if changed and return true */
putkey: procedure expose datfile tran. num. _d_ writeFlag os.
    num.rd = num.rd + 1
    parse value Linein(datfile) with ini . (_d_) app (_d_) (_d_) key (_d_) (tran.4) valfmt (tran.5) val .
    if length(val)<>(2*length(valfmt)) then do
       say "missing part of value in line" num.rd '"'app'"' '"'key'"'
       num.err =num.err + 1
       return 0
    end /* do */
    else
    val = x2c(val)
    val = changestr('D:\', val, os.0datapath)
    val = changestr('C:\', val, os.0bootpath)
    asc = asciiformat(val)
    oldval = SysIni(ini, app, key)
    if oldval=val then return 0
    if writeFlag then call sysini ini, app, key, val
    if oldval='ERROR:' then do
        op = 'new'
        num.new = num.new + 1
    end
    else do
        op = 'updated'
        num.upd = num.upd + 1
    end
    if length(val)>60 then asc = 'length(value)='|| length(val)
    say op ini '"'app'"' key asc
    return 1


getosver:procedure expose delimit.
   use arg prgver, os.
   call createdelimiters
   /* program invoked */
   parse upper source . . os.0prgname
   /* bootpath */
   parse value value('PATH',,'OS2ENVIRONMENT') with . ":\OS2;" -1 os.0bootPath +3
   /* datapath */
   parse var os.0prgname os.0datapath +3
   /* version - note sysos2ver() returns version of C: rather than actual bootdrive */
   /*4502.*/
   os.0ver = strip(translate("31524",c2x(charin(os.0bootpath"OS2\INSTALL\SYSLEVEL.OS2",41,2))'.',"12345"),,0)
   call stream bootpath"OS2\INSTALL\SYSLEVEL.OS2", 'c', 'close'
   curpath = directory()
   ecspath = directory(os.0bootpath'ecs')
   select
      when os.0ver<4.51 then os.0ver = 'WARP' os.0ver
      when  translate(ecspath)=os.0bootpath'ECS' then os.0ver = 'eCS' os.0ver
   otherwise os.0ver = 'SWC' os.0ver
   end  /* select */
   call directory(curpath)
   /* program name */
   i = lastpos('\', os.0prgname) + 1
   parse var os.0prgname =(i) os.0prg "."
   /* program running line */
   os.0line = os.0prg prgver 'running' '"'os.0bootpath'"' os.0ver 'on' date() time()
   return



/* wildcard match */
wildcardmatch: procedure
   parse arg wstr, str
   w = pos('*',wstr)
   if w<2 then m = str==wstr
   else m = left(str,w-1)==left(wstr,w-1)
   return m


/*  return true if file succesfully closed */
closeFile:   procedure
   ret = stream(arg(1),'C','CLOSE')
   if ret='READY:' then return 1
   say 'error closing file stream' arg(1) ret
   exit -1
   return 0


/*  return true if file exists */
fileExists:  procedure
   ret = stream(arg(1),'C','QUERY EXISTS')
   if ret='' then return 0
   return 1


/* ͸
     parse options                                                        
        stem    global  delimit.
        string  in      option string to parse (any case)
        stem    out     option stem
   ;  */
ParseOpt: procedure expose delimit.
  use arg sop, option.
  dq = '"'
  quote = translate(sop,delimit.asciiless,delimit.ascii,dq)
  option.KEY = ""
  option.0 = 0
  do forever
    if sop='' then leave
    pdq = pos(dq,quote)
    if pdq>0 then do
      parse var sop keys =(pdq) d +1  str (d) sop
      quote = right(quote,length(sop))
    end
    else do
       keys = sop
       str = ''
       sop = ''
    end
    option.KEY = option.KEY keys
    w = words(keys)
    if w>1 then
      do i  = option.0+1 to option.0+w-1
         option.i = ''
      end /* do */
    i = option.0 + w
    option.i = str
    option.0 = i
  end
  option.key = translate(strip(option.key,'L'))
   return

/* ͸
     true if name exists in option                                        
        string  in      key string to test (upper case)
        stem    in/out  option stem
        bool    ret     if string is a option
   ;  */
GetOpt: procedure
   use arg skey, gopt.
   gopt.pos = wordpos(skey, gopt.KEY)
   return gopt.pos>0
   

/* ͸
     gets option string of key from last GETOPT call, 
    which may be optional and may have a default     

string  in      default string 
        stem    in      option stem
        string  ret     option string or default string or null
   ;  */
GetStrOpt: procedure
   use arg default, gsopt.
   found = gsopt.[gsopt.pos]
   if length(found)=0 then found = default
   return found


/**
CreateDelimiters
create global dynamic delimit stem
stem global delimit.
*/
CreateDelimiters: procedure expose delimit.
delimit.STR = '"' || "'`!@#$%^&"
delimit.asciiless = ''
do i = 32 to 126
   if pos(d2c(i),delimit.Str)=0 then delimit.asciiless = delimit.asciiless || d2c(i)
end /* do */
delimit.ascii = delimit.asciiless || delimit.str
return


/**
WHENSELECTED Make and when test.
    make    in  string  make words (may be empty)
    mwhen   in  string  when words (may be '*')
    return  flag    if okay
    */
whenselected: procedure
   parse arg make, mwhen
   if mwhen='*' then return 1
   if words(make)>0 then do i=1 to words(make)
      if wordpos(word(Make,i),MWhen)>0 then return 1
   end /* do */
   return 0
   




/**ASCII Setup ascii trans. table*/
NEWASCII: procedure expose tran.
/* table translation
    tran.1  printable ascii and graphic char for null
    tran.2  all codes with tran.1 first but actual null
    tran.3  pad char for binary char
    tran.4  begin quote char
    tran.5  end quote char          */
tran.3 = d2c(2)
tran.4 = d2c(16)
tran.5 = d2c(17)
do i = 32 to 126
    tran.1 = tran.1||d2c(i)
end /* do */
tran.2 = tran.1
tran.1 = tran.1||d2c(232)
do i = 0 to 31
   tran.2 = tran.2||d2c(i)
end /* do */
do i = 127 to 255
   tran.2 = tran.2||d2c(i)
end /* do */
tran.0 = 5                                                  s
return


/**  ASCIIFORMAT Quick format binary/ASCIIZ/ASCII. */
ASCIIFORMAT: procedure expose tran.
   parse arg val
    return tran.4||translate(val,tran.1,tran.2,tran.3)||tran.5
    
    
