/****************************************************************/
/*             Creation of GenINI desktop folder                */
/****************************************************************/

CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

SAY 'GenINI Installation Script.'
SAY
SAY 'Create GenINI folder and icons.'
SAY
SAY 'NOTE: This program needs to be executed from the installation directory'
SAY '      of your working GenINI setup.'
SAY

CALL CreateObjects
EXIT

/****************************************************************/

CreateObject: PROCEDURE
    PARSE ARG Class, Title, Location, Setup
    SAY 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, 'Replace' )
    If rc <> 1 Then
        SAY ' > failed to create ['Title' | 'Class'] at location ['Location']'
    RETURN

/****************************************************************/

CreateShadow: PROCEDURE
    PARSE ARG Original, Location
    SAY 'Creating Shadow of 'Original
    rc = SysCreateShadow( Original, Location )
    If rc <> 1 Then
        SAY ' > failed to create shadow of 'Original' at location ['Location']'
    RETURN

/****************************************************************/

CreateObjects: PROCEDURE

    current_dir = directory()

    /***************/
    /* MAIN FOLDER */
    /***************/

    CALL CreateObject 'WPFolder',,
        'GenINI',,
        '<WP_DESKTOP>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONVIEW=NONGRID,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,NORMAL;'||,
            'ALWAYSSORT=YES;'||,
            'OBJECTID=<GenINI_folder>'

    /***************************/
    /*  OBJECTS IN MAIN FOLDER */
    /***************************/

    CALL CreateShadow current_dir||'\README', '<GenINI_folder>'

    CALL CreateObject 'WPProgram',,
          'Dump INI file',,
          '<GenINI_folder>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='||current_dir||'\DUMPINI.EXE;'||,
              'STARTUPDIR='||current_dir||';'||,
              'MINIMIZED=YES;'||,
              'OBJECTID=<DumpINI_program>'

    CALL CreateObject 'WPProgram',,
          'Restore INI file',,
          '<GenINI_folder>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='||current_dir||'\LOADINI.EXE;'||,
              'STARTUPDIR='||current_dir||';'||,
              'OBJECTID=<LoadINI_program>'

    CALL CreateObject 'WPProgram',,
          'GenINI documentation',,
          '<GenINI_folder>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='||'VIEW.EXE;'||,
              'PARAMETERS='||current_dir||'\DOC\GENINI.INF;'||,
              'STARTUPDIR='||current_dir||';'||,
              'MINIMIZED=NO;'||,
              'OBJECTID=<GenINI_INF>'

    CALL CreateObject 'WPURL',,
          'Updates',,
          '<GenINI_folder>',,
          'NOPRINT=YES;'||,
              'URL=http://www.pmoylan.org/pages/os2/genini.html'

    RETURN

