/* Build script for the GenINI package */

'del genini*.zip'
cd doc
'ipfc -i genini.ipf'
cd ..
'xc =p loadini.prj'
'xc =p dumpini.prj'
'\apps\lxlite\lxlite *.exe'

/* Create the sym and xqs files. */

'call PerlEnv.cmd'
perl 'D:\Apps\scripts\makexqs.pl' loadini.map
say "loadini.sym and loadini.xqs should now exist"
perl 'D:\Apps\scripts\makexqs.pl' dumpini.map
say "dumpini.sym and dumpini.xqs should now exist"

/* zip up the source files. */

del src.zip
'Imports LoadINI | zip -j -u src.zip -@'
'Imports DumpINI | zip -j -u src.zip -@'
'zip -u src.zip doc\genini.ipf'

/* Version and icons. */

ver = version()
call bldlvl ver
call seticon

/* Put our build into temporary directory buildtemp. */

rmdir buildtemp
mkdir buildtemp
cd buildtemp

'mkdir source'
'cd source'
'copy ..\..\src.zip'
'unzip src.zip'
'del src.zip'
CALL SortSrc
'cd ..'

'mkdir doc'
'mkdir TNItools'
'copy ..\doc\changes.txt doc'
'copy ..\doc\genini.inf doc'
'copy ..\TNItools\*.cmd TNItools'
'copy ..\TNItools\README.TNItools TNItools'
'copy ..\TNItools\changes.txt TNItools'
'copy ..\README'
'copy ..\file_id.diz'
'copy ..\loadini.exe'
'copy ..\dumpini.exe'
'copy ..\makefolder.cmd'
'copy ..\makezip.cmd'
'eautil makefolder.cmd nul /S'
'copy D:\Dev1\general\doc\gpl.txt'
'copy gpl.txt ..'
'zip -r ..\GenINI_'ver'.zip .'

/* Remove temporary files. */

'cd ..'
'call deltree /Y buildtemp >nul'           /* deltree3.zip from Hobbes */

EXIT 0

/****************************************************************/
/*                  SORTING THE SOURCE FILES                    */
/****************************************************************/

SortSrc: PROCEDURE

    /* Moves the files in the current directory to              */
    /* subdirectories that more accurately reflect the original */
    /* source directories. This is not a perfect sort, since    */
    /* the files came from several top-level directories, but   */
    /* it gives a more readable result.                         */

    rc = SysMkDir('def')
    rc = SysMkDir('src')
    rc = SysMkDir('sym')
    rc = SysFileTree('*', tree, 'O')
    DO j = 1 TO tree.0
        fname = tree.j
        tail = TRANSLATE(RIGHT(fname, 4))
        IF tail = '.DEF' THEN
            '@move 'fname' def'
        ELSE IF tail = '.MOD' THEN
            '@move 'fname' src'
        ELSE IF tail = '.SYM' THEN
            '@move 'fname' sym'
    END
    RETURN

