/*
 * items.c - handles itemized list commands (formerly part of translate.c)
 *           and @set / @clear tag lists
 *
 * texi2roff history:
 *             Release 2.0     January 1990
 *
 * Copyright 1988, 1989, 1990  Beverly A.Erlebacher
 * erlebach@cs.toronto.edu    ...uunet!utai!erlebach
 *
 * texi2ipf history:
 *             Release 1.0     February 1993
 *
 * Modified by Marcus Grber, Fido 2:2402/61.1
 *
 * Modified by Martin "Herbert" Dietze, Email herbert@wiloyee.shnet.org
 *
 */

/*
 * History:
 *
 * $Log: items.c,v $
 * Revision 1.3  1997/01/15 12:18:18  herbert
 * - Fixed a bug in eat_first_word() that made the program crash sometimes.
 * - "@ignore" environments will now be handled like real comments.
 *
 * Revision 1.2  1996/12/17 15:14:21  herbert
 * Only some cosmetic changes. The code looks still rather ugly to me :-)
 *
 * Revision 1.1.1.1  1996/12/02 12:10:01  herbert
 * Texi2IPF 1.0
 *
 */

#include "texi2ipf.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static char * id =
"@(#)$Id: items.c,v 1.3 1997/01/15 12:18:18 herbert Exp $";

int  icount[MAXILEVEL];
int  what[MAXILEVEL];
char item[MAXILEVEL][MAXLINELEN];

struct {
    char name[MAXTAGSIZE];
    char *value;
} tags[MAXTAG];                /* list of currently set tags */
int tagnum=0;                  /* number ob tags set */

extern int  ilevel;
char * gettoken( char *, char *);
char * eatwhitespace( char *);
void errormsg( char *, char *);
struct tablerecd * lookup( char *);

/*
 * itemize - handle the itemizing start commands @enumerate, @itemize
 *     and @table
 */

char * itemize( char*s, char *token)
{
    char *tag;

    tag = item[ilevel];
    if ( STREQ( token, "@itemize") ) {
        what[ilevel] = ITEMIZE;
        s = gettoken( eatwhitespace( s), tag);
        if ( *tag == '\n' ) { /* this is an error in the input */
            --s;
            *tag = '-';
            errormsg( "missing itemizing argument ", "");
        } else {
            if ( *tag =='@' ) {
                if ( (lookup(tag)==NULL) && (lookup(strcat(tag,"{"))==NULL) )
                    errormsg( "unrecognized itemizing argument ", tag);
                else
                    if ( *(tag + strlen(tag) - 1) == '{' )
                        (void) strcat( tag, "}");
            }/* if */
        }/* if */
        (void) strcat( tag, " ");
    } else if ( STREQ(token, "@enumerate") ) {
        what[ilevel] = ENUMERATE;
        icount[ilevel] = 1;
    } else if ( STREQ( token, "@table") ) {
        what[ilevel] = TABLE;
        s = gettoken( eatwhitespace( s), tag);
        if ( *tag == '\n' ) {
            *tag = '\0';  /* do nothing special */
            --s;
        } else {
            if ( *tag =='@' ) {
                if ( (lookup( tag) == NULL) 
                     && (lookup( strcat( tag, "{")) == NULL) )
                    errormsg( "unrecognized itemizing argument ", tag);
                else {
                    what[ilevel] = APPLY;
                    if ( *(tag + strlen(tag) - 1) != '{' )
                        (void) strcat( tag, "{");
                }/* if */
            }/* if */
        }/* if */
    }/* if */
    while ( *s != '\n' && *s != '\0' )
        ++s;  /* flush rest of line */
    /* endwhile */
    return s;
}/* itemize() */

/*
 * doitem - handle @item and @itemx
 */

char * doitem( char *s, char *tag, int itemx)
{
    switch ( what[ilevel] ) {
    case ITEMIZE:
    case ENUMERATE:
        *tag=0;
        break;
    case TABLE:
        (void) strcpy( tag, (itemx ? "@br\n" : "@_tag{pt}"));
        tag+=strlen( tag);
        s = eatwhitespace( s);
        if ( *s == '\n' ) {
            *tag++ = '-';
            errormsg( "missing table item tag", "");
        } else
            while( *s != '\n' )
                *tag++ = *s++;
        *tag = '\0';
        break;
    case APPLY:
        (void) strcpy( tag, (itemx ? "@br\n" : "@_tag{pt}"));
        (void) strcat( tag, item[ilevel]);
        tag += strlen( tag);
        s = eatwhitespace( s);
        while( *s != '\n' )
            *tag++ = *s++;
        *tag++ = '}';
        *tag = '\0';
        break;
    }/* switch */
    return s;
}/* doitem() */

/*
 * findtag - returns -1 if the tag has not been set,
 *           or the index of the tag in the tag list.
 */
int findtag( char *str)
{
    int i;

    for( i = 0; i<tagnum; i++ )
	if ( !strncmp( str, tags[i].name, strlen( tags[i].name)) )
            return i;
        /* endif */
    /* endfor */
    return -1;
}/* findtag */

char * value ( char *str)
{
    int i;

    if ( (i = findtag( str)) == -1 ) {
        return NULL;
    } else {
        return tags[i].value;
    } /* endif */
}/* value */

/*
 * setclear - sets (value!="") or clears (value=="") a tag
 */
int setclear( char *str, char *val)
{
    int i;
    if( *val ) {                    /* SET tag */
        if ( (i=findtag( str)) == -1 && tagnum < MAXTAG )  
            i=tagnum++;              /* Tag not found? Add tag */
        else
            free( tags[i].value);      /* Replace old tag value */
        /* endif */
        tags[i].value = malloc( strlen( val)+1);
        if ( tags[i].value == NULL )
	    return -1;
  	/* endif */
        strncpy( tags[i].name, str, MAXTAGSIZE);
        strcpy( tags[i].value, val);
    } else {
                                      /* CLEAR tag */
        i=findtag( str);              /* tag set? */
        if( i!=-1 ) {                 /* yes, remove */
            free( tags[tagnum-1].value);
            memcpy( &tags[i], &tags[--tagnum], sizeof(*tags));
        }/* if */
    }/* if */
    return 0;
}/* setclear() */
