/* REXX:make XPDF desktop objects, search fonts */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysloadFuncs'
Call SysLoadFuncs

Parse Arg Param
if Param == '/Cleanup' then
  do
    Say 'Cleaning paths from batch files ..'
    Call set_PATH_TO_XPDF 'pdftotext.cmd', ''
    Call set_PATH_TO_XPDF 'pdfimages.cmd', ''
    Call set_PATH_TO_XPDF 'pdftoppm.cmd' , ''
    Call set_PATH_TO_XPDF 'pdftops.cmd'  , ''
    Call set_PATH_TO_XPDF 'pdfinfo.cmd'  , ''
    Exit 0
  end


ExeDir=Directory()
Call SysCls
Say '======= XPDF profile and WPS setup  ====================='
Say 'Reading profile ..'
Call ReadProfile
Say 'Installing support for IBM-858 ..'
Call Add_IBM_858
Say 'Searching fonts ..'
Call Add_T1_TTF
Say 'Writing profile ..'
Call WriteProfile

Say 'Changing paths in batch files ..'
Call set_PATH_TO_XPDF 'pdftotext.cmd', ExeDir'\'
Call set_PATH_TO_XPDF 'pdfimages.cmd', ExeDir'\'
Call set_PATH_TO_XPDF 'pdftoppm.cmd' , ExeDir'\'
Call set_PATH_TO_XPDF 'pdftops.cmd'  , ExeDir'\'
Call set_PATH_TO_XPDF 'pdfinfo.cmd'  , ExeDir'\'

Say 'Attaching icons ..'
Call SysSetIcon 'pdffonts.exe',  'xpdf.ico'
Call SysSetIcon 'pdfimages.cmd', 'xpdf.ico'
Call SysSetIcon 'pdfimages.exe', 'xpdf.ico'
Call SysSetIcon 'pdfinfo.cmd',   'xpdf.ico'
Call SysSetIcon 'pdfinfo.exe',   'xpdf.ico'
Call SysSetIcon 'pdftoppm.cmd',  'xpdf.ico'
Call SysSetIcon 'pdftoppm.exe',  'xpdf.ico'
Call SysSetIcon 'pdftops.cmd',   'xpdf.ico'
Call SysSetIcon 'pdftops.exe',   'xpdf.ico'
Call SysSetIcon 'pdftotext.cmd', 'xpdf.ico'
Call SysSetIcon 'pdftotext.exe', 'xpdf.ico'

Say 'Creating objects ..'
Call SysCreateObject 'WPFolder', 'XPDF', '<WP_DESKTOP>', 'ALWAYSSORT=YES;OBJECTID=<XPDF_FOLDER>;', 'Update'
Call Create_WPS 'PDF to Text',        'pdftotext.cmd', '<PDFtoTEXT>'
Call Create_WPS 'PDF Images extract', 'pdfimages.cmd', '<PDFImages>'
Call Create_WPS 'PDF to PPM pages',   'pdftoppm.cmd', ' <PDFtoPPM>'
Call Create_WPS 'PDF to PostScript',  'pdftops.cmd',   '<PDFtoPS>'
Call Create_WPS 'PDF Info',           'pdfinfo.cmd',   '<PDFInfo>'

Say 'Done.'
Return 0


set_PATH_TO_XPDF:
  Parse Arg batchfilename, ExeDirToSet

  linecount=0
  Call Stream batchfilename, 'C', 'Open Read'
  do while Lines(batchfilename)
    linecount=linecount+1
    line.linecount=LineIn(batchfilename)
    if Pos('if [%PATH_TO_XPDF%]==[] set PATH_TO_XPDF=',line.linecount)<>0 then
      line.linecount='if [%PATH_TO_XPDF%]==[] set PATH_TO_XPDF='ExeDirToSet
  end
  Call Stream batchfilename, 'C', 'Close'

  Call Stream batchfilename, 'C', 'Open Write Replace'
  do i=1 to linecount
    Call LineOut batchfilename, line.i
  end
  Call Stream batchfilename, 'C', 'Close'

  Return


Create_WPS:
  Parse Arg title, command, oid

  Call SysCreateObject 'WPProgram', title, '<XPDF_FOLDER>', 'EXENAME='ExeDir'\'command';PROGTYPE=PROG_WINDOWABLEVIO;STARTUPDIR='ExeDir';NOAUTOCLOSE=NO;ASSOCFILTER=*.pdf;ASSOCTYPE=PDF;OBJECTID='oid';', 'Replace'

  Return


ReadProfile:
  linecount=0
  profile=Value('HOME',, 'OS2ENVIRONMENT')
  if profile=='' then Return

  profile=profile'\.xpdfrc'
  Say profile

  if Stream(profile, 'C', 'Query Exist')=='' then
    do
      line.1='# xpdf profile: read xpdfrc.cat for help'
      line.2='psPaperSize A4'
      line.3='textEOL dos'
      linecount=3
    end
  else
    do
      Call Stream profile, 'C', 'Open Read'
      do while Lines(profile)
        linecount=linecount+1
        line.linecount=LineIn(profile)
      end
      Call Stream profile, 'C', 'Close'
    end

  Call RemoveTrailingEmptyLines
  Call MakeLastIniLineEmpty

  Return

Add_IBM_858:

  Call MakeLastIniLineEmpty
  Call SetIni 'unicodeMap IBM-858', ExeDir'\IBM-858.unicodeMap'
  Call SetIni 'textEncoding', 'IBM-858'

  Return


Add_T1_TTF:
  Say '  Please enter path to either GSView, or Adobe Acrobat reader fonts. Leave empty to skip'
  Pull FontSearchDir

  Call MakeLastIniLineEmpty

  /*                                         URW (GS)        \PSFONTS      WinOS2         AR 4.05         AR 3 */
  Call SearchFont   "Courier",               "n022003l.pfb", "cour.pfb"  , "cour.ttf"   , "com_____.pfb", "com_____.pfb"
  Call SearchFont   "Courier-Bold",          "n022004l.pfb", "courb.pfb" , "courbd.ttf" , "cob_____.pfb", "cob_____.pfb"
  Call SearchFont   "Courier-BoldOblique",   "n022024l.pfb", "courbi.pfb", "courbi.ttf" , "cobo____.pfb", "cobo____.pfb"
  Call SearchFont   "Courier-Oblique",       "n022023l.pfb", "couri.pfb" , "couri.ttf"  , "coo_____.pfb", "coo_____.pfb"
  Call SearchFont   "Helvetica",             "n019003l.pfb", "helv.pfb"  , "arial.ttf"  , "_a______.pfb", "hv______.pfb"
  Call SearchFont   "Helvetica-Bold",        "n019004l.pfb", "helvb.pfb" , "arialbd.ttf", "_ab_____.pfb", "hvb_____.pfb"
  Call SearchFont   "Helvetica-BoldOblique", "n019024l.pfb", "helvbi.pfb", "arialbi.ttf", "_abi____.pfb", "hvbo____.pfb"
  Call SearchFont   "Helvetica-Oblique",     "n019023l.pfb", "helvi.pfb" , "ariali.ttf" , "_ai_____.pfb", "hvo_____.pfb"
  Call SearchFont   "Symbol",                "s050000l.pfb", "symb.pfb"  , ""           , "Sy______.pfb", "sy______.pfb"
  Call SearchFont   "Times-Bold",            "n021004l.pfb", "tnrb.pfb"  , "timesbd.ttf", "_eb_____.pfb", "tib_____.pfb"
  Call SearchFont   "Times-BoldItalic",      "n021024l.pfb", "tnrbi.pfb" , "timesbi.ttf", "_ebi____.pfb", "tibi____.pfb"
  Call SearchFont   "Times-Italic",          "n021023l.pfb", "tnri.pfb"  , "timesi.ttf" , "_ei_____.pfb", "tii_____.pfb"
  Call SearchFont   "Times-Roman",           "n021003l.pfb", "tnr.pfb"   , "times.ttf"  , "_er_____.pfb", "tir_____.pfb"
  Call SearchFont   "ZapfDingbats",          "d050000l.pfb", ""          , ""           , "Zd______.pfb", "zd______.pfb"

  Return

SearchFont:
  Parse Arg Name, URW, PSFONTS, WINOS2, AR4, AR3
  NamePad = Left(Name'                       ', 22)
  Call CharOut ,'  -' NamePad '... '

  if (FontSearchDir <> '') then
    if (Right(FontSearchDir, 1) = '\') | (Right(FontSearchDir, 1) = '/') then
      FontSearchDir = Left(FontSearchDir, Length(FontSearchDir) - 1)

  IniT1 = SearchIni('displayFontT1 'Name)
  if FileExist(IniT1) <> '' then
    do
      Say IniT1
      Return
    end

  IniTT = SearchIni('displayFontTT 'Name)
  if FileExist(IniTT) <> '' then
    do
      Say IniTT
      Return
    end

  FFN = FileExist(FontSearchDir'\'URW, FontSearchDir'\fonts\'URW)
  if FFN <> '' then
    do
      Say FFN
      Call SetIni 'displayFontT1 'NamePad, FFN
      Return
    end

  FFN = FileExist(FontSearchDir'\'AR4, FontSearchDir'\Adobe\Acrobat 4.0\Resource\Font\'AR4)
  if FFN <> '' then
    do
      Say FFN
      Call SetIni 'displayFontT1 'NamePad, FFN
      Return
    end

  FFN = FileExist(FontSearchDir'\'AR3, FontSearchDir'\fonts\'AR3)
  if FFN <> '' then
    do
      Say FFN
      Call SetIni 'displayFontT1 'NamePad, FFN
      Return
    end

  if PSFONTS <> "" then
    FFN = FileExist(SysBootDrive()'\psfonts\'PSFONTS)
    if FFN <> '' then
      do
        Say FFN
        Call SetIni 'displayFontTT 'NamePad, FFN
        Return
      end

  if WINOS2 <> "" then
    FFN = FileExist(SysBootDrive()'\os2\mdos\winos2\system\'WINOS2)
    if FFN <> '' then
      do
        Say FFN
        Call SetIni 'displayFontTT 'NamePad, FFN
        Return
      end

  Say ' ---- could not find any matching file, sorry!'
  Call SetIni 'displayFontT1 'NamePad, 'c:\extra\gstools\fonts\'URW
  Return

FileExist:
  Parse Arg FN1, FN2
  if FN1 <> '' then
    if Stream(FN1, 'C', 'Query Exist') <> '' then
      Return FN1
  if FN2 <> '' then
    if Stream(FN2, 'C', 'Query Exist') <> '' then
      Return FN2
  Return ''

SearchIni:
  Parse Arg Key
  do ii=1 to linecount
    if (Pos(Key' ', line.ii) == 1) then
      do
        Return Strip(SubStr(line.ii, Length(Key)+1))
      end
  end

  Return ''

SetIni:
  Parse Arg Key, Val

  KeyStrip = Strip(Key)
  do ii=1 to linecount
    if Pos(KeyStrip, line.ii) == 1 then
      do
        line.ii = Key Val
        Return
      end
  end

  linecount = linecount + 1
  line.linecount = Key Val

  Return

MakeLastIniLineEmpty:
  if (linecount == 0) | (line.linecount <> '') then
    do
      linecount = linecount + 1
      line.linecount = ''
    end
  Return

RemoveTrailingEmptyLines:
  do forever
    if (linecount >= 1) & (Strip(line.linecount) == '') then
      linecount = linecount - 1
    else
      Leave
  end
  Return

WriteProfile:
  Call RemoveTrailingEmptyLines
  Call Stream profile, 'C', 'Open Write Replace'
  do i=1 to linecount
    Call LineOut profile, line.i
  end
  Call Stream profile, 'C', 'Close'

  Return
