/*
 * save.c - Save Display or Entire Text
 */

#include <stdio.h>
#include <stdlib.h>

#include <os2.h>

#include "qpager.h"
#include "screen.h"

static  UCHAR   saveName[256] = ""    ;
static  UCHAR   saveBuff[256] = { 0 } ;
static  UCHAR   saveData[2048] ;

/*
 * cmdSaveDisp - Save Current Display Contents
 */

FILEPTR cmdSaveDisp(FILEPTR fptr)
{
    FILE    *fp ;
    int     n ;
    LINEPTR p ;

    /*
     * get file name to save
     */    
    strcpy(saveBuff, saveName) ;
    if (scrEnter("save screen ", saveBuff, 64) == NULL) {
        dispPage(fptr) ;
	return fptr ;
    }
    strcpy(saveName, saveBuff) ;

    /*
     * check file existense
     */
    if (access(saveName, 0) == 0) {
        sprintf(saveBuff, "%s exist, overwrite ? (y/n) ", saveName) ;
	strcpy(saveData, "") ;
	scrEnter(saveBuff, saveData, 4) ;
	if (saveData[0] != 'y' && saveData[0] != 'Y') {
	    dispPage(fptr) ;
	    return fptr ;
        }
    }

    /*
     * open for writing
     */
    if ((fp = fopen(saveName, "w")) == NULL) {
        sprintf(saveBuff, "cannot open %s", saveName) ;
	scrEnter("", saveBuff, 64) ;
	dispPage(fptr) ;
	return fptr ;
    }

    /*
     * save screen
     */
    n = 0 ;
    p = fptr->curln ;
    while (n < nLines && p != NULL) {
        kanjiConv(p->line, saveData, p->code) ;
	fprintf(fp, "%s\n", saveData) ;
	n += dispLine(n, p, FALSE) ;
	p = linesNext(fptr, p) ;
    }
    fclose(fp) ;

    dispPage(fptr) ;

    return fptr ;
}

/*
 * cmdSaveFile - Save Entire File Contents
 */

FILEPTR cmdSaveFile(FILEPTR fptr)
{
    FILE    *fp ;
    LINEPTR p   ;

    /*
     * get file name to save
     */    
    strcpy(saveBuff, saveName) ;
    if (scrEnter("save to file ", saveBuff, 64) == NULL) {
        dispPage(fptr) ;
	return fptr ;
    }
    strcpy(saveName, saveBuff) ;

    /*
     * check file existense
     */
    if (access(saveName, 0) == 0) {
        sprintf(saveBuff, "%s exist, overwrite ? (y/n) ", saveName) ;
	strcpy(saveData, "") ;
	scrEnter(saveBuff, saveData, 4) ;
	if (saveData[0] != 'y' && saveData[0] != 'Y') {
	    dispPage(fptr) ;
	    return fptr ;
        }
    }

    /*
     * open for writing
     */
    if ((fp = fopen(saveName, "w")) == NULL) {
        sprintf(saveBuff, "cannot open %s", saveName) ;
	scrEnter("", saveBuff, 64) ;
	dispPage(fptr) ;
	return fptr ;
    }

    /*
     * save screen
     */
    
    p = linesTop(fptr) ;
    while (p != NULL) {
        kanjiConv(p->line, saveData, p->code) ;
	fprintf(fp, "%s\n", saveData) ;
	p = linesNext(fptr, p) ;
    }
    fclose(fp) ;

    dispPage(fptr) ;

    return fptr ;
}

