/*
 * screen.h - Screen Manager I/F
 */

#ifndef _SCREEN_H
#define _SCREEN_H

/*
 * Screen Control Data
 *
 *  |<------------------- nCols ------------------->|
 *  +-----------------------------------------------+---
 *  |                                               |  A
 *  |                                               |  |
 *  |                                               |  |
 *  |                                               | nLines
 *  |                                               |  |
 *  |                                               |  |
 *  |                                               |  V
 *  +-----------------------------------------------+---
 *  |                                               | Command/Status Line
 *  +-----------------------------------------------+
 */

extern  int     nLines ;    /* Number of Lines      */
extern  int     nCols  ;    /* Number of Columns    */

int     scrInit(char *ename) ;
void    scrDone(void)  ;
void    scrShow(void)  ;
void    scrClear(void) ;
void    scrPutLine(int lin, PUCHAR str) ;
void    scrScrollUp(int n) ;
void    scrScrollDn(int n) ;

PUCHAR  scrEnter(PUCHAR prompt, PUCHAR s, int len) ;

#endif  /* _SCREEN_H */
