/* install.cmd

	Small wrapper script to let GNU install cope with .exe's without rewriting
	all the Makefiles. The first parameter must be the path to GNU install.

	Example of usage:
		install.cmd d:\gnu\bin\install -c -m 755 -o bin -g bin program
*/
program=''

parse arg gnuinstall argv

/* strip symbols? */
dostrip=wordpos('-s',argv)
if dostrip\=0 then
   argv=delword(argv,dostrip,1)	/* don't pass -s to GNU install */

argc=words(argv)
if pos('.',gnuinstall)=0 then gnuinstall=gnuinstall'.exe'
if stream(gnuinstall,'c','query exists')='' then return -1

if (word(argv,argc-1)='ndc') return 0	/* we have a ReXX script instead... */

/* install executable? this test may (often) fail */
if (pos('.',argv)=0) then do
   program=word(argv,argc)'.exe'
   argv=subword(argv,1,argc-2) word(argv,argc-1)'.exe' program	/* assuming the two last parameters are executable and its destination - this may (often) fail */
end

/* run GNU install */
'@'gnuinstall argv
if (rc\=0) then return rc

/* use emxbind to strip symbols */
if (dostrip\=0)&(program\='') then '@emxbind -q -s' program

drop program gnuinstall argv argc dostrip
return rc
