/* SetDefaultWPUrlBrowser.CMD, sample to change default WPUrl browser and working directory (by using SysIni) */

CALL RxFuncAdd 'SysIni','RexxUtil','SysIni'

'@MODE 80,25'
SAY

/* Help, or browser's entered or dropped executable? */

PARSE ARG exe
exe=Strip(exe)
IF Left(exe,1)='-' | Left(exe,1)='/' THEN DO
   SAY
   SAY 'Set default WPUrl browser. This requires OS/2 Warp 4, eCS or ArcaOS, and'
   SAY "a browser which doesn't require the setting LIBPATHSTRICT=T."
   SAY
   SAY "Usage: SetDefaultWPUrlBrowser.CMD [full file path of browser's executable]"
   SAY
   SAY 'Drop or enter the main executable of a browser, execute this in the main'
   SAY 'directory of a (supported) browser, or select a (supported) browser from'
   SAY 'a list.'
   SAY
   CALL CharOut '','Press <ENTER>... '
   PULL .
   EXIT
END
/* Support for CLI long file name */
IF Left(exe,1)='"' THEN PARSE VAR exe '"' exe '"' .
   
IF exe<>'' THEN exe=Stream(exe,'C','QUERY EXISTS')

/* List of upto 23 browsers (single Rexx-word EXEs minus the extension .EXE) */

IF exe='' THEN DO
   browsers='Dooble Firefox Lightweight2 Links Mozilla Netscape Qbrows QtWeb QupZilla SeaMonkey Surfer'

   /* Create table of browsers, find 1st match to avoid dialog (if possible) */

   browser.0=Words(browsers)
   IF browser.0<1 | browser.0>23 THEN DO
      SAY
      SAY 'Error: valid number of supported browsers is 1-23, found' browser.0
      SAY
      CALL CharOut '','Press <ENTER>... '
      PULL .
      EXIT
   END
   DO i=1 TO browser.0
      browser.i=Word(browsers,i)
      IF exe='' THEN exe=Stream(browser.i||'.EXE','C','QUERY EXISTS')
   END i

   /* No match found in current directory? */

   IF exe='' THEN DO
      DO i=1 TO browser.0
         SAY Format(i,2) '-' browser.i
      END i
      SAY
      CALL CharOut '','Please enter the number of a (new) default WPUrl browser? '
      PULL choice
      SAY
      choice=Strip(Translate(choice))     
      IF choice='' THEN EXIT
      IF Pos('E',choice,1)>0 THEN EXIT
      IF DataType(choice,'W')=0 THEN EXIT
      IF choice<1 | choice>browser.0 THEN EXIT
      browser.choice=Translate(browser.choice)||'.EXE'
      CALL CharOut '','Please enter the drive and directory of' browser.choice||'? '
      PULL where
      SAY
      IF Right(where,1)<>'\' THEN where=where||'\'
      exe=where||browser.choice
   END
END

IF Stream(exe,'C','QUERY EXISTS')='' THEN DO
   SAY
   SAY "Error: file" exe "doesn't exist"
   SAY
   CALL CharOut '','Press <ENTER>... '
   PULL .
   EXIT
END

SAY
old1=SysIni('USER','WPURLDEFAULTSETTINGS','DefaultBrowserExe')
old2=SysIni('USER','WPURLDEFAULTSETTINGS','DefaultWorkingDir')
IF old1='ERROR:' | Length(old1)<1 | old2='ERROR:' | Length(old2)<3 THEN DO
   SAY 'Error: cannot query current default settings of WPUrl objects'
   SAY
   CALL CharOut '','Press <ENTER>... '
   PULL .
   EXIT
END
SAY 'Previous default browser setting:' old1
SAY 'Previous working directory      :' old2
SAY

PARSE VALUE Reverse(exe) WITH . '\' where
where=Reverse(where)
new1=SysIni('USER','WPURLDEFAULTSETTINGS','DefaultBrowserExe',exe||D2C(0))
new2=SysIni('USER','WPURLDEFAULTSETTINGS','DefaultWorkingDir',where||D2C(0))
IF new1='ERROR:' | new2='ERROR:' THEN DO
   SAY 'Warning: cannot set all new default settings of WPUrl objects'
   SAY
   CALL CharOut '','Press <ENTER>... '
   PULL .
   SAY
   EXIT
END

old1=SysIni('USER','WPURLDEFAULTSETTINGS','DefaultBrowserExe')
old2=SysIni('USER','WPURLDEFAULTSETTINGS','DefaultWorkingDir')
IF old1='ERROR:' | old2='ERROR:' THEN DO
   SAY 'Error: cannot query updated default settings of WPUrl objects'
   SAY
   CALL CharOut '','Press <ENTER>... '
   PULL .
   EXIT
END
SAY 'New default browser setting:' old1
SAY 'New working directory      :' old2
SAY
CALL CharOut '','Press <ENTER>... '
PULL .

EXIT