; all code by Arcade Gobuzov
; e-mail:  gobuzov@pisem.net  
;          gobuzov@yahoo.com
;--------
RGBSet: MACRO
        dw      \3 << 10 + \2 << 5 + \1
        ENDM
;-----------------------------------conditions
trisafe equ 1
sizeopt equ 1
;-----------------------------------
 include "define.h"
 include "define_rom_sections.h"
 include "define_ram_sections.h"
 include "vars.h"
 include "hiram.asm"
 include "macros.asm"

SECTION  "Startup",Home[0]
 db "m"
SECTION  "ki",home[$0026]
 ld  b,b
 ret

 jr   @-1
SECTION  "funk_",home[$0030]
 ldio [$f1],a
 ld   a,l
 ldio [$ee],a
 jp   Rst30continue
;-------------------------- rst $38     ; waiting Vblank
 ldio a,[$41]
 and  2
 jr   nz,@-4
 ret       

SECTION  "Vertical blank IRQ",home[$0040]
 jp   vblank_int
 ds   6

;SECTION  "LCD IRQ",home[$0048]
 jp   $c6c0
 jp   lcdInt
;------
;                            Header Equates
;Cartridge type:
; 0 - Rom only      3 - ROM+MBC1+RAM+Battery  1 - ROM+MBC1      5 - ROM+MBC2
; 2 - ROM+MBC1+RAM  6 - ROM+MBC2+Battery
CARTTYPE  EQU 0
;Rom Size:
; 0 - 256kBit =  32kB =  2 banks ; 1 - 512kBit =  64kB =  4 banks
; 2 -   1MBit = 128kB =  8 banks ; 3 -   2MBit = 256kB = 16 banks
; 4 -   4MBit = 512kB = 32 banks
ROMSIZE   EQU 1
;Ram Size:
; 0 - None ; 1 -  16kBit =  2kB = 1/4 of  bank
; 3 - 256kBit = 32kB = 4 banks
RAMSIZE   EQU 0         ;
;Manufacturer code (word):
MANUCODE  EQU 1
;Version Number (byte):
VERSION   EQU 1

;-----
;     Do NOT modify unless you are familiar with header info *Modified for Game Boy Color*

SECTION  "Header",home[$0100]
  ;Jumper
  nop
  jp Start              ; go to Start of program:
  ;Nintendo Scrolling Title Graphic
  DB $CE,$ED,$66,$66,$CC,$0D,$00,$0B,$03,$73,$00,$83,$00,$0C,$00,$0D
  DB $00,$08,$11,$1F,$88,$89,$00,$0E,$DC,$CC,$6E,$E6,$DD,$DD,$D9,$99
  DB $BB,$BB,$67,$63,$6E,$0E,$EC,$CC,$DD,$DC,$99,$9F,$BB,$B9,$33,$3E
  ;Title of the game
  db "MARCBLA /GOLD/ ",128 ; Filled in by RGBFIX 
  ;Not used
  db 0,0,0; last should be 3, won't work in emu unles it's 0
  ;Cartridge type:
  db CARTTYPE
  ;Rom Size:
  db ROMSIZE
  ;Ram Size:
  db RAMSIZE
  ;Manufacturer code:
  db 00, $33
  ;Version Number
  db VERSION
  ;Complement check
  db $0a
  ;Checksum
  dw 0

;-----
;          This is the start of the program

;SECTION  "Main", home
;------ jump Table since $150
 dw   CopyHLtoDE        ; $50
 dw   CopyHLtoDEinC     ; $52
 dw   FillHL            ; $54
 dw   FillHLinC         ; $56
 dw   SetBkgPalette     ; $58
 dw   SetObjPalette     ; $5a
;------
Rst30continue:
 ld   a,h
 pop  hl
 ldio [$ffef],a
 ld   a,[hli]
 rra
 jr   nc,@+4
 ld   c,[hl]
 inc  hl
 rra
 jr   nc,@+4
 ld   b,[hl]
 inc  hl
 rra 
 jr   nc,@+4
 ld   e,[hl]
 inc  hl
 rra
 jr   nc,@+4
 ld   d,[hl]
 inc  hl
 rra
 jr   nc,@+7
 push af
 ld   a,[hli]   ; l
 ldio [$ffee],a
 pop  af
 rra
 jr   nc,@+7
 push af
 ld   a,[hli]   ; h
 ldio [$ffef],a
 pop  af
 rra
 jr   nc,@+7
 push af
 ld   a,[hli]   ; a
 ldio [$fff1],a
 pop  af
 rra
 jr   nc,.rs2
 ld   a,[hli]   ; ROM page
 ld   [$2000],a
.rs2
 ld   a,[hli]   ; number in table
 push hl
 ld   h,1
 ld   l,a
 ld   a,[hli]
 ld   h,[hl]
 ld   l,a       ; on $ffed: ld   hl,NN 
 push hl        ;           ld   a,N
 jp   $ffed     ;           ret
; 
LCDoff:
 ld   a,[rIE]
 push af
 res  0,a
 ld   [rIE],a           ; Disable vblank interrupt if enabled

.loop:  
 ld   a,[rLY]           ; Loop until in first part of vblank
 cp   145
 jr   nz,.loop
 xor  a
 ldio [$40],a           ; Turn the screen off
 pop  af
 ld   [rIE],a           ; Restore the state of vblank interrupt
 ret

dmaCode:
 ld   a,MyObjects/256
 ldio [$46],a
 ld   a,$28
dmaWait:
 dec  a
 jr   nz,dmaWait
 pop  af
 reti
 nop
dmaEnd:
;--------------- put something here ---------------/before $0200/--------
SECTION  "a200",home[$0200]
ppy:
 include "tables/ppy.tab"
SECTION  "a400",home[$0400]
MyFnt:                           ; must to be at $xx00
 db $00,$00,$00,$00,$00,$04,$00
 db $00,$6C,$A4,$A4,$A4,$CE,$00
 db $00,$CE,$22,$E6,$82,$EE,$00
 db $80,$8E,$A8,$EE,$22,$2C,$00
 db $00,$6E,$82,$E4,$A4,$C8,$08
 db $00,$66,$AA,$4E,$A2,$CC,$00
 db $04,$0A,$4A,$0E,$08,$46,$00
 db $00,$6C,$AA,$AC,$EA,$AE,$20
 db $00,$6C,$8A,$8A,$8A,$EE,$00
 db $00,$EE,$88,$CC,$88,$E8,$08
 db $02,$EA,$8A,$AE,$AA,$EA,$08
 db $42,$00,$42,$42,$42,$4E,$00
 db $88,$A8,$A8,$C8,$A8,$AE,$20
 db $80,$AC,$EA,$EA,$AA,$AA,$22
 db $00,$CC,$AA,$AA,$AE,$68,$08
 db $00,$EE,$AA,$AC,$AA,$EA,$22
 db $00,$6E,$84,$E4,$24,$C4,$04
 db $82,$AA,$AA,$AA,$AA,$E4,$00
 db $82,$AA,$AA,$E4,$EA,$AA,$28
 db $80,$AE,$A2,$E4,$28,$EE,$00

SECTION  "a500",home[$0500]
fx1:
 db 82,0
 db 15,0,5
 db 13,50,5
 db 11,100,5
 db 9,150,5
 db 7,200,5
 db 5,250,5
 db 3,0,6
 db 1,50,6,0
;
fx2 
 db 100,4
 db 13,150,5
 db 12,100,5
 db 12,50,5
 db 10,0,5
 db 8,200,4
 db 6,150,4
 db 4,100,4
 db 2,50,4,0
;
fx3 
 db 82,2
 db 15,100,3
 db 14,200,3
 db 13,100,2
 db 12,200,2
 db 5,100,1,0
;
fx4 
 db 82,1
 db 15,20,7
 db 14,50,7
 db 13,90,7
 db 12,120,7
 db 11,150,7
 db 10,135,7
 db 9,120,7
 db 8,150,7
 db 7,135,7
 db 6,120,7
 db 5,150,7
 db 4,135,7
 db 3,120,7
 db 2,150,7
 db 1,135,7,0
;
fx5 
 db 82,1
 db 15,10,7
 db 14,0,7
 db 13,10,7
 db 12,30,7
 db 11,60,7
 db 10,40,7
 db 9,10,7
 db 8,30,7
 db 7,60,7
 db 6,40,7
 db 5,10,7
 db 4,30,7
 db 3,60,7
 db 2,40,7
 db 1,10,7,0
;
fx6 
 db 100,4
 db 15,200,5
 db 15,150,5
 db 14,100,5
 db 14,50,5
 db 13,0,5
 db 13,200,4
 db 12,150,4
 db 12,100,4
 db 11,50,4
 db 11,0,4
 db 10,200,3
 db 10,150,3
 db 9,100,3
 db 8,50,3
 db 7,0,3
 db 6,200,2
 db 5,150,2
 db 4,100,2
 db 3,50,2
 db 2,25,2
 db 1,0,2,0
;
fx7 
 db 82,0
 db 15,50,7
 db 14,60,7
 db 13,80,7
 db 12,110,7
 db 11,130,7
 db 10,150,7
 db 9,50,7
 db 8,0,7
 db 7,200,6
 db 6,150,6
 db 5,100,6
 db 4,50,6
 db 3,0,6
 db 2,200,5
 db 1,150,5,0

SECTION  "a800",home[$0800]
pal:
 incbin  "gfx/mypal.pal" 

ppx:
 include "tables/ppx.tab"
Init_dir_tab:
 jp   Ndir

init_dir:
 ld   hl,Init_dir_tab
 ld   [direction],a
FastRun:
 ld   a,[direction]
 ld   e,a
 ld   d,0
 add  hl,de
 jp   [hl]

Ndir:
 ld   b,Ntab/256
setRDir:
 ld   hl,((nZs+1)*(nXs+1))*256+nZs*nXs
setDir:
 ld   a,l
 ld   [curr_dir_ntr],a
 ld   a,h
 ld   [curr_dir_pnts],a
 ld   a,b
 ld   [curr_dir_ttb],a
 ret

;
MyPal:
 RGBSet   8, 27,27    ; light blue
 RGBSet $12,$0d,0     ; brown
 RGBSet $1b,$16, 3    ; yelow
 RGBSet   4,$10, 0    ; green
;--------------------------------------------------
 include "vblank.asm"
 include "lcdc_int.asm"
 include "showbung.asm"
 include "main.asm"
 include "my_rut.asm"
;
 include "my_print.asm"
 include "move_on_map.asm"
 include "fire.asm"
 include "common_gfx.asm"
 include "sound.asm"
 include "get_perspective.asm"
 include "scores.asm"
;
;-------------------------------------------------------- sections ------------
 include "tri_code.asm"
SECTION "map1",CODE,BANK [maps1] ;
 include "maps/map0"
 include "gfxlist.asm"