
   #include <mygba.h>
   #include "modules.h"

   #include "mode7.h"

   Tbkg        bkg;
   Tfactory    factory;
   Theroship   heroship;
   Tshoot      heroshoot[heroShootMax];
   Tshoot      badshoot[badShootMax];
   Tsmoke      smoke[smokeMax];
   Tbad        bad[badMax];
   Tshoot      bonus[bonusMax];

   u16         rnd[256];
   u8          g_FrameCnt;
   bool        g_NewFrame=TRUE;
   u16         Now_Playing=0x00;
   bool        introCall = FALSE;

   void vblGameFunc(void);
   void vblIntroFunc(void);
   void Intro( void );
   void Over( void );
   void Game( void );
   void introCallback( int event, int param);

   int main(void){
      ham_Init();
      kragInit(KRAG_INIT_STEREO);
      // fill random
      u8 i = 255;
      while (i--) rnd[i] = rand();
      ham_StartIntHandler(INT_TYPE_TIM1,&kradInterrupt);
      ham_SetBgMode(2);

      while (1){
         ham_ResetObj();
         Intro();
         Game();
         Over();
         // sorry, dont have a time to make it loop
      }

      return 0;
   }

   void vblGameFunc( void ){
      ham_CopyObjToOAM();
      kramWorker();
      mode7Scroll();
      g_NewFrame=TRUE;
   }

   void vblIntroFunc( void ){
      ham_CopyObjToOAM();
      kramWorker();
      g_NewFrame=TRUE;
   }



// just intro - sorry for this... time runs fast... //
void Intro( void ){

   s8 side=0;  // 0-init, 0-wait, 1-blend, 2-clear
   u8 pic=0;
   bool fin=FALSE;

   ham_StartIntHandler(INT_TYPE_VBL, (void*)vblIntroFunc);
   krapPlay(&mod_muzintro,KRAP_MODE_LOOP,Now_Playing);

   paletteInit(1);
   picInit(2);
   picInit(3);

   while(!fin){
      if(g_NewFrame){
         switch (side){
            case 0: // init first pic
               ham_StartIntHandler(INT_TYPE_HBL, (void*)mode7main);
               krapCallback( introCallback );
               picShow(pic++, 2);
               paletteInit(0);
               side=1;
               break;
            case 1: // wait pic
               if ( introCall == TRUE ){ side=2; introCall=FALSE; }
               break;
            case 2: // fade out pic
               if (bkg.Y < 12) bkg.Y++;
               else side=3;
               break;
            case 3: // show next pic
               if (pic<4){
                  picShow(pic++, 2);
                  side=4;
               } else {
                  side=5;
               }
               break;
            case 4: // fade in pic
               if (bkg.Y>0) bkg.Y--;
               else side=1;
               break;
            case 5: // intro pic show
                  side=6;
                  paletteInit(1);
                  ham_StartIntHandler(INT_TYPE_HBL, (void*)dummyFunc);
                  krapCallback( NULL );
                  REG_BG2X = 0;
                  picShow(6, 3);
                  picShow(5, 2);
                  paletteInit(0);
               break;
            case 6:
               break;
         }
         if (F_CTRLINPUT_A_PRESSED || F_CTRLINPUT_B_PRESSED || F_CTRLINPUT_START_PRESSED){
            fin=TRUE;
         }
         g_NewFrame=FALSE;
      }
      
   }
   krapStop(Now_Playing);
   paletteInit(1);
   picDeInit(2);
   picDeInit(3);
}

void introCallback( int event, int param ){
   introCall=TRUE;
}


// game //
void Game( void ){
   ham_StartIntHandler(INT_TYPE_VBL, (void*)vblGameFunc);
   ham_StartIntHandler(INT_TYPE_HBL, (void*)dummyFunc);
   krapPlay(&mod_muzingame,KRAP_MODE_LOOP,Now_Playing);


   bkgInit();
   bool gameOn = TRUE;

   heroShipPreInit();

   shipIntroInit();

   factoryInit();

   while( gameOn ) {
      if( g_NewFrame ) {

         gameOn = shipIntroElapse();

         g_NewFrame=FALSE;
         g_FrameCnt++;
      }
   }
   shipIntroDeInit();

   heroShipInit();
   heroShootInit();
   ham_StartIntHandler(INT_TYPE_HBL, (void*)hblGameFunc);

   bkg.waveMarkPlace = 0;
   bkg.waveCurMark = 0;
   bkg.waveSlot = 0;
   bkg.waveTime = 0;

   gameOn = TRUE;
   while( gameOn ) {
      if( g_NewFrame ) {
         if ( F_CTRLINPUT_UP_PRESSED )                      heroship.speedY-=16;
         else if ( F_CTRLINPUT_DOWN_PRESSED )               heroship.speedY+=16;
         if ( F_CTRLINPUT_RIGHT_PRESSED )                   heroship.speedX+=16;
         else if ( F_CTRLINPUT_LEFT_PRESSED )               heroship.speedX-=16;
         if ( F_CTRLINPUT_B_PRESSED )                       { heroship.pheroShootF(); heroship.shootCnt++; }
         else                                               { heroship.fireB = FALSE; heroship.shootCnt = 0; }

         gameOn = eventFactory();

         // elapse //
         heroShipElapse();
         badElapse();
         heroShootElapse();
         badShootElapse();
         smokeElapse();
         bonusElapse();

         mode7ScrollUpdate();
         
         g_NewFrame=FALSE;
         g_FrameCnt++;
      }
   }
   ham_StartIntHandler(INT_TYPE_VBL, (void*)dummyFunc);
   ham_StartIntHandler(INT_TYPE_HBL, (void*)dummyFunc);

   paletteInit(1);

   REG_BG2X = 0;
   REG_BG2Y = 0;
   REG_BG3X = 0;
   REG_BG3Y = 0;
   krapStop(Now_Playing);
   picDeInit(2);
   picDeInit(3);
   ham_ResetObj();
}


void Over( void ){

   bool fin=FALSE;

   krapPlay(&mod_muzover,KRAP_MODE_LOOP,Now_Playing);

   paletteInit(1);
   picInit(2);
   picInit(3);

   ham_StartIntHandler(INT_TYPE_VBL, (void*)vblIntroFunc);
   ham_StartIntHandler(INT_TYPE_HBL, (void*)dummyFunc);

   picShow(6, 3);
   picShow(8, 2);
   paletteInit(0);

   while(!fin){
      if(g_NewFrame){
         if (F_CTRLINPUT_START_PRESSED){
            //fin=TRUE;
         }
         g_NewFrame=FALSE;
      }
   }
   ham_StartIntHandler(INT_TYPE_VBL, (void*)dummyFunc);
   ham_StartIntHandler(INT_TYPE_HBL, (void*)dummyFunc);

   krapStop(Now_Playing);
   paletteInit(1);
   picDeInit(2);
   picDeInit(3);
}



   /* END OF FILE */

