﻿//Joku shader-efekti juttu


var Snowflake = function(duration, startTime, endTime){
  //kantaluokan rakentajan kutsu
  PartBase.call(this, duration, startTime, endTime);
}

Snowflake.prototype = PartBase.prototype.inheritance();

//scene is initialized before demo starts
Snowflake.prototype.initScene = function(){
  
  //some min and max values
  this.minX = -TDEMO.width/2;
  this.maxX = TDEMO.width/2;
  this.minY = -TDEMO.height/2;
  this.maxY = TDEMO.height/2;
  
  //MAIN SCENE
  this.scene = new THREE.Scene();
  this.camera = new THREE.OrthographicCamera(this.minX, this.maxX, this.maxY, this.minY);
  this.camera.position.z = 1;
  this.scene.add(this.camera);
  
  this.uniforms =  {
    time : {type : "f", value: 0.0},
    resolution : {type : "v2", value: new THREE.Vector2(TDEMO.width, TDEMO.height)}
  };
  
  var planeMaterial = new THREE.ShaderMaterial({
      uniforms: this.uniforms,
      vertexShader: document.getElementById( 'basic_vertex' ).textContent,
      fragmentShader: document.getElementById( 'snowflake_fragment' ).textContent
  });
  
  this.plane = new THREE.Mesh(new THREE.PlaneGeometry(TDEMO.width, TDEMO.height), planeMaterial);  
  this.scene.add(this.plane);
}

//rendering function
Snowflake.prototype.render = function(elapsedTime){
  TDEMO.renderer.render(this.scene, this.camera);
}

Snowflake.prototype.prepare = function(elapsedTime){
  this.startTime = elapsedTime;
}

//Operations tahta takes place before rendering in every cycle
Snowflake.prototype.animate = function(elapsedTime){
  this.uniforms.time.value = ((elapsedTime-this.startTime)*1.5);
}

