alias dmDrawFrame {
    set %dm.c $calc($ticks - %dm.ticks.main)
    inc %dm.fps.count
    if ($calc($ticks - %dm.fps.ticks.start) >= 1000) {
        set %dm.fps.current %dm.fps.count
        set %dm.fps.count 0
        set %dm.fps.ticks.start $ticks
    }
    drawdot @demo
    if (%dm.fs == 1) {
        drawcopy @demo 0 0 320 180 @demo.fs 0 0 %dm.fs.w %dm.fs.h
    }
    drawrect -nrf @demo 0 0 0 0 320 180
    .timerdmDrawFrame -tmh 1 0 noop $!dmStartDraw( $1 )
    set %dm.frt $calc(%dm.c - %dm.frt.start)
}


alias dmStartDraw {
    set %dm.frt.start %dm.c
    $1
}

alias ph3 {
    dmInit fs
}

alias dmInit {
    window -dak0pfboB +b @demo 1280 0 320 180
    if ($1 == fs) {
        set %dm.fs.w $window(-1).w
        set %dm.fs.h $window(-1).h
        window -dak0pfBbo +d @demo.fs 0 0 %dm.fs.w %dm.fs.h
        set %dm.fs 1
    }
    window -dk0pfh   @dm.copper.1     0 0 320 180
    drawrect -nrf    @dm.copper.1 0 0 0 0 320 180
    window -dk0pfh   @dm.copper.2     0 0 320 180
    drawrect -nrf    @dm.copper.2 0 0 0 0 320 180
    window -dk0pfh   @dm.copper.3     0 0 320 180
    drawrect -nrf    @dm.copper.3 0 0 0 0 320 180
    set %dm.copperCtab 14591489 14262019 13866757 13471239 12944137 12482572 11955215 11428371 10966551 10505244 10109474 9779754 9450290 9252413 9185610 9119065 9183849 9183355 9248140 9247645 9312943 9312447 9312462 9181146 9115365 8787692 8460011 8066795 7542507 7018219 6428395 5904107 5314283 4790507 4266987 3809259 3417579 3091691 2897644 2966255 2970355 2909176 2979325 2918653 2989052 2928381 2998268 3002109 3005437 3007997 3009019 3140078 3271133 3532746 3793331 3987867 4247682 4507240 4766800 5026617 5221156 5350418 5545732 5215232 5545216 5480715 5285914 5156654 4896836 4571740 4377461 4117902 3857831 3597502 3402196 3205606 3074549 3008765 3006973 2938365 3000316 2996221 2991356 2986749 2981885 2977018 2906869 2968306 2964461 2961899 3221739 3613419 4005099 4528619 5052395 5576427 6166251 6756075 7280363 7804651 8263403 8656619 8918761 9181152 9312212 9377991 9312695 9312934 9247893 9182851 9183345 9118562 9185106 9251652 9383991 9582382 9911846 10307359 10703129 11164436 11691792 12219150 12746250 13207560 13668870 14064388 14459650 13868800
    var %cnt 1
    while (%cnt <= 180) {
        drawline -r @dm.copper.1 $gettok(%dm.copperCtab, $calc(%cnt * 1.4), 32) 1 0 $calc(%cnt * 2) 320 $calc(%cnt * 2)
        inc %cnt
    }
    set %dm.sinescrollScrollX 340
    speak -sp 10 90 Hallo, Digital Sounds System here, bringing you a 4k compofillin' partyhack, why? Because we can, finally a proper sine scroller. consider this a preview of better things to come in the near future. Using text-to-speech because no time to do music and because it's fun... .. . Knoeki signing off...
    set %dm.ticks.main $ticks
    set %dm.fps.ticks.start $ticks
    set %dm.fps.count 0
    demo_copper
}

alias dinc {
    inc $+(%,$1) $calc(%dm.frt * $2)
}

alias ddec {
    dec $+(%,$1) $calc(%dm.frt * $2)
}

on *:CLOSE:@demo*: {
    splay stop
    drawpic -c
    speak -c
    unset %dm.*
}

alias demo_copper {
    drawcopy -n @dm.copper.1 0 0 320 180 @demo 0 0 320 180
    drawrect -nrf @dm.copper.2 0 0 0 0 320 180
    var %text Hallo! Digital Sounds System here, bringing you a 4k compofillin' partyhack... .. . why? Because we can... finally a proper sine scroller... consider this a preview of better things to come in the near future. Using text-to-speech because no time to do music and because it's fun... .. . Knoeki signing off...
    drawtext -nr @dm.copper.2 12632256 impact 48 %dm.sinescrollScrollX 45 %text
    ddec dm.sinescrollScrollX .13
    var %x 1
    var %s 4
    while (%x < 320) {
        var %sin $calc(($sin($calc((%dm.c / 4) + %x)).deg * 32) + ($sin($calc(%dm.c / 8)).deg * 32) + 50)
        drawcopy -n @dm.copper.2 %x 45 %s 64 @dm.copper.3 %x %sin %s 64
        inc %x %s
    }
    drawcopy -nt @dm.copper.3 12632256 0 0 320 180 @demo 0 0 320 180
    dmDrawFrame demo_copper
}