
.include "fb32x32.inc"

.include "globals.inc"

xp       := localram+0
yp       := localram+1
mp       := localram+2

myschedule:


.segment "CODE"

kaleidoscope:
   lda   frmcnt+0
   ora   frmcnt+1
   bne   @initdone

   ldx   #$00
:
   stz   FRAMEBUFFER,x
   inx
   bne   :-

.if 0
   lda   #$01
   sta   FB32X32_CCOLMAP_IDX

@colorloop:
   txa
   and   #$04
   beq   :+
   lda   #$0f
:
   sta   FB32X32_CCOLMAP_R
   txa
   and   #$02
   beq   :+
   lda   #$0f
:
   sta   FB32X32_CCOLMAP_G
   txa
   and   #$01
   beq   :+
   lda   #$0f
:
   sta   FB32X32_CCOLMAP_B
   inx
   bne   @colorloop

   lda   #$01
   sta   FB32X32_COLMAP
.else
   lda   #FB32X32_CMAP_VDC
   sta   FB32X32_COLMAP
.endif

   sta   xp
   sta   yp
   sta   mp

.if 0
   jsr   flip16to32
   jmp   show4fb
.endif

@initdone:
   ldx   #$00

@loop:
   ; yp += (xp>>2) & mp
   lda   xp
   lsr
   lsr
   and   mp
   clc
   adc   yp
   sta   yp

   ; xp -= (yp>>2) & mp
   lda   yp
   lsr
   lsr
   and   mp
   eor   #$ff
   sec
   adc   xp
   sta   xp

   ;lda   xp
   lsr
   lsr
   lsr
   lsr
   sta   tmp8
   lda   yp
   and   #$f0
   ora   tmp8
   tay

   txa
   and   #$01
   beq   :+
   txa
   lsr
:
   sta   FRAMEBUFFER,y

   inx
   cpx   #$10
   bcc   @loop

   lda   frmcnt+1
.if SHORTEST
   cmp   #$01
.else
   cmp   #$02
.endif
   bcc   :+
   jsr   schedulenext
:

   inc   xp
   inc   yp
   inc   mp
   jsr   flip16to32
   jmp   show4fb
.out .sprintf("kaleidoscope: $%04x", *-kaleidoscope)
