#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <process.h>
#include <share.h>
#include <dir.h>
#include <dos.h>
#include <string.h>
#include <errno.h>
#include <conio.h>
#include <time.h>
#include <math.h>
#include "scopy.h"

#define VGAPTR          ((unsigned int far*)0xb8000000)  /* video base */

#define BUFFERSIZE	32767

#define VERSION		"2.0"

#define ClrStatusLine   memset(&(VGA_screen[4+8*80]),0x2000,140)
#define ClrName         memset(&(VGA_screen[10+5*80]),0x2000,30)
#define ClrPathSrc      memset(&(VGA_screen[35+2*80]),0x2000,80)
#define ClrPathDest     memset(&(VGA_screen[35+3*80]),0x2000,80)

int ProcessFile(char  *, char *, char *);
void Usage(void);

unsigned int far* VGA_screen = VGAPTR;
char *Buffer;
short	Skip;

//------------------------------------------------------//
//                                                      //
// MAIN procedure                                       //
//                                                      //
//                                                      //
//------------------------------------------------------//
int main(int argc, char *argv[])
{
char PathSrc[_MAX_PATH];
char PathDest[_MAX_PATH];
char dir[_MAX_DIR];
char path[_MAX_PATH];
int  directvideo;
int	 done;
int  Files;
struct find_t ffblk;

directvideo = 1;
Files=0;

printf("SHARE COPY v%s coded by Gandalf/AEGIS\n\n",VERSION);

if(argc!=3 && argc!=4)
	Usage();
else if(argc==4)
	{
	strupr(argv[3]);
	if(strcmp(argv[3],"/S")==0)
		Skip=1;
	else
		Usage();
	}
else
	Skip=0;

clrscr();
memcpy(VGA_screen,SCREEN,4000*sizeof(unsigned char));

if( (Buffer=(char *)malloc(sizeof(char)*BUFFERSIZE))==NULL)
  {
  ClrStatusLine;
  gotoxy(6,9);
  textcolor(0x04);
  cprintf("\007Memory allocation Error");
  gotoxy(1,13);
  exit(-1);
  }

_splitpath(argv[1],dir,path,NULL,NULL);
sprintf(PathSrc,"%s%s",dir,path);

if(access(PathSrc,0)!=0)
  {
  ClrStatusLine;
  gotoxy(6,9);
  textcolor(0x04);
  cprintf("\007%s path not found",PathSrc);
  gotoxy(1,13);
  exit(-1);
  }

strupr(PathSrc);
_fullpath(PathDest,argv[2],_MAX_PATH);
strupr(PathDest);

done = _dos_findfirst(argv[1],_A_NORMAL,&ffblk);
while (done==0)
  {
  if(ProcessFile(PathSrc,ffblk.name,PathDest)==1)
	  Files++;
  done = _dos_findnext(&ffblk);
  }

gotoxy(1,13);
printf("%d Files copied\n",Files);
return 0;
}

//-------------------------------------------------------------------------
int ProcessFile(char *RepSrc, char *FileSrc, char *RepDest)
{
int  NumBytes;
int  NumBytesWr;
int  HandleSrc;
int  HandleDest;
int  status;
char PathDest[_MAX_PATH];
char PathSrc[_MAX_PATH];
struct tm *tm;
struct stat FileStat;
unsigned attrib;
struct dfree FreeDisk;
long	Avail;
long	Copied;

if(RepSrc[strlen(RepSrc)-1]=='\\')
  RepSrc[strlen(RepSrc)-1]='\000';
sprintf(PathSrc,"%s\\%s",RepSrc,FileSrc);

HandleSrc = sopen(PathSrc, O_RDONLY|O_BINARY, SH_DENYNO, S_IREAD);
if (HandleSrc==-1)
   {
   ClrStatusLine;
   gotoxy(6,9);
   textcolor(0x04);
   cprintf("\007%s:%s",PathSrc,sys_errlist[errno]);
   return 0;
   }

stat(PathSrc,&FileStat);
gotoxy(11,3);
textcolor(0x07);
cprintf("%6lu kb",FileStat.st_size/1024);
gotoxy(11,4);
tm=localtime(&((time_t)FileStat.st_atime));
cprintf("%02d/%02d/%02d  %02d:%02d",tm->tm_mday+1,tm->tm_mon+1,tm->tm_year,tm->tm_hour,tm->tm_min);
_dos_getfileattr(PathSrc,&attrib);
gotoxy(11,5);
cprintf("%s%s%s%s",(attrib & _A_ARCH)?"A":"-",
				   (attrib & _A_RDONLY)?"R":"-",
				   (attrib & _A_SYSTEM)?"S":"-",
				   (attrib & _A_HIDDEN)?"H":"-");

ClrName;
gotoxy(11,6);
cprintf("%s",FileSrc);

getdfree(RepDest[0]-'A'+1,&FreeDisk);
Avail =  (long) FreeDisk.df_avail*(long) FreeDisk.df_bsec*(long) FreeDisk.df_sclus;
if(Avail<FileStat.st_size)
   {
   ClrStatusLine;
   gotoxy(6,9);
   textcolor(0x04);
   cprintf("\007Not enough place on target drive, skipping...");
   close(HandleSrc);
   return 0;
   }

if(RepDest[strlen(RepDest)-1]=='\\')
  RepDest[strlen(RepDest)-1]='\000';
sprintf(PathDest,"%s\\%s",RepDest,FileSrc);
if(access(PathDest,0)==0)
	{
	if(Skip==0)
		HandleDest = open(PathDest, O_WRONLY|O_TRUNC|O_BINARY, S_IWRITE);
	else
		{
		ClrStatusLine;
		gotoxy(6,9);
		textcolor(0x04);
		cprintf("File already exist. Skipping...");
		return 0;
		}
	}
else
	HandleDest = open(PathDest, O_WRONLY|O_CREAT|O_BINARY, S_IWRITE);

if (HandleDest==-1)
   {
   ClrStatusLine;
   gotoxy(6,9);
   textcolor(0x04);
   cprintf("\007%s:%s",PathDest,sys_errlist[errno]);
   close(HandleSrc);
   return 0;
   }

status = access(PathSrc, 6);
if (status != 0)
   {
   ClrStatusLine;
   gotoxy(6,9);
   textcolor(0x04);
   cprintf("\007Read access not allowed, skipping...");
   close(HandleSrc);
   close(HandleDest);
   return 0;
   }

ClrPathSrc;
gotoxy(36,3);
textcolor(0x07);
cprintf("%s",PathSrc);
ClrPathDest;
gotoxy(36,4);
textcolor(0x07);
cprintf("%s",PathDest);

ClrStatusLine;
gotoxy(6,9);
textcolor(0x0F);
cprintf("Copying...");

ClrStatusLine;
textcolor(0x0F);
gotoxy(6,9);
cprintf("bytes copied:         0");
Copied=0L;
while( (NumBytes=read(HandleSrc,Buffer,BUFFERSIZE))!=0)
  {
  NumBytesWr=write(HandleDest,Buffer,NumBytes);
  if(NumBytes!=NumBytesWr)
	 {
	 ClrStatusLine;
	 gotoxy(6,9);
	 textcolor(0x04);
	 cprintf("\007Error while writing file, skipping...");
	 close(HandleSrc);
	 close(HandleDest);
	 return 0;
	 }
  Copied+=NumBytes;
  gotoxy(20,9);
  cprintf("%9ld",Copied);
  }

ClrStatusLine;
gotoxy(6,9);
textcolor(0x0F);
cprintf("Done");

close(HandleSrc);
close(HandleDest);
return 1;
}

//------------------------------------------
void Usage(void)
{
  printf("usage: scopy <source files> <destination path> [/s]\n");
  printf("\t\t /s: skip if file already exist\n");
  exit(-1);
}