#ifndef _STRING_h_
#define _STRING_h_

#include <iostream.h>
#include <string.h>  /* ansi C string */

class String
{
public:
  String();                   /* constructor */
  String(const String& s);    /* copy constructor */
  String(const String& s, int len);
  String(const char* str);
  String(const char* str, int len);
  String(int size);

  String& operator=(const String& s);  /* assignment operator */
  String& operator=(const char *s);    /* assignment operator */

  operator char*() const
    { return mpString; };          /* as a C-string */

  int operator!() const;           /* if-not (empty) operator */

  char operator[](int num) const
    { return mpString[num]; };

  /* compare */
  friend bool operator==(const String& s1, const String& s2)
    { return (strcmp(s1.mpString, s2.mpString) == 0); };
  friend bool operator!=(const String& s1, const String& s2)
    { return (strcmp(s1.mpString, s2.mpString) != 0); };

  friend ostream& operator<<(ostream& os, String& s);

  friend String operator+(const String& s1, const String& s2);

  String& operator+=(const String& s);
  String& operator+=(const char *s);

  ~String();                 /* destructor */

  int Format(const char* format, ...); /* sprintf format */

  int GetLength() const
    { return mLength; };     /* get length of string */

  bool IsEmpty() const
    { return mLength == 0; };  /* is string empty? */

  int GetWordCount() const;  /* get num of words in string */
  String GetWord(int wordnum);

protected:
private:
  int mLength;
  char* mpString;
};

#endif /* _STRING_h_ */
