/* motherlist class, en generisk klasse til strenge-lister, af flower.
 * 
 * efterhnden ret vildt udbygget med alle mulige mystiske funktioner :/
 * efterhnden ogs ret dokumenteret :))
 * 
 * "motherlist" strukturen.
 * 
 * add(char *str, int i);	# tilfjer strengen str til listen med
 *				# index-# i.
 * char *get(int i);		# returnerer ptr til strengen i listen med
 * 				# index-# i.
 * char *pop();			# "popper" den frste streng i listen.
 * int count();			# tller antal af strenge i liste.
 *
 * desuden nogle funktioner til snoope i listen. alle funk refererer
 * til en "snoop" pointer, som er et vilkaarligt sted i listen.
 *
 * int last();			# checker om man er ved sidste post.
 * int next();			# flytter snoop pointer til naeste post.
 * int prev();			# flytter snoop pointer til forrige post.
 * char *peek();		# returnerer strengen ved snoop pointeren.
 * reset();			# nulstiller snoop pointeren.
 *				# reset MAA kaldes f0r man bruger de andre
 *				# snoop funktioner, eller funger de ikke.
 * strlist *snoop()		# returnerer ptr til strlist struk. BRUG IK'
 * set_snoop(strlist *l)	# saetter snoop-ptr. BRUG IKKE!!
 * int count_range(strlist *l1,strlist *l2)
 *				# tller antal af poster mellem l1 og l2.
 *				# BEM! l1 er den frste ptr i listen.
 */

#include <stdlib.h>

class strlist {
	char *line;
	int index;
	strlist *next;
	strlist *prev;
	strlist *upper;
	strlist *lower;
public:
	strlist(char *s,int i) {
		if (s!=NULL) {
			line=new char[strlng(s)+1];
			strcopy(line,s);
		} else
			line=NULL;
		index=i;
		upper=lower=prev=next=NULL;
	}
	~strlist() {
		delete line;
	}
	void setnext(strlist *n) { next=n; }
	void setprev(strlist *p) { prev=p; }
	strlist *getnext() { return next; }
	strlist *getprev() { return prev; }
	strlist *getupper() { return upper; }
	strlist *getlower() { return lower; }
	void setline(char *s) {
		if (line!=NULL) delete line;
		line=new char[strlng(s)+1];
		strcopy(line,s);
	}
	char *getline() { return line; }
	int getindex() { return index; }
};

class motherlist {
	strlist *head,*tail;
	strlist *cur;
public:
	motherlist() {
		head=tail=cur=NULL;
	}
	void add(char *str,int i);
	char *get(int i);
	char *pop();
	int count();
	void reset() { cur=head; }
	void reset_back() { cur=tail; }
	int next() {
		if (cur!=NULL)
			if (cur->getnext()!=NULL) {
				cur=cur->getnext();
				return 1;
			} else
				return 0;
		else
			return 0;
	}
	int prev() {
		if (cur!=NULL)
			if (cur->getprev()!=NULL) {
				cur=cur->getprev();
				return 1;
			} else
				return 0;
		else
			return 0;
	}
	int upper() {
		if (cur!=NULL)
			if (cur->getupper()!=NULL) {
				cur=cur->getupper();
				return 1;
			} else
				return 0;
		else
			return 0;
	}
	int lower() {
		if (cur!=NULL)
			if (cur->getlower()!=NULL) {
				cur=cur->getlower();
				return 1;
			} else
				return 0;
		else
			return 0;
	}
	char *peek() { if (cur!=NULL) return cur->getline(); }
	int last() { return (cur==NULL); }
	strlist *snoop() { return cur; }
	void set_snoop(strlist *l) { cur=l; }
	int count_range(strlist *l1,strlist *l2);
	int count_range(strlist *l1,strlist *l2,int dir);
};

int motherlist::count_range(strlist *l1,strlist *l2) {
	int ret=0;
	strlist *t=l1;

	while ((t!=l2)&&(t!=NULL)) {
		t=t->getnext();
		ret++;
	}
	return ret;
}

int motherlist::count_range(strlist *l1,strlist *l2,int dir) {
	int ret=0;
	strlist *t=l1;

	while ((t!=l2)&&(t!=NULL)) {
		if (dir)
			t=t->getnext();
		else
			t=t->getlower();
		ret++;
	}
	return ret;
}

void motherlist::add(char *str,int i) {
	if ((str!=NULL)) {
		strlist *t=new strlist(str,i);
		if (head==NULL) 
			head=tail=t;
		else {
			tail->setnext(t);
			t->setprev(tail);
			tail=t;
		}
	}
}

char *motherlist::get(int i) {
	strlist *t=head;
	char *r=NULL;

	while (t!=NULL) {
		if (t->getindex()==i) {
			r=t->getline();
		}
		t=t->getnext();
	}
	return r;
}

char *motherlist::pop() {
	strlist *t=head;
	char *r;
	
	if (head!=NULL) {
		if ((head->getline())!=NULL) {
			r=(char*)malloc(strlng(head->getline())+1);
			strcopy(r,head->getline());
			head=head->getnext();
			free(t);
			return r;
		}	
	} else
		return NULL;
}

int motherlist::count() {
	strlist *t=head;
	int i=0;

	while (t!=NULL) {
		i++;
		t=t->getnext();
	}
	return i;
}
