/* shared mem og semafor ops til muggichatteren, af flower.
 *
 * indeholder to klasser: sem og shmem, sem er ikke saa spaendende, men
 * bruges af shmem.
 * 
 * shmem klassen's public-del:
 *
 * int isupdated()		# checker om det shared mem er blevet opdateret.
 * add(int c,int n)		# tilfjer ny besked i det sharede mem.
 * int get(int *c,int *n)	# henter besked fra sharede mem.
 *
 * nb. brug ALTID isupdated() fr get(). eg.
 *
 * while (!isupdated())
 *	get(a,b);
 *
 */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include "semop.h"
#include "muggiconfig.h"

/* dont mess with these unless you know what you're doing, shm pool
 * and synchronization variables.					*/

#define	SHMKEY	((key_t) 4711)
#define SHMSEMKEY ((key_t) 7913)
#define	PERMS	0600
#define SHMSIZE	(sizeof(mesgpool)+2)

struct userinfo {
	int u_actuallyhere;
	char u_handle[30];
	char u_group[30];
	long u_signon;
};

struct mesgpool {
	int pos;
	struct userinfo users[MAXNODES];

	int queue[QUEUELEN];
};

class semaphore {
	int semid;
public:
	semaphore() {
		if ((semid=sem_create(SHMSEMKEY,1))<0) {
			cout << "cant create semaphor\n";
			exit(200);
		}
	}
	~semaphore() { sem_close(semid); }
	void enter() { sem_wait(semid); }
	void leave() { sem_signal(semid); }
};

class shmem {
	int shmid;
	mesgpool *pool;
	int poolposition;
	semaphore shsem;
public:
	shmem();
	~shmem();
	int isupdated();
	void add(int n,int c);
	void get(int *n,int *c);
	void u_set(int n,userinfo *u);
	userinfo *u_get(int n);
};

shmem::shmem() {
	int created=1;

	if ((shmid=shmget(SHMKEY,SHMSIZE,PERMS|IPC_CREAT|IPC_EXCL))<0)
		if ((shmid=shmget(SHMKEY,SHMSIZE,0))<0) {
			cout << "cant get shared mem\n";
			exit(100);
		}
	else
		created=0;
	if ((pool=(mesgpool *)shmat(shmid,(char *)0,0))<0) {
		cout << "cant attach shared mem\n";
		exit(101);
	}
	shsem.enter();
	if (created) {
		poolposition=pool->pos=0;
		bzero(pool,sizeof(struct mesgpool));
	} else
		poolposition=pool->pos;
	shsem.leave();
}

shmem::~shmem() {
	shsem.enter();
	if (shmdt((char *)pool)<0)
		cout << "cant detach shared mem\n";
	if (shmctl(shmid,IPC_RMID,(struct shmid_ds *)0)<0)
		cout << "cant remove shared mem\n";
	shsem.leave();
}

int shmem::isupdated() {
	int tmppos;

	shsem.enter();
	tmppos=pool->pos;
	shsem.leave();
	return (tmppos==poolposition);
}

void shmem::add(int n,int c) {

	shsem.enter();
	pool->queue[pool->pos++]=n;
	pool->queue[pool->pos++]=c;
	if (pool->pos>QUEUELEN) pool->pos=0;
	shsem.leave();
}

void shmem::get(int *n,int *c) {

	shsem.enter();
	*n=pool->queue[poolposition++];
	*c=pool->queue[poolposition++];
	shsem.leave();

	if (poolposition>QUEUELEN) poolposition=0;
}

void shmem::u_set(int n,userinfo *u) {

	shsem.enter();
	memcpy(&(pool->users[n]),u,sizeof(struct userinfo));
	shsem.leave();
}

userinfo *shmem::u_get(int n) {
	userinfo *r;
	
	shsem.enter();
	r=&(pool->users[n]);
	shsem.leave();
	return r;
}
