/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	sia.h,v $
 * Revision 1.1.2.3  92/03/26  16:51:40  William_Brown
 * 	"SIA the sequel"
 * 
 * Revision 1.1.4.9  92/03/26  14:11:22  William_Brown
 * 	pre submit checkin
 * 
 * Revision 1.1.4.8  92/03/24  20:34:48  William_Brown
 * 	baker check-in for ag.latest merge
 * 
 * Revision 1.1.4.7  92/03/13  17:42:09  William_Brown
 * 	pre-build check in
 * 
 * Revision 1.1.4.6  92/03/11  19:59:52  William_Brown
 * 	3/11/92 test checkin
 * 
 * Revision 1.1.4.5  92/03/10  20:22:01  William_Brown
 * 	test check in 3/10/92
 * 
 * Revision 1.1.4.4  92/03/09  18:02:59  William_Brown
 * 	SIA resubmit build
 * 
 * Revision 1.1.4.3  92/03/03  21:34:41  William_Brown
 * 	pre-build check in #2
 * 
 * Revision 1.1.4.2  92/03/03  15:35:14  William_Brown
 * 	pre-build checkin
 * 
 * Revision 1.1.2.2  92/02/14  15:23:06  John_Williams
 * 	for pre-submit build
 * 	[92/02/14  11:01:33  John_Williams]
 * 
 * 	Initial SIA submit
 * 	[92/02/13  15:27:07  John_Williams]
 * 
 * 	<<<initial checkin>>>
 * 	[91/11/15  17:41:57  John_Williams]
 * 
 * $EndLog$
 */
/***** Until this works its commented out dupdef in Date variable
***#ifndef lint
***static char *rcsid = "@(#)$RCSfile: sia.h,v $ $Revision: 1.1.2.3 $ (DEC) $Date: 92/03/26 16:51:40 $";
***#endif
***************/
/***********************************************************************
*	sia.h - SIA constants, structures, and macro definitions 
************************************************************************/
#ifndef _SIA_H_
#define _SIA_H_

/***** sia common sys includes **/

#include <sys/param.h>
#include <sys/quota.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/sysinfo.h>
#include <sys/utsname.h>
#include <sys/sem.h>
#include <sys/uio.h>

/***** sia common usr includes **/

#include <fcntl.h>
#include <sgtty.h>
#include <utmp.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>
#include <stdio.h>
#include <lastlog.h>
#include <errno.h>
#include <ttyent.h>
#include <syslog.h>
#include <limits.h>
#include <strings.h>
#include <unistd.h>
#include <cma.h>
#include <pthread.h>
#include <loader.h>
#include <nl_types.h>

/**** sia logical definitions ****/

#define NULL 0
#define YES 1
#define NO 0
#define TRUE 1
#define FALSE 0

/**** sia library and filenames ****/

#define SIALOGFILE      "/var/adm/sialog"          /* SIA logging file        */
#define SIAIGOODFILE    "/etc/sia/siainitgood"     /* sia init good file flag */
#define MATRIX_CONF     "/etc/sia/matrix.conf"     /* sia matrix config file  */
#define SIALIBCSO       "libc.so"                  /* local security in libc  */

/***** sia limits ***********/

#define SIABUFSIZ       1024    /* buffer size for loginname, password, and   */
                                /* one line of the SIA matrix config file     */
#define SIAPKGNAMAX     64      /* Libsia packagename maximum size            */
#define SIALIBNAMAX     64      /* Libsia packagename maximum size            */
#define SIADCAPMAX      32      /* max sec mech sia capabilities              */
#define SIASWMAX        4       /* max switches per capability                */
#define SIAMUTMAX       16      /* number mutexes utilized by SIA             */
#define SIAMXACCTNAME   64      /* maximum size of an account name            */
#define SIAMXPASSWORD   64      /* maximum size of a password                 */
#define SIANAMEMIN      16      /* minimum space allocated for entity->name   */


/***** sia entity structure *******/ 

typedef struct siaentity {
                        char *name;             /* collected name             */
			char *password;         /* entered or collected password */
                        char *acctname;         /* account name               */
                        char **argv;            /* calling command argument   */
                                                /* strings                    */
                        int  argc;              /* number of arguments        */
                        char *hostname;         /* requesting host NULL=>local*/
                        char *tty;              /* pathname of local tty      */
                        int colinput;           /* 1 => yes 0 => no input     */
                        int error;              /* error message value        */
                        int authcount;          /* Number of consecutive      */
                                                /* Failed authen attempts     */
                        int authtype;           /* Type of last authent       */
                        struct passwd *pwd;     /* pointer to pwent struct    */
			char *gssapi;
                        char *sia_pp;            /* for passport implementation*/
                        int *mech[SIASWMAX];    /* pointers to mechanism      */
                                                /* specific data              */
                        } SIAENTITY;

/***** sia collect routine interface definition *****/

typedef struct prompt_t
{
        unsigned char *prompt;
        unsigned char *result;
        int max_result_length;
        int min_result_length;
        int control_flags;
} prompt_t;

/* top level returns from sia routines */

#define SIASUCCESS      1  		/* success return */
#define SIAFAIL         0 		/* failure return */
#define SIASTOP		2		/* stop processing */


/**************************************/
/***** sia top level interface    *****/
/***** special purpose routines   *****/
/**************************************/

#ifdef	_NO_PROTO
extern int sia_init();
extern int sia_authorize();
extern int sia_chk_invoker();
extern int sia_collect_trm();
extern int sia_chg_finger();
extern int sia_chg_password();
extern int sia_chg_shell();
extern int sia_ses_init();
extern int sia_ses_authent();
extern int sia_ses_reauthent();
extern int sia_ses_suauthent();
extern int sia_ses_estab();
extern int sia_ses_launch();
extern int sia_ses_release();
#else	/* _NO_PROTO */
extern int sia_init(void);		/* only called from siainit command at*/
					/* boot time			      */

extern int sia_authorize(SIAENTITY *entity); /* only called internally for sia*/
					     /* authorization */

extern int sia_chk_invoker(void);	     /* called to check if process is */
					     /* sufficiently privialged	      */

extern int sia_collect_trm(int timeout, int rendition, unsigned char *title, int num_prompts, prompt_t *prompts); /* general collection routine for*/
					     /* terminals */
/**************************************/
/***** sia change secure info calls ***/
/**************************************/

extern int sia_chg_finger(int (*collect)(), char *username, int argc, char *argv[]);
extern int sia_chg_password(int (*collect)(), char *username, int argc, char *argv[]);
extern int sia_chg_shell(int (*collect)(), char *username, int argc, char *argv[]);

/*************************************/
/**** session processing calls	******/
/*************************************/


extern int sia_ses_init(SIAENTITY **entityhdl, int argc, char *argv[], char *hostname, char *username, char *tty, int colinput, char *gssapi);
extern int sia_ses_authent(int (*collect)(), char *password, SIAENTITY *entity);
extern int sia_ses_reauthent(int (*collect)(),  SIAENTITY *entity);
extern int sia_ses_suauthent(int (*collect)(),  SIAENTITY *entity);
extern int sia_ses_estab(int (*collect)(), SIAENTITY *entity);
extern int sia_ses_launch(int (*collect)(), SIAENTITY *entity);
extern int sia_ses_release(SIAENTITY **entityhdl);
#endif	/* _NO_PROTO */

#endif /* _SIA_H_ */
