IDENTIFICATION DIVISION.
PROGRAM-ID. REFORMAT.
*	COPYRIGHT (C) 1977
*	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.
*
*	THIS SOFTWARE IS FURNISHED UNDER A LICENSE FOR USE ONLY
*	ON A SINGLE COMPUTER SYSTEM AND MAY BE COPIED ONLY WITH
*	THE INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS
*	SOFTWARE, OR ANY OTHER COPIES THEREOF, MAY NOT BE
*	PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER PERSON
*	EXCEPT FOR USE ON SUCH SYSTEM AND TO ONE WHO AGREES TO
*	THESE LICENSE TERMS.  TITLE TO AND OWNERSHIP OF THE
*	SOFTWARE SHALL  AT ALL TIMES REMAIN IN DIGITAL EQUIPMENT 
*	CORPORATION.
*
*	THE INFORMATION IN THIS DOCUMENT IS SUBJECT TO CHANGE
*	WITHOUT NOTICE AND SHOULD NOT BE CONSTRUED
*	AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
*
*	DIGITAL EQUIPMENT CORPORATION ASSUMES NO RESPONSIBILITY
*	FOR THE USE OR RELIABILITY OF ITS SOFTWARE ON EQUIPMENT
*	WHICH IS NOT SUPPLIED BY DIGITAL EQUIPMENT CORPORATION.
*

*	THIS PROGRAM ACCEPTS A COBOL SOURCE PROGRAM
*	IN TERMINAL FORMAT AND TRANSFORMS IT INTO
*	A PROGRAM IN CONVENTIONAL FORMAT.
*
*	REFORMAT READS ONE LINE AHEAD (LINE2) IN ORDER TO TELL
*	HOW TO DEAL WITH THE CURRENT LINE (LINE1).
*	IF LINE 2 IS A CONTINUATION, IT RIGHT JUSTIFIES THE
*	STUFF ON LINE 1 BACK TO THE LAST SPACE OR THE FIRST QUOTE.
*	THE PROGRAM CONTAINS A NUMBER OF BAD CODING (FORMATTING)
*	PRACTICES. SO THAT IT CAN SERVE AS ITS OWN QUALITY
*	ASSURANCE TEST.
*
*	QUALITY ASSURANCE CONSISTS OF SUBMITTING THIS SOURCE
*	TEXT TO REFORMAT, PRODUCING SOURCE TEXT #1.  SOURCE
*	TEXT #1 IS THEN COMPILED, TO PRODUCE OBJECT CODE #1,
*	WHICH SHOULD BE AN EXECUTABLE COPY OF REFORMAT.  
*	THIS SAME SOURCE TEXT IS THEN RESUBMITTED TO OBJECT
*	CODE #1, PRODUCING SOURCE TEXT #2.  SOURCE TEXT #1
*	AND SOURCE TEXT #2 SHOULD BE IDENTICAL,
*	CHARACTER FOR CHARACTER.

ENVIRONMENT DIVISION.
CONFIGURATION SECTION.
SOURCE-COMPUTER.  PDP-11.
OBJECT-COMPUTER.  PDP-11.
INPUT-OUTPUT SECTION.
FILE-CONTROL.
	SELECT INFILE ASSIGN TO "SY:"
	STATUS IS FILESTATUS.

	SELECT OUTFILE ASSIGN TO "SY:"
	STATUS IS FILESTATUS.
DATA DIVISION.
FILE SECTION.
FD	INFILE
	LABEL RECORDS ARE STANDARD
	VALUE OF ID IS FILENAME.
01	LINE2.
	02  CHAR0OFLINE2	PIC X.
	02  LINE2CHARS		PIC X OCCURS 65.
	02  FILLER		PIC X(20).

FD	OUTFILE
	LABEL RECORDS ARE STANDARD
	VALUE OF ID IS FILENAME.
01	LINEOUT.
	02  LINESEQNO		PIC 9(5)0.
	02  ALLTEXTOUT.
	  03  LINECONTINUATION	PIC X.
	  03  TEXTOUT		PIC X OCCURS 65.
	02  LINEIDENT		PIC X(8).

WORKING-STORAGE SECTION.
01	NUMBEROFLINES		PIC Z(5).
01	LINENO			PIC 9(5).
01	LINE1.
	02  TEXTIN		PIC X OCCURS 66.
	88	SPECIALVALUE VALUE "/" "*" "-".
01	FILENAME		PIC X(20).
01	FILESTATUS		PIC XX.
01	RCHAR			PIC X.
01	TEXTCHAR		PIC X.
01	IDENT			PIC X(8).
01	PX			PIC XXXXXX VALUE "RFM - ".
01	C1			PIC 9(4) COMP.
01	C2			PIC 9(4) COMP.
01	C3			PIC 9(4) COMP.
01	C1TERMINATOR		PIC 9(4) COMP.
01	C2ATFIRSTQUOTE		PIC 9(4) COMP.
01	C2ATLASTSPACE		PIC 9(4) COMP.
01	RIGHTSHIFTAMOUNT	PIC 9(4) COMP.
01	HYPHEN			PIC X VALUE "-".
01	TB			PIC 9999 COMP VALUE 9.
01	TAB REDEFINES TB	PIC X.
01	FF			PIC 999 COMP VALUE 12.
01	FORMFEED REDEFINES FF		PIC X.
PROCEDURE DIVISION.
DECLARATIVES.
D1 SECTION. USE AFTER STANDARD ERROR PROCEDURE
		ON INFILE OUTFILE.
D1S1.
END DECLARATIVES.

INITIALIZATION SECTION.
I1.
	DISPLAY PX "INPUT FILE SPEC: " WITH NO ADVANCING.
	ACCEPT FILENAME.
	OPEN INPUT INFILE.
	IF FILESTATUS NOT = "00"
		DISPLAY PX "ERROR IN OPENING INPUT FILE"
		DISPLAY PX "TRY AGAIN" GO TO I1.
	MOVE LOW-VALUE TO LINE2.
	READ INFILE AT END
		DISPLAY PX "INPUT FILE IS EMPTY"
		CLOSE INFILE GO TO I1.
	IF FILESTATUS NOT = "00"
		DISPLAY PX "ERROR IN READING INPUT FILE"
		CLOSE INFILE GO TO I1.
I2.
	DISPLAY PX "OUTPUT FILE SPEC: " WITH NO ADVANCING.
	ACCEPT FILENAME.
	OPEN OUTPUT OUTFILE.
	IF FILESTATUS NOT = "00"
		DISPLAY PX "ERROR IN OPENING OUTPUT FILE"
		DISPLAY PX "TRY AGAIN" GO TO I2.
	DISPLAY PX "COLS 73 TO 80: " WITH NO ADVANCING.
	ACCEPT FILENAME.
	MOVE FILENAME TO IDENT.
	MOVE 0 TO LINENO.
MAIN SECTION.
M1.
	MOVE LINE2 TO LINE1.
	MOVE LOW-VALUE TO LINE2.
	READ INFILE AT END GO TO WINDUP.
	IF FILESTATUS NOT = "00"
		DISPLAY PX "ERROR IN READING INPUT FILE" GO TO M3.
	PERFORM MOVELINE1LEFT.
	IF CHAR0OFLINE2 = HYPHEN PERFORM RIGHTJUSTIFY.
	WRITE LINEOUT.
	IF FILESTATUS NOT = "00" GO TO M2.
	GO TO M1.
M2. DISPLAY PX "ERROR IN WRITING O
-		"UTPUT FILE".
M3. DISPLAY PX "REFORMATTING ABO
-				"RTED.".
	GO TO W2.
WINDUP.
	PERFORM MOVELINE1LEFT.
	WRITE LINEOUT.
	IF FILESTATUS NOT = "00" GO TO M2.
W2. CLOSE INFILE OUTFILE.
	MOVE LINENO TO NUMBEROFLINES.
	DISPLAY PX NUMBEROFLINES " LINES  PROCESSED.".
	GO TO INITIALIZATION.
MOVELINE1LEFT SECTION.
ML1.
*	INITIALIZE THE OUTPUT LINE.
	ADD 1 TO LINENO.
	MOVE LINENO TO LINESEQNO.
	MOVE SPACES TO ALLTEXTOUT.
	MOVE IDENT TO LINEIDENT.
	MOVE 0 TO C2ATFIRSTQUOTE.
	MOVE 0 TO C2ATLASTSPACE.
	MOVE 1 TO C1.
	MOVE 1 TO C2.
*	CHECK COLUMN 0 OF INPUT LINE FOR SPECIAL VALUES.
	IF TEXTIN(1) = FORMFEED
		MOVE "/" TO LINECONTINUATION GO TO ML8.
	IF SPECIALVALUE(1)
		MOVE TEXTIN(1) TO LINECONTINUATION
		ADD 1 TO C1.
*	THIS IS THE MAIN CHARACTER MOVEMENT LOOP.
ML2.
	IF C1 > 66 GO TO ML8.
	MOVE TEXTIN(C1) TO TEXTCHAR.
	IF TEXTCHAR = LOW-VALUE GO TO ML8.
	IF C2 > 65 GO TO ML8.
	IF TEXTCHAR = TAB GO TO ML4.
	IF TEXTCHAR = QUOTE
		IF C2ATFIRSTQUOTE = 0
			MOVE C2 TO C2ATFIRSTQUOTE.
	IF TEXTCHAR = SPACE MOVE C2 TO C2ATLASTSPACE.
	MOVE TEXTCHAR TO TEXTOUT(C2).
	ADD 1 TO C1.
	ADD 1 TO C2.
	GO TO ML2.
*	EACH LINE STARTING WITH "IF" SHOULD BE INDENTED
*	TO THE TAB STOP THAT IT IS TESTING.
ML4.
	IF C2 < 05 MOVE 05 TO C2 GO TO ML5.
		IF C2 < 13 MOVE 13 TO C2 GO TO ML5.
			IF C2 < 21 MOVE 21 TO C2 GO TO ML5.
				IF C2 < 29 MOVE 29 TO C2 GO TO ML5.
					IF C2 < 37 MOVE 37 TO C2 GO T
-	O ML5.					IF C2 < 45 MOVE 45 TO
	C2 GO TO ML5.					IF C2 < 53 MO
-	VE 53 TO C2 GO TO ML5.					IF C2
	< 61 MOVE 61 TO C2 GO TO ML5.
	IF C2 < 66 MOVE 66 TO C2.
ML5.
	SUBTRACT 1 FROM C2 GIVING C2ATLASTSPACE.
	ADD 1 TO C1.
	GO TO ML2.
ML8. EXIT.
RIGHTJUSTIFY SECTION.
*	RIGHT JUSTIFICATION IS DONE ON THE TAB-EXPANDED LINE,
*	HENCE THERE IS NO NEED TO FIGURE OUT WHERE YOU ARE
*	WITH REGARD TO TAB EXPANSION.
RJ1.
*	COMPUTE THE AMOUNT OF THE RIGHT SHIFT.
	SUBTRACT C2 FROM 66 GIVING RIGHTSHIFTAMOUNT.
	IF RIGHTSHIFTAMOUNT NOT > 0 GO TO RJ6.
*	SET UP C1 AND C2 AS SENDING AND RECEIVING POINTERS.
	SUBTRACT 1 FROM C2 GIVING C1.
	MOVE 65 TO C2.
*	NOW SEE WHETHER LINE2 CONTINUES A NONNUMERIC LITERAL.
	MOVE 1 TO C3.
RJ2.
	IF LINE2CHARS(C3) NOT = SPACE
	   IF LINE2CHARS(C3) NOT = TAB GO TO RJ22
	   ELSE
		ADD 1 TO C3
		IF C3 NOT > 65 GO TO RJ2
			ELSE GO TO RJ6.
*	FOUND THE FIRST NON-SPACE CHARACTER, IS IT A QUOTE?
RJ22.
	IF LINE2CHARS(C3) NOT = QUOTE GO TO RJ3.
*	YES, A NONNUMERIC LITERAL IS EXPECTED, SO JUST
*	SHIFT EVERYTHING TO THE RIGHT OF THE FIRST QUOTE.
	MOVE C2ATFIRSTQUOTE TO C1TERMINATOR.
	GO TO RJ4.
*	NO, THE CONTINUATION IS FOR A BROKEN WORD,
*	SO JUST SHIFT EVERYTHING TO THE RIGHT OF THE LAST SPACE.
RJ3.
	MOVE C2ATLASTSPACE TO C1TERMINATOR.
RJ4.
	MOVE	TEXTOUT(C1) TO TEXTOUT(C2).
	IF C1 = C1TERMINATOR GO TO RJ5.
	SUBTRACT 1 FROM C1.
	SUBTRACT 1 FROM C2.
	GO TO RJ4.
RJ5.
*	NOW BLANK OUT AREA SHIFTED ON LEFT
*	RIGHTJUSTIFYAMOUNT HAS NUMBER OF BLANKS
	SUBTRACT 1 FROM C2.
	MOVE	" " TO TEXTOUT(C2).
	SUBTRACT 1 FROM RIGHTSHIFTAMOUNT.
	IF RIGHTSHIFTAMOUNT NOT = 0 GO TO RJ5.
RJ6.
	EXIT.
