 $PASCAL ',7 92081-1X704 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM BMBKU;   (* Backup utilities routines *)      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18704                                        *)  ! !(* RELOC:   92081-16704                                        *)  ! !(*                                                             *)  ! !(* PGMR: <MRL>                                                 *)  ! !(*                                                             *)  ! (* Date last modified: <850416.1426>  !(*                                                             *)  ! !(***************************************************************)  !         $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types *)   $ Include '[BMCTV'  $    (* DBMON Constants, Types and Vars. *)    #$ Include '[BMSAM'  $    (* Main globals used by Samurai Segmenter *)  #     $ Include '[XDCIO'  $    (* DBCON I/O externals *)  $ Include '[XDTDY'  $    (* Timestamp externals *)  $ Include '[XBSDR'  $    (* Commonly used externals. *)   $ Include '[XDFMP'  $    (* File accessing externals *)   $ Include '[XWOCL'  $    (* Rootfile Open/close externals *)  $ Include '[XWPTS'  $    (* Make pointers externals *)  $ Include '[XWRTF'  $    (* Make pointers externals *)  $ List ON $   	$ Heapparms OFF $  	     "PROCEDURE backup_utilities_want_action  $ Alias 'Mon.BackupInfo' $;  "     LABEL 99;       VAR   
   request   : short_int;  
    rf_header : Rootfile_header_ptr_type;  
   db_num    : short_int;  
     
   save_logging : boolean; 
    save_access : db_access_type;     temp_timestamp : date_and_time_type;          need_to_close : boolean;       BEGIN (* backup_utilities_want_action *)         (**)   "   (* First check to see if the requested root file is already open. "     (* If it is open, get the dcb header from the open db table.       (* If not open, do a standard file open and close.      (**)          (**)   !   (* all messages from backup utilities have the rootfile name as !    (* the first parameter in the specific fields of the msg.     (**)          WITH mb_ptr^.dbmon.bu_status_change DO BEGIN         IF find_root (rootfile_name,                      db_num,                       workhorse_data,   
                    error) 
          THEN GOTO 99;            IF db_num < zero THEN BEGIN (* not open, so open it *)           need_to_close := true;            db_num := abs(db_num);   !         IF rt_open (rootfile_name, db_num, true (* exclusive *),  !                      workhorse_data, error)   
            THEN GOTO 99;  
              (* We only need first block of root file *)           WITH workhorse_data.opn_tbl_ptr^[db_num] DO BEGIN              rtbl_blk_len := one;              open_count   := one;              END; (* with *)            END (* then open it *)             ELSE IF db_num = zero THEN BEGIN (* can't open root *)           error := open_table_full_err;  	         GOTO 99;  	          END (* else..then *)   !      ELSE need_to_close := false; (* DBMON already has it open *) !       END; (* with *)              (* make a pointer to the root file header *)   "   IF make_rt_header_ptr (db_num, rf_header, workhorse_data, error)  " 
      THEN GOTO 99;  
            (* Perform the specific request *)          request := MB_ptr^.dbmon.request;      	   CASE request OF 	          (**)        (* This is used by the backup utilties         (*   (1) DBLOD - this is needed in order for DBLOD to make    !     (*       database PUT requests.  The database access must be  !      (*       'read/write' and logging must be off.  This has        (*       no affect on other users because DBLOD opens the       (*       database exclusively.        (**)            to_bm_bu_status_change_code : BEGIN           WITH rf_header^,mb_ptr^.dbmon.bu_status_change DO BEGIN    #           save_logging := flags.logging;   (* save old log status *)  # "           save_access := flags.access;     (* save old db access *) " "           flags.logging := bu_log_status;  (* assign new status *)  " #           flags.access :=  bu_db_access;   (* assign new db access *) #                (* return the old status to the user *)             WITH mb_ptr^.user.bu_status_change DO BEGIN                old_log_status := save_logging;                 old_db_access := save_access;                 END;  (* with *)             END;  (* with *)           mb_ptr^.user.request := to_user_bu_status_change_code;          END;           (**)        (*  This is needed by the backup utilities :        (*  (1) DBSTR - this is to get the current time,         (*      and roll forward log information in order to store         (*      it into the DBSTR tape label.       (**)            to_bm_get_bu_label_info_code : BEGIN           (* get current information for return *)              WITH MB_ptr^.user.get_bu_label_info, rf_header^ ,                workhorse_data DO BEGIN                 (**)   "           (* Create local timestamp and then move it to EMA (where  "            (* the message buffer is).              (**)                  create_timestamp (temp_timestamp);              IF move_timestamp (                   temp_timestamp,                   mb_ptr^.user.get_bu_label_info.cur_timestamp,                   date_and_time_len,                    error) THEN GOTO 99;                  cur_vol_xct := system_xaction_num;                  (* read the dbcon rfl info block *)             IF read_dbcon_table (                   dbcon_descriptor,                   dbc_rfl_info_blk,                   do_not_lock_dbcon_file,                   dbcon_block.dbcon_rfl_info_block.block,                   error) THEN GOTO 99;                  WITH dbcon_block.dbcon_rfl_info_block DO BEGIN                 cur_logical_rfl_vol := rfl_logical_name;                cur_logical_rfl_set := rflf_set_name;                 cur_vol_num := rflf_vol_num;                END;  (* with *)             END;  (* with *)            MB_ptr^.user.request := to_user_get_bu_label_info_code;    
        END;  (* begin *)  
          (**)        (* This is needed by the backup utilities       (* (1) DBSTR - to store the current backup time and  !     (*     roll forward log identification into the root file hdr !      (*     for the database being backed up. Also, the MW (db  !     (*     modified without rf logging) and MB (db modified since !      (*     backup) bits must be cleared.        (* (2) DBRST - to restore information into the         (*     above mentioned information into the root file hdr.         (*     This information comes from the DBSTR tape  !     (*     label;  it is the roll forward logging information at  !      (*     the time of the backup.        (**)            to_bm_restore_bu_label_info_code : BEGIN           (* store information into the root file *)      #        WITH MB_ptr^.dbmon.restore_bu_label_info, rf_header^ DO BEGIN  #            backup := bu_cur_time;              vol_xct := bu_vol_xct;              vol_num := bu_vol_num;              vol_nam := bu_logical_rfl_vol;              logical_rlf_set_nam := bu_logical_rfl_set;              flags.mw := false;              flags.mb := false;              END;  (* end with *)   "        mb_ptr^.user.request := to_user_restore_bu_label_info_code;  " 
        END;  (* begin *)  
           OTHERWISE BEGIN            error := corrupt_message_err;  	         GOTO 99;  	          END;            END;  (* case *)              rf_header^.flags.ha := true; (* root header was altered *)          (* Did we open the rootfile ourselves? *)  
   IF need_to_close  
       THEN IF rt_close (db_num, workhorse_data, error)           THEN GOTO 99;      99:          (* set up the global message_len *)     message_len := to_user_xxx_bu_label_info_mesg_len;       END; (* backup_utilities_want_action *)   $ Page $  #(*******************************************************************)  # #(*                    alter_get_rootfile_info_operation            *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To get/modify information in the rootfile for the backup     *)  # #(*    utilities.                                                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE alter_get_rootfile_info_operation               $ Alias 'Mon.RootfileInfo' $;       LABEL 99;  (* error label *)      VAR      db_num : short_int;       (* database number *)     rf_header : rootfile_header_ptr_type;     request_code : short_int;     get_flag : alter_rootfile_types;          need_to_close : boolean;       BEGIN          (* check to see if the root file is already open *)         (**)   "   (* First check to see if the requested root file is already open. "     (* If it is open, get the dcb header from the open db table.       (* If not open, do a standard file open and close.      (**)          WITH mb_ptr^.dbmon.alter_rootfile DO BEGIN         IF find_root (database,                       db_num,                       workhorse_data,   
                    error) 
          THEN GOTO 99;      !      IF db_num < zero THEN BEGIN (* DBMON doesn't have it open *) !          db_num := abs(db_num);            need_to_close := true;            IF rt_open (database, db_num, true (* exclusive *),                       workhorse_data, error)   
            THEN GOTO 99;  
              (* We only need first block of root file *)           WITH workhorse_data.opn_tbl_ptr^[db_num] DO BEGIN              rtbl_blk_len := one;              open_count   := one;              END; (* with *)                END      !      ELSE IF db_num = zero THEN BEGIN (* no room to open root *)  !          error := open_table_full_err;  	         GOTO 99;  	          END  !      ELSE need_to_close := false; (* DBMON already has it open *) !       END; (* with *)          (* make a pointer to the root file header *)   "   IF make_rt_header_ptr (db_num, rf_header, workhorse_data, error)  " 
      THEN GOTO 99;  
        (* Perform the specific request *)      request_code := mb_ptr^.dbmon.request;      CASE request_code OF             to_bm_get_rootfile_info_code :  BEGIN                get_flag := mb_ptr^.dbmon.get_rootfile_info.to_get;               WITH MB_ptr^.user, rf_header^ DO BEGIN               IF get_flag.logging_state THEN BEGIN                 utl_logst_mesg.db_log_status := flags.logging;                  request := to_user_utl_logst_mesg_code;  
               END;  
                 IF get_flag.accessibility THEN BEGIN                 utl_accst_mesg.db_acc_status := flags.access;                 request := to_user_utl_accst_mesg_code;  
               END;  
             END;  (* With *)           END; (* to_get case *)             to_bm_alter_rootfile_code :             WITH rf_header^,mb_ptr^.dbmon.alter_rootfile  DO BEGIN                IF to_alter.create_time THEN                 creation := create_tim;              IF to_alter.backup_time THEN                 backup := backup_tim;              IF to_alter.volume_number THEN                 vol_num := volume_num;               IF to_alter.first_trans THEN                 vol_xct := first_xact;               IF to_alter.volume_name THEN                 vol_nam := volume_nam;               IF to_alter.log_set_name THEN                  logical_rlf_set_nam :=  logset_nam;              IF to_alter.checksums THEN                 flags.cs := checksum;              IF to_alter.db_modified THEN                 flags.mb := db_changed;              IF to_alter.part_unlogged THEN                 flags.mw := db_unlogged;               IF to_alter.logging_state THEN                 flags.logging := log_state;              IF to_alter.accessibility THEN                 flags.access := db_access;               END;  (* with *)      
      END;  (* end case *) 
            rf_header^.flags.ha := true; (* header was altered *)         (* Post and close the file if not already open by DBMON *)   
   IF need_to_close  
       THEN IF rt_close (db_num, workhorse_data, error)           THEN GOTO 99;      99 :      &   (* set the global 'message_len' to the maximum size message we'd send *)  &    message_len := to_user_error_msg_len;      END;  (* alter_get_rootfile_info operation *)       .  