$PASCAL ',7 92081-1X696 REV.2440' $     
$ Include '[LBOPT'  $ 
    PROGRAM database_close;      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18696                                        *)   (* RELOC:   92081-16696                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)   (* Date last modified: <840912.1405>  (*                                                             *)   (***************************************************************)           $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types *)   $ Include '[BMCTV'  $    (* DBMON Constants, Types and Vars. *)    #$ Include '[BMSAM'  $    (* Main globals used by Samurai Segmenter *)  #     $ Include '[XBSDR'  $    (* Commonly used externals. *)   $ Include '[XBLOG'  $    (* Log record routines. *)   $ Include '[XLGLB'  $    (* Log record routines. *)   $ Include '[XWOCL'  $    (* Open/close routines. *)   $ Include '[XWRTF'  $    (* Root read/write routines. *)  $ Include '[XBUCP'  $    (* Checkpoint external def. *)   $ Include '[XBLUR'  $    (* Lock/Unlock routines *)   $ List ON $       "(******************************************************************) " "(*                                                                *) " "(* procedure CLOSE_OPERATION:                                     *) " "(*                                                                *) " "(* Purpose: Given an index into the OPEN DATABASE table,          *) " "(* to post the rootfile blocks if dirty (or perform a checkpoint  *) " "(* when that time comes), followed by the removal of the rootfile *) " "(* from memory and closing the file.                              *) " "(*                                                                *) " "(* Inputs: The global message buffer.                             *) " "(*                                                                *) " "(* Output: Non-zero error if any error occurs.                    *) " "(*                                                                *) " "(* Possible errors: Disc read/write errors.                       *) " "(*                                                                *) " "(******************************************************************) "     	$ Heapparms OFF $  	     PROCEDURE close_operation   $ Alias 'Mon.DbaseClose' $;       LABEL 99, (* error label *)         88; (* log record creation error *)               VAR   
   loop : short_int; 
 $   log_block_num : long_int;  (* TUF block # where log rec may reside *) $ 
   save_error : Short_int; 
    proc_id    : Process_description_type;   
   coordx     : Short_int; 
         BEGIN (* Close_operation *)       WITH workhorse_data DO BEGIN        message_len := to_user_cls_mesg_len;         mb_ptr^.user.request := to_user_cls_code;        (**)     (* Save some of the important message info.    (**)         WITH mb_ptr^.dbmon.close DO BEGIN        rootx   := user.db_id;       local_db_number := user.local_db_num; 
      proc_id := user.proc; 
      END; (* with *) 
         
   IF find_process (rootx, 
                     local_db_number,                      proc_id, 
                    coordx, 
                    workhorse_data,  
                    error) 
	      THEN GOTO 88; 	                   (**)    (* Construct the DBCLS log record.    (**)         IF opn_tbl_ptr^[rootx].logging_status        THEN BEGIN           IF make_log_record (dbcls_log_code,                               dbcls_log_rec_size,                               logrec_ptr,                              log_block_num,                              error)             THEN GOTO 88;               WITH logrec_ptr^.close DO BEGIN             proc_info := proc_id;             db_name_id := opn_tbl_ptr^[rootx].root_file_name;              END;  (* with *)              END;  (* then *)            (**)     (* Release any locks owned by the program on this database.     (**)          remove_locks (rootx, coordx, workhorse_data);             (**)      (* IF the open count for the database is one, then   "   (* release the run table from memory, (* perform a checkpoint *)  "    (* and close the rootfile, (which releases the entry in  
   (* the OPEN DB TABLE).  
    (**)          WITH opn_tbl_ptr^[rootx] DO  
      IF open_count = one  
          THEN BEGIN  (* we have to do a checkpoint. *)              IF check_point (workhorse_data,                               error)                 THEN GOTO 99;                  IF rt_close (rootx, workhorse_data, error)                 THEN GOTO 99;              (* RT_Close sets open count to zero. *)   
            END (* then *) 
              ELSE open_count := pred(open_count);          (**)      (* Now to release the COORDINATION TABLE entry belonging      (* to the user who closed the database.     (**)          IMAGE_users^[coordx].open_mode := zero;         open_databases := open_databases - one;          99:  (* error processing section. *)        IF (error <> no_image_err)        THEN           IF (opn_tbl_ptr^[rootx].logging_status)             THEN remove_log_record;     88:  (* error processing prior to making log record. *)     
   IF (error <> zero) 
       THEN message_len := to_user_intr_header_len;     
   valid_pointers := false; 
     END; (* with workhorse_data *)      
END; (* CLOSE_OPERATION *) 
 .  